/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ,\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0014\u0010\u0015\u001a\u00020\u000f*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isHiddenForThisCallSite", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isHidden", "isSuperCall", "Lorg/jetbrains/kotlin/fir/FirElement;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckerSinkKt\n*L\n1#1,842:1\n21#2:843\n28#3,2:844\n22#3,9:846\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n*L\n756#1:843\n759#1:844,2\n759#1:846,9\n*E\n"})
public final class CheckHiddenDeclaration
extends ResolutionStage {
    @NotNull
    public static final CheckHiddenDeclaration INSTANCE = new CheckHiddenDeclaration();

    private CheckHiddenDeclaration() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        DeprecationInfo deprecation;
        FirCallableSymbol symbol2;
        FirBasedSymbol<?> firBasedSymbol = candidate2.getSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return Unit.INSTANCE;
        }
        FirCallableSymbol $this$isActual$iv = symbol2 = firCallableSymbol;
        boolean $i$f$isActual2 = false;
        if ($this$isActual$iv.getRawStatus().isActual()) {
            return Unit.INSTANCE;
        }
        DeprecationInfo deprecationInfo = deprecation = DeprecationUtilsKt.getDeprecation(symbol2, context2.getSession(), callInfo.getCallSite());
        if ((deprecationInfo != null ? deprecationInfo.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN || this.isHiddenForThisCallSite(symbol2, callInfo, candidate2, context2.getSession())) {
            void $this$yieldDiagnostic$iv;
            CheckerSink $i$f$isActual2 = sink;
            ResolutionDiagnostic diagnostic$iv = HiddenCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final boolean isHiddenForThisCallSite(FirCallableSymbol<?> symbol2, CallInfo callInfo, Candidate candidate2, FirSession session2) {
        boolean isSuperCall = this.isSuperCall(callInfo.getCallSite(), session2);
        if (((FirCallableDeclaration)symbol2.getFir()).getDispatchReceiverType() == null || !(symbol2 instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        if (this.isHidden(symbol2, isSuperCall)) {
            return true;
        }
        FirScope firScope2 = candidate2.getOriginScope();
        FirTypeScope firTypeScope = firScope2 instanceof FirTypeScope ? (FirTypeScope)firScope2 : null;
        if (firTypeScope == null) {
            return false;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(isSuperCall, result2){
            final /* synthetic */ boolean $isSuperCall;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$isSuperCall = $isSuperCall;
                this.$result = $result;
                super(1);
            }

            public final ProcessorAction invoke(FirNamedFunctionSymbol it) {
                ProcessorAction processorAction;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (CheckHiddenDeclaration.access$isHidden(CheckHiddenDeclaration.INSTANCE, it, this.$isSuperCall)) {
                    this.$result.element = true;
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
                return processorAction;
            }
        }));
        return result2.element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuperCall(FirElement $this$isSuperCall, FirSession session2) {
        if (!($this$isSuperCall instanceof FirQualifiedAccessExpression)) return false;
        FirExpression firExpression2 = ((FirQualifiedAccessExpression)$this$isSuperCall).getExplicitReceiver();
        if (!((firExpression2 != null ? ReferenceUtilsKt.toReference(firExpression2, session2) : null) instanceof FirSuperReference)) return false;
        return true;
    }

    private final boolean isHidden(FirCallableSymbol<?> $this$isHidden, boolean isSuperCall) {
        FirCallableDeclaration fir = (FirCallableDeclaration)$this$isHidden.getFir();
        return !isSuperCall && Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenEverywhereBesideSuperCalls(fir), (Object)true) || Intrinsics.areEqual((Object)DeprecationUtilsKt.isHiddenToOvercomeSignatureClash(fir), (Object)true);
    }

    public static final /* synthetic */ boolean access$isHidden(CheckHiddenDeclaration $this, FirCallableSymbol $receiver, boolean isSuperCall) {
        return $this.isHidden($receiver, isSuperCall);
    }
}

