/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunctionWithLateBinding;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrPropertyWithLateBinding;
import org.jetbrains.kotlin.ir.overrides.FakeOverrideBuilderStrategyKt;
import org.jetbrains.kotlin.ir.overrides.IrFakeOverrideBuilderKt;
import org.jetbrains.kotlin.ir.overrides.IrUnimplementedOverridesStrategy;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B'\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ+\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H&\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0018J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0018H$J\u0018\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020\u0018H$J\u0016\u0010)\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fR \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/ir/overrides/FakeOverrideBuilderStrategy;", "", "friendModules", "", "", "", "unimplementedOverridesStrategy", "Lorg/jetbrains/kotlin/ir/overrides/IrUnimplementedOverridesStrategy;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/ir/overrides/IrUnimplementedOverridesStrategy;)V", "fakeOverrideMember", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "superType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "member", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "inFile", "R", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isInFriendModules", "", "fromModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "toModule", "isVisibleForOverrideInClass", "original", "linkFakeOverride", "", "fakeOverride", "compatibilityMode", "linkFunctionFakeOverride", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunctionWithLateBinding;", "manglerCompatibleMode", "linkPropertyFakeOverride", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrPropertyWithLateBinding;", "postProcessGeneratedFakeOverride", "ir.tree"})
public abstract class FakeOverrideBuilderStrategy {
    @NotNull
    private final Map<String, Collection<String>> friendModules;
    @NotNull
    private final IrUnimplementedOverridesStrategy unimplementedOverridesStrategy;

    public FakeOverrideBuilderStrategy(@NotNull Map<String, ? extends Collection<String>> friendModules, @NotNull IrUnimplementedOverridesStrategy unimplementedOverridesStrategy) {
        Intrinsics.checkNotNullParameter(friendModules, (String)"friendModules");
        Intrinsics.checkNotNullParameter((Object)unimplementedOverridesStrategy, (String)"unimplementedOverridesStrategy");
        this.friendModules = friendModules;
        this.unimplementedOverridesStrategy = unimplementedOverridesStrategy;
    }

    @Nullable
    public final IrOverridableMember fakeOverrideMember(@NotNull IrType superType2, @NotNull IrOverridableMember member2, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)superType2, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)member2, (String)"member");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return IrFakeOverrideBuilderKt.isOverridableMemberOrAccessor(member2) && this.isVisibleForOverrideInClass(member2, clazz) ? FakeOverrideBuilderStrategyKt.buildFakeOverrideMember(superType2, member2, clazz, this.unimplementedOverridesStrategy) : null;
    }

    public final void postProcessGeneratedFakeOverride(@NotNull IrOverridableMember fakeOverride, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)fakeOverride, (String)"fakeOverride");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        this.unimplementedOverridesStrategy.postProcessGeneratedFakeOverride((IrOverridableDeclaration)fakeOverride, clazz);
    }

    public final void linkFakeOverride(@NotNull IrOverridableMember fakeOverride, boolean compatibilityMode) {
        Intrinsics.checkNotNullParameter((Object)fakeOverride, (String)"fakeOverride");
        IrOverridableMember irOverridableMember = fakeOverride;
        if (irOverridableMember instanceof IrFunctionWithLateBinding) {
            this.linkFunctionFakeOverride((IrFunctionWithLateBinding)fakeOverride, compatibilityMode);
        } else if (irOverridableMember instanceof IrPropertyWithLateBinding) {
            this.linkPropertyFakeOverride((IrPropertyWithLateBinding)fakeOverride, compatibilityMode);
        } else {
            throw new IllegalStateException(("Unexpected fake override: " + fakeOverride).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInFriendModules(ModuleDescriptor fromModule, ModuleDescriptor toModule) {
        String string2 = fromModule.getName().asStringStripSpecialMarkers();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringStripSpecialMarkers(...)");
        String fromModuleName = string2;
        String string3 = toModule.getName().asStringStripSpecialMarkers();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asStringStripSpecialMarkers(...)");
        String toModuleName = string3;
        if (Intrinsics.areEqual((Object)fromModuleName, (Object)toModuleName)) return true;
        Collection<String> collection = this.friendModules.get(fromModuleName);
        if (collection == null) return false;
        if (!collection.contains(toModuleName)) return false;
        return true;
    }

    private final boolean isVisibleForOverrideInClass(IrOverridableMember original, IrClass clazz) {
        boolean bl;
        if (DescriptorVisibilities.isPrivate(original.getVisibility())) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)original.getVisibility(), (Object)DescriptorVisibilities.INVISIBLE_FAKE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)original.getVisibility(), (Object)DescriptorVisibilities.INTERNAL)) {
            ModuleDescriptor thisModule = IrUtilsKt.getPackageFragment(clazz).getModuleDescriptor();
            ModuleDescriptor memberModule = IrUtilsKt.getPackageFragment(original).getModuleDescriptor();
            bl = Intrinsics.areEqual((Object)thisModule, (Object)memberModule) ? true : (this.isInFriendModules(thisModule, memberModule) ? true : IrUtilsKt.hasAnnotation((IrAnnotationContainer)original, StandardClassIds.Annotations.INSTANCE.getPublishedApi()));
        } else {
            bl = original.getVisibility().visibleFromPackage(IrUtilsKt.getPackageFragment(clazz).getPackageFqName(), IrUtilsKt.getPackageFragment(original).getPackageFqName());
        }
        return bl;
    }

    public abstract <R> R inFile(@Nullable IrFile var1, @NotNull Function0<? extends R> var2);

    protected abstract void linkFunctionFakeOverride(@NotNull IrFunctionWithLateBinding var1, boolean var2);

    protected abstract void linkPropertyFakeOverride(@NotNull IrPropertyWithLateBinding var1, boolean var2);
}

