/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import com.intellij.util.containers.ObjectIntHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002<=B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010#\u001a\u00020$H\u0016J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0006JD\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010\bH\u0016JJ\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u0006J\u0010\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020$2\u0006\u0010/\u001a\u000200H\u0002J\b\u00102\u001a\u00020\bH\u0016J\u0010\u00103\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\bH\u0002J\b\u00104\u001a\u00020\u0003H\u0016J*\u00105\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)2\u000e\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002J\b\u00107\u001a\u00020$H\u0016J\u0010\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020\u0006H\u0016J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\u0006H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder;", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMapBuilder;", "generatedFile", "Ljava/io/File;", "getCurrentOutputColumn", "Lkotlin/Function0;", "", "pathPrefix", "", "(Ljava/io/File;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "currentMappingIsEmpty", "", "names", "Lcom/intellij/util/containers/ObjectIntHashMap;", "orderedNames", "", "orderedSourceContentSuppliers", "Ljava/util/function/Supplier;", "Ljava/io/Reader;", "orderedSources", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "previousGeneratedColumn", "previousMappingOffset", "previousNameIndex", "previousPreviousNameIndex", "previousPreviousSourceColumn", "previousPreviousSourceIndex", "previousPreviousSourceLine", "previousSourceColumn", "previousSourceIndex", "previousSourceLine", "sources", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder$SourceKey;", "addEmptyMapping", "", "outputColumn", "addMapping", "source", "fileIdentity", "", "sourceContent", "sourceLine", "sourceColumn", "name", "appendSources", "json", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonObject;", "appendSourcesContent", "build", "getNameIndex", "getOutFile", "getSourceIndex", "contentSupplier", "newLine", "skipLinesAtBeginning", "count", "startMapping", "column", "Base64VLQ", "SourceKey", "js.sourcemap"})
@SourceDebugExtension(value={"SMAP\nSourceMap3Builder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMap3Builder.kt\norg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1618#2,3:247\n1618#2,3:250\n1618#2,3:253\n1#3:256\n*S KotlinDebug\n*F\n+ 1 SourceMap3Builder.kt\norg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder\n*L\n51#1:247,3\n59#1:250,3\n65#1:253,3\n*E\n"})
public final class SourceMap3Builder
implements SourceMapBuilder {
    @Nullable
    private final File generatedFile;
    @NotNull
    private final Function0<Integer> getCurrentOutputColumn;
    @NotNull
    private final String pathPrefix;
    @NotNull
    private final StringBuilder out;
    @NotNull
    private final ObjectIntHashMap<SourceKey> sources;
    @NotNull
    private final List<String> orderedSources;
    @NotNull
    private final List<Supplier<Reader>> orderedSourceContentSuppliers;
    @NotNull
    private final ObjectIntHashMap<String> names;
    @NotNull
    private final List<String> orderedNames;
    private int previousNameIndex;
    private int previousPreviousNameIndex;
    private int previousGeneratedColumn;
    private int previousSourceIndex;
    private int previousSourceLine;
    private int previousSourceColumn;
    private int previousMappingOffset;
    private int previousPreviousSourceIndex;
    private int previousPreviousSourceLine;
    private int previousPreviousSourceColumn;
    private boolean currentMappingIsEmpty;

    public SourceMap3Builder(@Nullable File generatedFile, @NotNull Function0<Integer> getCurrentOutputColumn, @NotNull String pathPrefix) {
        Intrinsics.checkNotNullParameter(getCurrentOutputColumn, (String)"getCurrentOutputColumn");
        Intrinsics.checkNotNullParameter((Object)pathPrefix, (String)"pathPrefix");
        this.generatedFile = generatedFile;
        this.getCurrentOutputColumn = getCurrentOutputColumn;
        this.pathPrefix = pathPrefix;
        this.out = new StringBuilder(8192);
        this.sources = new ObjectIntHashMap();
        this.orderedSources = new ArrayList();
        this.orderedSourceContentSuppliers = new ArrayList();
        this.names = new ObjectIntHashMap();
        this.orderedNames = new ArrayList();
        this.previousGeneratedColumn = -1;
        this.currentMappingIsEmpty = true;
    }

    @Override
    @NotNull
    public File getOutFile() {
        File file2 = this.generatedFile;
        Intrinsics.checkNotNull((Object)file2);
        return new File(file2.getParentFile(), this.generatedFile.getName() + ".map");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String build() {
        void destination$iv;
        void $this$mapTo$iv;
        Object object;
        String string2;
        Map<String, JsonNode> map;
        JsonObject json = new JsonObject(new Pair[0]);
        json.getProperties().put("version", new JsonNumber(3.0));
        if (this.generatedFile != null) {
            map = json.getProperties();
            string2 = "file";
            String string3 = this.generatedFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            object = new JsonString(string3);
            map.put(string2, (JsonNode)object);
        }
        this.appendSources(json);
        this.appendSourcesContent(json);
        map = json.getProperties();
        string2 = "names";
        object = this.orderedNames;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string4 = (String)item$iv;
            void var11_11 = destination$iv;
            boolean bl = false;
            var11_11.add(new JsonString((String)it));
        }
        List list2 = (List)destination$iv;
        object = new JsonArray(list2);
        map.put(string2, (JsonNode)object);
        map = json.getProperties();
        string2 = "mappings";
        String string5 = this.out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        object = new JsonString(string5);
        map.put(string2, (JsonNode)object);
        return json.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void appendSources(JsonObject json) {
        void destination$iv;
        void $this$mapTo$iv;
        Map<String, JsonNode> map = json.getProperties();
        String string2 = "sources";
        Object object = this.orderedSources;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string3 = (String)item$iv;
            void var11_11 = destination$iv;
            boolean bl = false;
            var11_11.add(new JsonString(this.pathPrefix + (String)it));
        }
        List list2 = (List)destination$iv;
        object = new JsonArray(list2);
        map.put(string2, (JsonNode)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void appendSourcesContent(JsonObject json) {
        void destination$iv;
        void $this$mapTo$iv;
        Map<String, JsonNode> map = json.getProperties();
        String string2 = "sourcesContent";
        Object object = this.orderedSourceContentSuppliers;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Object object2;
            Supplier supplier = (Supplier)item$iv;
            void var15_18 = destination$iv;
            boolean bl = false;
            try {
                JsonNode jsonNode;
                void it;
                object2 = (Closeable)it.get();
                Throwable throwable = null;
                try {
                    Reader reader = (Reader)object2;
                    boolean bl2 = false;
                    jsonNode = reader != null ? (JsonNode)new JsonString(TextStreamsKt.readText((Reader)reader)) : (JsonNode)JsonNull.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                object2 = jsonNode;
            }
            catch (IOException e) {
                System.err.println("An exception occurred during embedding sources into source map");
                e.printStackTrace();
                object2 = JsonNull.INSTANCE;
            }
            var15_18.add(object2);
        }
        List list2 = (List)destination$iv;
        object = new JsonArray(list2);
        map.put(string2, (JsonNode)object);
    }

    @Override
    public void newLine() {
        this.out.append(';');
        this.previousGeneratedColumn = -1;
    }

    @Override
    public void skipLinesAtBeginning(int count) {
        this.out.insert(0, StringsKt.repeat((CharSequence)";", (int)count));
    }

    private final int getSourceIndex(String source, Object fileIdentity, Supplier<Reader> contentSupplier2) {
        SourceKey key = new SourceKey(source, fileIdentity);
        int sourceIndex = this.sources.get((Object)key);
        if (sourceIndex == -1) {
            sourceIndex = this.orderedSources.size();
            this.sources.put((Object)key, sourceIndex);
            this.orderedSources.add(source);
            this.orderedSourceContentSuppliers.add(contentSupplier2);
        }
        return sourceIndex;
    }

    private final int getNameIndex(String name2) {
        int nameIndex = this.names.get((Object)name2);
        if (nameIndex == -1) {
            nameIndex = this.orderedNames.size();
            this.names.put((Object)name2, nameIndex);
            this.orderedNames.add(name2);
        }
        return nameIndex;
    }

    @Override
    public void addMapping(@NotNull String source, @Nullable Object fileIdentity, @NotNull Supplier<Reader> sourceContent, int sourceLine, int sourceColumn, @Nullable String name2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(sourceContent, (String)"sourceContent");
        this.addMapping(source, fileIdentity, sourceContent, sourceLine, sourceColumn, name2, ((Number)this.getCurrentOutputColumn.invoke()).intValue());
    }

    public final void addMapping(@NotNull String source, @Nullable Object fileIdentity, @NotNull Supplier<Reader> sourceContent, int sourceLine, int sourceColumn, @Nullable String name2, int outputColumn) {
        int nameIndex;
        int n;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(sourceContent, (String)"sourceContent");
        int sourceIndex = this.getSourceIndex(StringsKt.replace$default((String)source, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), fileIdentity, sourceContent);
        String string2 = name2;
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            n = this.getNameIndex(p0);
        } else {
            n = nameIndex = -1;
        }
        if (!this.currentMappingIsEmpty && this.previousSourceIndex == sourceIndex && this.previousSourceLine == sourceLine && this.previousSourceColumn == sourceColumn) {
            return;
        }
        this.startMapping(outputColumn);
        Base64VLQ.INSTANCE.encode(this.out, sourceIndex - this.previousSourceIndex);
        this.previousSourceIndex = sourceIndex;
        Base64VLQ.INSTANCE.encode(this.out, sourceLine - this.previousSourceLine);
        this.previousSourceLine = sourceLine;
        Base64VLQ.INSTANCE.encode(this.out, sourceColumn - this.previousSourceColumn);
        this.previousSourceColumn = sourceColumn;
        if (nameIndex >= 0) {
            Base64VLQ.INSTANCE.encode(this.out, nameIndex - this.previousNameIndex);
            this.previousNameIndex = nameIndex;
        }
        this.currentMappingIsEmpty = false;
    }

    @Override
    public void addEmptyMapping() {
        if (!this.currentMappingIsEmpty) {
            this.startMapping(((Number)this.getCurrentOutputColumn.invoke()).intValue());
            this.currentMappingIsEmpty = true;
        }
    }

    public final void addEmptyMapping(int outputColumn) {
        if (!this.currentMappingIsEmpty) {
            this.startMapping(outputColumn);
            this.currentMappingIsEmpty = true;
        }
    }

    private final void startMapping(int column) {
        boolean newGroupStarted;
        boolean bl = newGroupStarted = this.previousGeneratedColumn == -1;
        if (newGroupStarted) {
            this.previousGeneratedColumn = 0;
        }
        int columnDiff = column - this.previousGeneratedColumn;
        if (!newGroupStarted) {
            this.out.append(',');
        }
        if (columnDiff > 0 || newGroupStarted) {
            Base64VLQ.INSTANCE.encode(this.out, columnDiff);
            this.previousGeneratedColumn = column;
            this.previousMappingOffset = this.out.length();
            this.previousPreviousSourceIndex = this.previousSourceIndex;
            this.previousPreviousSourceLine = this.previousSourceLine;
            this.previousPreviousSourceColumn = this.previousSourceColumn;
            this.previousPreviousNameIndex = this.previousNameIndex;
        } else {
            this.out.setLength(this.previousMappingOffset);
            this.previousSourceIndex = this.previousPreviousSourceIndex;
            this.previousSourceLine = this.previousPreviousSourceLine;
            this.previousSourceColumn = this.previousPreviousSourceColumn;
            this.previousNameIndex = this.previousPreviousNameIndex;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder$Base64VLQ;", "", "()V", "BASE64_MAP", "", "getBASE64_MAP$annotations", "VLQ_BASE", "", "VLQ_BASE_MASK", "VLQ_BASE_SHIFT", "VLQ_CONTINUATION_BIT", "encode", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "value", "toVLQSigned", "js.sourcemap"})
    private static final class Base64VLQ {
        @NotNull
        public static final Base64VLQ INSTANCE = new Base64VLQ();
        private static final int VLQ_BASE_SHIFT = 5;
        private static final int VLQ_BASE = 32;
        private static final int VLQ_BASE_MASK = 31;
        private static final int VLQ_CONTINUATION_BIT = 32;
        @NotNull
        private static final char[] BASE64_MAP;

        private Base64VLQ() {
        }

        private static /* synthetic */ void getBASE64_MAP$annotations() {
        }

        private final int toVLQSigned(int value2) {
            return value2 < 0 ? (-value2 << 1) + 1 : value2 << 1;
        }

        public final void encode(@NotNull StringBuilder out, int value2) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int value3 = this.toVLQSigned(value2);
            do {
                int digit = value3 & 0x1F;
                if ((value3 >>>= 5) > 0) {
                    digit |= 0x20;
                }
                out.append(BASE64_MAP[digit]);
            } while (value3 > 0);
        }

        static {
            char[] cArray = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            BASE64_MAP = cArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u00c2\u0003J\u001f\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder$SourceKey;", "", "sourcePath", "", "fileIdentity", "(Ljava/lang/String;Ljava/lang/Object;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "js.sourcemap"})
    private static final class SourceKey {
        @NotNull
        private final String sourcePath;
        @Nullable
        private final Object fileIdentity;

        public SourceKey(@NotNull String sourcePath, @Nullable Object fileIdentity) {
            Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
            this.sourcePath = sourcePath;
            this.fileIdentity = fileIdentity;
        }

        private final String component1() {
            return this.sourcePath;
        }

        private final Object component2() {
            return this.fileIdentity;
        }

        @NotNull
        public final SourceKey copy(@NotNull String sourcePath, @Nullable Object fileIdentity) {
            Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
            return new SourceKey(sourcePath, fileIdentity);
        }

        public static /* synthetic */ SourceKey copy$default(SourceKey sourceKey, String string2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                string2 = sourceKey.sourcePath;
            }
            if ((n & 2) != 0) {
                object = sourceKey.fileIdentity;
            }
            return sourceKey.copy(string2, object);
        }

        @NotNull
        public String toString() {
            return "SourceKey(sourcePath=" + this.sourcePath + ", fileIdentity=" + this.fileIdentity + ')';
        }

        public int hashCode() {
            int result2 = this.sourcePath.hashCode();
            result2 = result2 * 31 + (this.fileIdentity == null ? 0 : this.fileIdentity.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceKey)) {
                return false;
            }
            SourceKey sourceKey = (SourceKey)other;
            if (!Intrinsics.areEqual((Object)this.sourcePath, (Object)sourceKey.sourcePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fileIdentity, (Object)sourceKey.fileIdentity);
        }
    }
}

