/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.abi.AbiAnnotatedEntity;
import org.jetbrains.kotlin.library.abi.AbiClass;
import org.jetbrains.kotlin.library.abi.AbiCompoundName;
import org.jetbrains.kotlin.library.abi.AbiDeclaration;
import org.jetbrains.kotlin.library.abi.AbiProperty;
import org.jetbrains.kotlin.library.abi.AbiQualifiedName;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExperimentalLibraryAbiReader
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bg\u0018\u00002\u00020\u0001:\u0004\u000b\f\r\u000eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001a\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\n\u00f8\u0001\u0001\u0082\u0002\r\n\u0005\b\u00a1\u001e0\u0001\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "", "isDeclarationExcluded", "", "declaration", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "isPackageExcluded", "packageName", "Lorg/jetbrains/kotlin/library/abi/AbiCompoundName;", "isPackageExcluded-6OaPNJE", "(Ljava/lang/String;)Z", "Composite", "ExcludedClasses", "ExcludedPackages", "NonPublicMarkerAnnotations", "kotlin-util-klib-abi"})
public interface AbiReadingFilter {
    default public boolean isPackageExcluded-6OaPNJE(@NotNull String packageName2) {
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        return false;
    }

    default public boolean isDeclarationExcluded(@NotNull AbiDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$Composite;", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "filters", "", "(Ljava/util/List;)V", "", "[Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "isDeclarationExcluded", "", "declaration", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "isPackageExcluded", "packageName", "Lorg/jetbrains/kotlin/library/abi/AbiCompoundName;", "isPackageExcluded-6OaPNJE", "(Ljava/lang/String;)Z", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReader.kt\norg/jetbrains/kotlin/library/abi/AbiReadingFilter$Composite\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n37#2,2:98\n*S KotlinDebug\n*F\n+ 1 LibraryAbiReader.kt\norg/jetbrains/kotlin/library/abi/AbiReadingFilter$Composite\n*L\n80#1:98,2\n*E\n"})
    public static final class Composite
    implements AbiReadingFilter {
        @NotNull
        private final AbiReadingFilter[] filters;

        public Composite(@NotNull List<? extends AbiReadingFilter> filters) {
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            Collection $this$toTypedArray$iv = filters;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.filters = thisCollection$iv.toArray(new AbiReadingFilter[0]);
        }

        @Override
        public boolean isPackageExcluded-6OaPNJE(@NotNull String packageName2) {
            Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
            for (AbiReadingFilter filter2 : this.filters) {
                if (!filter2.isPackageExcluded-6OaPNJE(packageName2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isDeclarationExcluded(@NotNull AbiDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            for (AbiReadingFilter filter2 : this.filters) {
                if (!filter2.isDeclarationExcluded(declaration)) continue;
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$ExcludedClasses;", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "excludedClassNames", "", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "(Ljava/util/Collection;)V", "", "isDeclarationExcluded", "", "declaration", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "kotlin-util-klib-abi"})
    public static final class ExcludedClasses
    implements AbiReadingFilter {
        @NotNull
        private final Set<AbiQualifiedName> excludedClassNames;

        public ExcludedClasses(@NotNull Collection<AbiQualifiedName> excludedClassNames) {
            Intrinsics.checkNotNullParameter(excludedClassNames, (String)"excludedClassNames");
            this.excludedClassNames = CollectionsKt.toSet((Iterable)excludedClassNames);
        }

        @Override
        public boolean isDeclarationExcluded(@NotNull AbiDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            return declaration instanceof AbiClass && this.excludedClassNames.contains(declaration.getQualifiedName());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$ExcludedPackages;", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "excludedPackageNames", "", "Lorg/jetbrains/kotlin/library/abi/AbiCompoundName;", "(Ljava/util/Collection;)V", "", "isPackageExcluded", "", "packageName", "isPackageExcluded-6OaPNJE", "(Ljava/lang/String;)Z", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReader.kt\norg/jetbrains/kotlin/library/abi/AbiReadingFilter$ExcludedPackages\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1745#2,3:98\n*S KotlinDebug\n*F\n+ 1 LibraryAbiReader.kt\norg/jetbrains/kotlin/library/abi/AbiReadingFilter$ExcludedPackages\n*L\n47#1:98,3\n*E\n"})
    public static final class ExcludedPackages
    implements AbiReadingFilter {
        @NotNull
        private final Set<AbiCompoundName> excludedPackageNames;

        public ExcludedPackages(@NotNull Collection<AbiCompoundName> excludedPackageNames) {
            Intrinsics.checkNotNullParameter(excludedPackageNames, (String)"excludedPackageNames");
            this.excludedPackageNames = CollectionsKt.toSet((Iterable)excludedPackageNames);
        }

        @Override
        public boolean isPackageExcluded-6OaPNJE(@NotNull String packageName2) {
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
                if (this.excludedPackageNames.isEmpty()) {
                    bl = false;
                } else if (this.excludedPackageNames.contains(AbiCompoundName.box-impl(packageName2))) {
                    bl = true;
                } else {
                    Iterable $this$any$iv = this.excludedPackageNames;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String excludedPackageName = ((AbiCompoundName)element$iv).unbox-impl();
                            boolean bl2 = false;
                            if (!AbiCompoundName.isContainerOf-6OaPNJE(excludedPackageName, packageName2)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$NonPublicMarkerAnnotations;", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "nonPublicMarkerNames", "", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "(Ljava/util/Collection;)V", "", "[Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "isDeclarationExcluded", "", "declaration", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "kotlin-util-klib-abi"})
    @SourceDebugExtension(value={"SMAP\nLibraryAbiReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReader.kt\norg/jetbrains/kotlin/library/abi/AbiReadingFilter$NonPublicMarkerAnnotations\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n37#2,2:98\n*S KotlinDebug\n*F\n+ 1 LibraryAbiReader.kt\norg/jetbrains/kotlin/library/abi/AbiReadingFilter$NonPublicMarkerAnnotations\n*L\n64#1:98,2\n*E\n"})
    public static final class NonPublicMarkerAnnotations
    implements AbiReadingFilter {
        @NotNull
        private final AbiQualifiedName[] nonPublicMarkerNames;

        public NonPublicMarkerAnnotations(@NotNull Collection<AbiQualifiedName> nonPublicMarkerNames) {
            Intrinsics.checkNotNullParameter(nonPublicMarkerNames, (String)"nonPublicMarkerNames");
            Collection $this$toTypedArray$iv = CollectionsKt.toSet((Iterable)nonPublicMarkerNames);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            this.nonPublicMarkerNames = thisCollection$iv.toArray(new AbiQualifiedName[0]);
        }

        @Override
        public boolean isDeclarationExcluded(@NotNull AbiDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            for (AbiQualifiedName nonPublicMarkerName : this.nonPublicMarkerNames) {
                if (!declaration.hasAnnotation(nonPublicMarkerName)) {
                    AbiAnnotatedEntity abiAnnotatedEntity = declaration instanceof AbiProperty ? (AbiProperty)declaration : null;
                    boolean bl = abiAnnotatedEntity != null && (abiAnnotatedEntity = abiAnnotatedEntity.getBackingField()) != null ? abiAnnotatedEntity.hasAnnotation(nonPublicMarkerName) : false;
                    if (!bl) continue;
                }
                return true;
            }
            return false;
        }
    }
}

