/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinIrSignatureVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.abi.AbiReadingFilter;
import org.jetbrains.kotlin.library.abi.AbiSignatureVersion;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.LibraryAbi;
import org.jetbrains.kotlin.library.abi.LibraryManifest;
import org.jetbrains.kotlin.library.abi.impl.AbiSignatureVersions;
import org.jetbrains.kotlin.library.abi.impl.LibraryDeserializer;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.util.DummyLogger;

@ExperimentalLibraryAbiReader
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl;", "", "libraryFile", "Ljava/io/File;", "filters", "", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "(Ljava/io/File;Ljava/util/List;)V", "compositeFilter", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter$Composite;", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "malformedLibrary", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "readAbi", "Lorg/jetbrains/kotlin/library/abi/LibraryAbi;", "readManifest", "Lorg/jetbrains/kotlin/library/abi/LibraryManifest;", "readSupportedSignatureVersions", "", "Lorg/jetbrains/kotlin/library/abi/AbiSignatureVersion;", "kotlin-util-klib-abi"})
@SourceDebugExtension(value={"SMAP\nLibraryAbiReaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,807:1\n1#2:808\n1618#3,3:809\n*S KotlinDebug\n*F\n+ 1 LibraryAbiReaderImpl.kt\norg/jetbrains/kotlin/library/abi/impl/LibraryAbiReaderImpl\n*L\n92#1:809,3\n*E\n"})
public final class LibraryAbiReaderImpl {
    @NotNull
    private final KotlinLibrary library;
    @Nullable
    private final AbiReadingFilter.Composite compositeFilter;

    /*
     * WARNING - void declaration
     */
    public LibraryAbiReaderImpl(@NotNull File libraryFile, @NotNull List<? extends AbiReadingFilter> filters) {
        KotlinLibrary kotlinLibrary;
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        LibraryAbiReaderImpl libraryAbiReaderImpl = this;
        try {
            KotlinLibrary kotlinLibrary2;
            LibraryAbiReaderImpl libraryAbiReaderImpl2 = libraryAbiReaderImpl;
            String string2 = libraryFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            KotlinLibrary kotlinLibrary3 = ToolingSingleFileKlibResolveStrategy.INSTANCE.tryResolve(new org.jetbrains.kotlin.konan.file.File(string2), DummyLogger.INSTANCE);
            if (kotlinLibrary3 != null) {
                void $this$library_u24lambda_u242;
                KotlinLibrary kotlinLibrary4;
                KotlinLibrary kotlinLibrary5 = kotlinLibrary4 = kotlinLibrary3;
                LibraryAbiReaderImpl libraryAbiReaderImpl3 = libraryAbiReaderImpl2;
                boolean bl = false;
                if (!(((CharSequence)KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)$this$library_u24lambda_u242)).length() > 0)) {
                    boolean $i$a$-check-LibraryAbiReaderImpl$library$1$32 = false;
                    String $i$a$-check-LibraryAbiReaderImpl$library$1$32 = "Can't read unique name from manifest";
                    throw new IllegalStateException($i$a$-check-LibraryAbiReaderImpl$library$1$32.toString());
                }
                if (!$this$library_u24lambda_u242.getHasIr()) {
                    boolean bl2 = false;
                    String string3 = "Library does not have IR";
                    throw new IllegalStateException(string3.toString());
                }
                libraryAbiReaderImpl2 = libraryAbiReaderImpl3;
                kotlinLibrary2 = kotlinLibrary4;
            } else {
                kotlinLibrary2 = null;
            }
            kotlinLibrary = kotlinLibrary2;
        }
        catch (Exception exception) {
            void e;
            LibraryAbiReaderImpl libraryAbiReaderImpl4 = libraryAbiReaderImpl;
            this.malformedLibrary(libraryFile, (Exception)e);
            throw null;
        }
        KotlinLibrary kotlinLibrary6 = kotlinLibrary;
        if (kotlinLibrary6 == null) {
            throw new IllegalStateException(("Library not found: " + libraryFile).toString());
        }
        libraryAbiReaderImpl2.library = kotlinLibrary6;
        this.compositeFilter = !((Collection)filters).isEmpty() ? new AbiReadingFilter.Composite(filters) : null;
    }

    @NotNull
    public final LibraryAbi readAbi() {
        Set<AbiSignatureVersion> supportedSignatureVersions = this.readSupportedSignatureVersions();
        return new LibraryAbi(this.readManifest(), KotlinLibraryKt.getUniqueName(this.library), supportedSignatureVersions, new LibraryDeserializer(this.library, supportedSignatureVersions, this.compositeFilter).deserialize());
    }

    private final LibraryManifest readManifest() {
        KotlinLibraryVersioning versions2 = this.library.getVersions();
        BuiltInsPlatform builtInsPlatform = KotlinLibraryKt.getBuiltInsPlatform((BaseKotlinLibrary)this.library);
        KotlinAbiVersion kotlinAbiVersion = versions2.getAbiVersion();
        return new LibraryManifest(builtInsPlatform != null ? builtInsPlatform.name() : null, CollectionsKt.sorted((Iterable)KotlinLibraryKt.getNativeTargets(this.library)), versions2.getCompilerVersion(), kotlinAbiVersion != null ? kotlinAbiVersion.toString() : null, versions2.getLibraryVersion(), KotlinLibraryKt.getIrProviderName(this.library));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AbiSignatureVersion> readSupportedSignatureVersions() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.library.getVersions().getIrSignatureVersions();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KotlinIrSignatureVersion kotlinIrSignatureVersion = (KotlinIrSignatureVersion)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(AbiSignatureVersions.INSTANCE.resolveByVersionNumber(it.getNumber()));
        }
        return (Set)var2_2;
    }

    private final Void malformedLibrary(File libraryFile, Exception cause) {
        throw new IllegalArgumentException("Malformed library: " + libraryFile, cause);
    }
}

