/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.RecursiveContractHelperKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.MissingDependencySupertypeChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u001c\u001a\u00020\u0019\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 H\u0002J(\u0010!\u001a\u00020\u0019\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 H\u0002J4\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001d0 \"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u0006\u0010#\u001a\u00020$J\u001e\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010 2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J@\u0010-\u001a\u00020\u0019\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010/2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u00100\u001a\u0004\u0018\u0001012\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0002J\u0018\u00104\u001a\u0002052\u0006\u0010&\u001a\u00020'2\u0006\u00106\u001a\u000207H\u0002J6\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u0001092\b\u0010;\u001a\u0004\u0018\u0001092\u0006\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020>2\u0006\u00106\u001a\u000207H\u0002J,\u0010?\u001a\u00020\u0019\"\b\b\u0000\u0010\u001d*\u00020\u001e*\b\u0012\u0004\u0012\u0002H\u001d0/2\u0006\u0010@\u001a\u0002092\u0006\u00106\u001a\u000207H\u0002J,\u0010A\u001a\u00020\u0019\"\b\b\u0000\u0010\u001d*\u00020\u001e*\b\u0012\u0004\u0012\u0002H\u001d0/2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010B\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030/2\u0006\u0010C\u001a\u000207H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "candidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "callCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "effectSystem", "Lorg/jetbrains/kotlin/contracts/EffectSystem;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "missingSupertypesResolver", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Lorg/jetbrains/kotlin/contracts/EffectSystem;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "checkMissingSupertypes", "", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "completeAllCandidates", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "completeArguments", "completeCall", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "completeCallForArgument", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "completeOneArgument", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "completeResolvedCallAndArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "createTypeForConvertableConstant", "Lorg/jetbrains/kotlin/types/SimpleType;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "hasNecessarySafeCall", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "updateRecordedTypeForArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "updatedType", "recordedType", "argumentExpression", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "completeConstraintSystem", "expectedType", "updateResolutionStatusFromConstraintSystem", "updateResultDataFlowInfoUsingEffects", "bindingTrace", "frontend"})
@SourceDebugExtension(value={"SMAP\nCallCompleter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallCompleter.kt\norg/jetbrains/kotlin/resolve/calls/CallCompleter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,478:1\n817#2:479\n845#2,2:480\n1853#2,2:482\n1853#2,2:484\n*S KotlinDebug\n*F\n+ 1 CallCompleter.kt\norg/jetbrains/kotlin/resolve/calls/CallCompleter\n*L\n133#1:479\n133#1:480,2\n133#1:482,2\n447#1:484,2\n*E\n"})
public final class CallCompleter {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final CandidateResolver candidateResolver;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final Iterable<CallChecker> callCheckers;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final DeprecationResolver deprecationResolver;
    @NotNull
    private final EffectSystem effectSystem;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final MissingSupertypesResolver missingSupertypesResolver;
    @NotNull
    private final KotlinCallComponents callComponents;

    public CallCompleter(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CandidateResolver candidateResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer2, @NotNull Iterable<? extends CallChecker> callCheckers, @NotNull ModuleDescriptor moduleDescriptor, @NotNull DeprecationResolver deprecationResolver, @NotNull EffectSystem effectSystem, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull MissingSupertypesResolver missingSupertypesResolver, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)candidateResolver, (String)"candidateResolver");
        Intrinsics.checkNotNullParameter((Object)dataFlowAnalyzer2, (String)"dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter(callCheckers, (String)"callCheckers");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)deprecationResolver, (String)"deprecationResolver");
        Intrinsics.checkNotNullParameter((Object)effectSystem, (String)"effectSystem");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        Intrinsics.checkNotNullParameter((Object)missingSupertypesResolver, (String)"missingSupertypesResolver");
        Intrinsics.checkNotNullParameter((Object)callComponents, (String)"callComponents");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer2;
        this.callCheckers = callCheckers;
        this.moduleDescriptor = moduleDescriptor;
        this.deprecationResolver = deprecationResolver;
        this.effectSystem = effectSystem;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.missingSupertypesResolver = missingSupertypesResolver;
        this.callComponents = callComponents;
    }

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@NotNull BasicCallResolutionContext context2, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)tracing, (String)"tracing");
        ResolvedCall resolvedCall2 = results.isSingleResult() ? results.getResultingCall() : null;
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
        if (!CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall2, results, context2, tracing);
            this.completeAllCandidates(context2, results);
        }
        if (context2.trace.wantsDiagnostics()) {
            if (resolvedCall2 == null) {
                this.checkMissingSupertypes(context2, this.missingSupertypesResolver);
            } else {
                KtExpression calleeExpression = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCall().getCalleeExpression() : resolvedCall2.getCall().getCalleeExpression();
                KtElement ktElement = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : resolvedCall2.getCall().getCallElement();
                Intrinsics.checkNotNull((Object)ktElement);
                KtElement reportOn = ktElement;
                CallCheckerContext callCheckerContext = new CallCheckerContext(context2, this.deprecationResolver, this.moduleDescriptor, this.missingSupertypesResolver, this.callComponents, null, 32, null);
                for (CallChecker callChecker : this.callCheckers) {
                    callChecker.check(resolvedCall2, (PsiElement)reportOn, callCheckerContext);
                    if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall)) continue;
                    callChecker.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), (PsiElement)reportOn, callCheckerContext);
                }
            }
        }
        if (results.isSingleResult() && results.getResultingCall().getStatus().isSuccess()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
            Intrinsics.checkNotNullExpressionValue(overloadResolutionResultsImpl, (String)"changeStatusToSuccess(...)");
            return overloadResolutionResultsImpl;
        }
        return results;
    }

    private final void checkMissingSupertypes(BasicCallResolutionContext context2, MissingSupertypesResolver missingSupertypesResolver) {
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
        Call call3 = call2;
        Receiver receiver = call3.getExplicitReceiver();
        ReceiverValue receiverValue = receiver instanceof ReceiverValue ? (ReceiverValue)receiver : null;
        if (receiverValue == null) {
            return;
        }
        ReceiverValue explicitReceiver = receiverValue;
        KotlinType kotlinType = explicitReceiver.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KtElement ktElement = call3.getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        PsiElement psiElement = (PsiElement)ktElement;
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        MissingDependencySupertypeChecker.INSTANCE.checkSupertypes(kotlinType, psiElement, bindingTrace, missingSupertypesResolver);
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeAllCandidates(BasicCallResolutionContext context2, OverloadResolutionResultsImpl<D> results) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Collection<ResolvedCall<D>> collection;
        Collection<ResolvedCall<D>> collection2;
        if (context2.collectAllCandidates) {
            Collection<ResolvedCall<D>> collection3 = results.getAllCandidates();
            Intrinsics.checkNotNull(collection3);
            collection2 = collection3;
            Intrinsics.checkNotNull(collection2);
            collection = collection2;
        } else {
            collection2 = results.getResultingCalls();
            Intrinsics.checkNotNull(collection2);
            collection = collection2;
        }
        Collection<ResolvedCall<D>> candidates2 = collection;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context2.trace, "Trace to complete a candidate that is not a resulting call");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"create(...)");
        TemporaryBindingTrace temporaryBindingTrace2 = temporaryBindingTrace;
        Iterable $this$filterNot$iv = candidates2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MutableResolvedCall resolvedCall2 = (MutableResolvedCall)element$iv$iv;
            boolean bl = false;
            if (resolvedCall2.isCompleted()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableResolvedCall resolvedCall3 = (MutableResolvedCall)element$iv;
            boolean bl = false;
            Object Context2 = context2.replaceBindingTrace(temporaryBindingTrace2);
            Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceBindingTrace(...)");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)Context2;
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)tracingStrategy, (String)"EMPTY");
            this.completeResolvedCallAndArguments(resolvedCall3, results, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(MutableResolvedCall<D> resolvedCall2, OverloadResolutionResultsImpl<D> results, BasicCallResolutionContext context2, TracingStrategy tracing) {
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
        MutableResolvedCall<D> mutableResolvedCall = resolvedCall2;
        Object object = mutableResolvedCall != null ? mutableResolvedCall.getResultingDescriptor() : null;
        LexicalScope lexicalScope = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        RecursiveContractHelperKt.disableContractsInsideContractsBlock(call2, object, lexicalScope, bindingTrace);
        if (resolvedCall2 == null || resolvedCall2.isCompleted() || resolvedCall2.getConstraintSystem() == null) {
            this.completeArguments(context2, results);
            MutableResolvedCall<D> mutableResolvedCall2 = resolvedCall2;
            if (mutableResolvedCall2 != null) {
                BindingTrace bindingTrace2 = context2.trace;
                Intrinsics.checkNotNullExpressionValue((Object)bindingTrace2, (String)"trace");
                this.updateResultDataFlowInfoUsingEffects(mutableResolvedCall2, bindingTrace2);
            }
            MutableResolvedCall<D> mutableResolvedCall3 = resolvedCall2;
            if (mutableResolvedCall3 != null) {
                mutableResolvedCall3.markCallAsCompleted();
            }
            return;
        }
        KotlinType kotlinType = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        BindingTrace bindingTrace3 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace3, (String)"trace");
        this.completeConstraintSystem(resolvedCall2, kotlinType, bindingTrace3);
        this.completeArguments(context2, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall2, context2, tracing);
        BindingTrace bindingTrace4 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace4, (String)"trace");
        this.updateResultDataFlowInfoUsingEffects(resolvedCall2, bindingTrace4);
        resolvedCall2.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(MutableResolvedCall<D> $this$completeConstraintSystem, KotlinType expectedType, BindingTrace trace) {
        ConstraintSystemCompleter constraintSystemCompleter;
        KotlinType expectedReturnType;
        KotlinType kotlinType;
        KotlinType returnType2 = $this$completeConstraintSystem.getCandidateDescriptor().getReturnType();
        Call call2 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        if (CallUtilKt.isCallableReference(call2)) {
            if (!TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) {
                kotlinType = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType);
            } else {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
                kotlinType = simpleType2;
            }
        } else {
            kotlinType = expectedReturnType = expectedType;
        }
        if (returnType2 != null && !TypeUtils.noExpectedType(expectedReturnType)) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>(returnType2, expectedReturnType, $this$completeConstraintSystem){
                final /* synthetic */ KotlinType $returnType;
                final /* synthetic */ KotlinType $expectedReturnType;
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                {
                    this.$returnType = $returnType;
                    this.$expectedReturnType = $expectedReturnType;
                    this.$this_completeConstraintSystem = $receiver;
                    super(1);
                }

                public final ConstraintSystem invoke(ConstraintSystem.Builder builder2) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    KotlinType returnTypeInSystem = CallCompleter.access$completeConstraintSystem$typeInSystem(builder2, this.$this_completeConstraintSystem, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder2.addSubtypeConstraint(returnTypeInSystem, this.$expectedReturnType, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        constraintSystem = builder2.build();
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
            }));
        }
        if ((constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, $this$completeConstraintSystem.getCall().getCalleeExpression())) != null) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>(constraintSystemCompleter, $this$completeConstraintSystem){
                final /* synthetic */ ConstraintSystemCompleter $constraintSystemCompleter;
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                {
                    this.$constraintSystemCompleter = $constraintSystemCompleter;
                    this.$this_completeConstraintSystem = $receiver;
                    super(1);
                }

                public final ConstraintSystem invoke(ConstraintSystem.Builder builder2) {
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    this.$constraintSystemCompleter.completeConstraintSystem(builder2, (ResolvedCall)this.$this_completeConstraintSystem);
                    ConstraintSystem system2 = builder2.build();
                    ConstraintSystemStatus status2 = ConstraintSystemUtilsKt.filterConstraintsOut(system2, ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus();
                    return status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.FROM_COMPLETER) ? null : system2;
                }
            }));
        }
        if (returnType2 != null && expectedReturnType == TypeUtils.UNIT_EXPECTED_TYPE) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>(returnType2, this, $this$completeConstraintSystem){
                final /* synthetic */ KotlinType $returnType;
                final /* synthetic */ CallCompleter this$0;
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                {
                    this.$returnType = $returnType;
                    this.this$0 = $receiver;
                    this.$this_completeConstraintSystem = $receiver2;
                    super(1);
                }

                public final ConstraintSystem invoke(ConstraintSystem.Builder builder2) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    KotlinType returnTypeInSystem = CallCompleter.access$completeConstraintSystem$typeInSystem(builder2, this.$this_completeConstraintSystem, this.$returnType);
                    if (returnTypeInSystem != null) {
                        builder2.addSubtypeConstraint(returnTypeInSystem, CallCompleter.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType(), ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        ConstraintSystem system2 = builder2.build();
                        constraintSystem = system2.getStatus().isSuccessful() ? system2 : null;
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
            }));
        }
        Call call3 = $this$completeConstraintSystem.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call3, (String)"getCall(...)");
        if (CallUtilKt.isCallableReference(call3) && !TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType)) {
            CallCompleter.completeConstraintSystem$updateSystemIfNeeded($this$completeConstraintSystem, (Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)((Function1)new Function1<ConstraintSystem.Builder, ConstraintSystem>($this$completeConstraintSystem, expectedType){
                final /* synthetic */ MutableResolvedCall<D> $this_completeConstraintSystem;
                final /* synthetic */ KotlinType $expectedType;
                {
                    this.$this_completeConstraintSystem = $receiver;
                    this.$expectedType = $expectedType;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final ConstraintSystem invoke(ConstraintSystem.Builder builder2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                    List<ValueParameterDescriptor> list2 = this.$this_completeConstraintSystem.getCandidateDescriptor().getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueParameters(...)");
                    Iterable iterable = CollectionsKt.zip((Iterable)list2, (Iterable)FunctionTypesKt.getValueParameterTypesFromFunctionType(this.$expectedType));
                    MutableResolvedCall<D> mutableResolvedCall = this.$this_completeConstraintSystem;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl = false;
                        ValueParameterDescriptor parameter2 = (ValueParameterDescriptor)pair.component1();
                        TypeProjection argument2 = (TypeProjection)pair.component2();
                        KotlinType valueParameterInSystem = CallCompleter.access$completeConstraintSystem$typeInSystem(builder2, mutableResolvedCall, parameter2.getType());
                        builder2.addSubtypeConstraint(valueParameterInSystem, argument2.getType(), ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(parameter2.getIndex()));
                    }
                    return builder2.build();
                }
            }));
        }
        ConstraintSystem constraintSystem = $this$completeConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull((Object)constraintSystem);
        ConstraintSystem.Builder builder2 = ConstraintSystem.toBuilder$default(constraintSystem, null, 1, null);
        builder2.fixVariables();
        ConstraintSystem system2 = builder2.build();
        $this$completeConstraintSystem.setConstraintSystem(system2);
        boolean isNewInferenceEnabled = this.effectSystem.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference);
        TypeSubstitutor typeSubstitutor2 = isNewInferenceEnabled ? system2.getResultingSubstitutor().replaceWithContravariantApproximatingSubstitution() : system2.getResultingSubstitutor();
        Intrinsics.checkNotNull((Object)typeSubstitutor2);
        TypeSubstitutor resultingSubstitutor2 = typeSubstitutor2;
        $this$completeConstraintSystem.setSubstitutor(resultingSubstitutor2);
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(MutableResolvedCall<D> $this$updateResolutionStatusFromConstraintSystem, BasicCallResolutionContext context2, TracingStrategy tracing) {
        CallCandidateResolutionContext<D> callCandidateResolutionContext = CallCandidateResolutionContext.createForCallBeingAnalyzed($this$updateResolutionStatusFromConstraintSystem, context2, tracing);
        Intrinsics.checkNotNullExpressionValue(callCandidateResolutionContext, (String)"createForCallBeingAnalyzed(...)");
        CallCandidateResolutionContext<D> contextWithResolvedCall = callCandidateResolutionContext;
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(contextWithResolvedCall, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus resolutionStatus = $this$updateResolutionStatusFromConstraintSystem.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)resolutionStatus), (String)"getStatus(...)");
        ResolutionStatus status2 = resolutionStatus;
        ConstraintSystem constraintSystem = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull((Object)constraintSystem);
        if (constraintSystem.getStatus().isSuccessful()) {
            if (status2 == ResolutionStatus.UNKNOWN_STATUS || status2 == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                $this$updateResolutionStatusFromConstraintSystem.setStatusToSuccess();
            }
            return;
        }
        ReceiverValue receiverValue = $this$updateResolutionStatusFromConstraintSystem.getExtensionReceiver();
        KotlinType receiverType2 = receiverValue != null ? receiverValue.getType() : null;
        Object d = $this$updateResolutionStatusFromConstraintSystem.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $this$updateResolutionStatusFromConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull((Object)constraintSystem2);
        InferenceErrorData inferenceErrorData = InferenceErrorData.create(d, constraintSystem2, valueArgumentsCheckingResult.getArgumentTypes(), receiverType2, context2.expectedType, context2.call);
        Intrinsics.checkNotNullExpressionValue((Object)inferenceErrorData, (String)"create(...)");
        InferenceErrorData errorData = inferenceErrorData;
        tracing.typeInferenceFailed(context2, errorData);
        $this$updateResolutionStatusFromConstraintSystem.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(BasicCallResolutionContext context2, OverloadResolutionResultsImpl<D> results) {
        if (context2.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        Function1 getArgumentMapping = null;
        Function1 getDataFlowInfoForArgument = null;
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"getResultingCall(...)");
            ResolvedCall resolvedCall3 = resolvedCall2;
            getArgumentMapping = (Function1)new Function1<ValueArgument, ArgumentMapping>(resolvedCall3){
                final /* synthetic */ MutableResolvedCall<D> $resolvedCall;
                {
                    this.$resolvedCall = $resolvedCall;
                    super(1);
                }

                public final ArgumentMapping invoke(ValueArgument argument2) {
                    Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
                    ArgumentMapping argumentMapping2 = this.$resolvedCall.getArgumentMapping(argument2);
                    Intrinsics.checkNotNullExpressionValue((Object)argumentMapping2, (String)"getArgumentMapping(...)");
                    return argumentMapping2;
                }
            };
            getDataFlowInfoForArgument = (Function1)new Function1<ValueArgument, DataFlowInfo>(resolvedCall3){
                final /* synthetic */ MutableResolvedCall<D> $resolvedCall;
                {
                    this.$resolvedCall = $resolvedCall;
                    super(1);
                }

                public final DataFlowInfo invoke(ValueArgument argument2) {
                    Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
                    DataFlowInfo dataFlowInfo = this.$resolvedCall.getDataFlowInfoForArguments().getInfo(argument2);
                    Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"getInfo(...)");
                    return dataFlowInfo;
                }
            };
        } else {
            getArgumentMapping = completeArguments.3.INSTANCE;
            getDataFlowInfoForArgument = (Function1)new Function1<ValueArgument, DataFlowInfo>(context2){
                final /* synthetic */ BasicCallResolutionContext $context;
                {
                    this.$context = $context;
                    super(1);
                }

                public final DataFlowInfo invoke(ValueArgument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    DataFlowInfo dataFlowInfo = this.$context.dataFlowInfo;
                    Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
                    return dataFlowInfo;
                }
            };
        }
        Iterator<? extends ValueArgument> iterator2 = context2.call.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            Intrinsics.checkNotNull((Object)valueArgument2);
            ArgumentMapping argumentMapping2 = (ArgumentMapping)getArgumentMapping.invoke((Object)valueArgument2);
            KotlinType expectedType = null;
            CallPosition callPosition = null;
            ValueParameterDescriptor parameter2 = null;
            if (argumentMapping2 instanceof ArgumentMatch) {
                expectedType = CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping2).getValueParameter(), valueArgument, context2);
                ResolvedCall resolvedCall4 = results.getResultingCall();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedCall4, (String)"getResultingCall(...)");
                callPosition = new CallPosition.ValueArgumentPosition(resolvedCall4, ((ArgumentMatch)argumentMapping2).getValueParameter(), valueArgument);
                parameter2 = ((ArgumentMatch)argumentMapping2).getValueParameter();
            } else {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
                expectedType = simpleType2;
                callPosition = CallPosition.Unknown.INSTANCE;
                parameter2 = null;
            }
            Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)context2.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke((Object)valueArgument))).replaceExpectedType(expectedType)).replaceCallPosition(callPosition);
            Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceCallPosition(...)");
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)Context2;
            this.completeOneArgument(valueArgument, parameter2, newContext);
        }
    }

    private final SimpleType createTypeForConvertableConstant(CompileTimeConstant<?> constant) {
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
        Object object = constant.getValue(simpleType2);
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        if (number == null) {
            return null;
        }
        long value2 = number.longValue();
        IntegerValueTypeConstructor typeConstructor2 = new IntegerValueTypeConstructor(value2, this.moduleDescriptor, constant.getParameters());
        object = new String[]{typeConstructor2.toString()};
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), typeConstructor2, CollectionsKt.emptyList(), false, ErrorUtils.createErrorScope(ErrorScopeKind.INTEGER_LITERAL_TYPE_SCOPE, true, object));
    }

    /*
     * Unable to fully structure code
     */
    private final void completeOneArgument(ValueArgument argument, ValueParameterDescriptor parameter, BasicCallResolutionContext context) {
        if (argument.isExternal()) {
            return;
        }
        v0 = argument.getArgumentExpression();
        if (v0 == null) {
            return;
        }
        expression = v0;
        v1 = KtPsiUtil.getLastElementDeparenthesized(expression, context.statementFilter);
        if (v1 == null) {
            return;
        }
        deparenthesized = v1;
        updatedType = recordedType = context.trace.getType(expression);
        results = this.completeCallForArgument(deparenthesized, context);
        constant = (CompileTimeConstant)context.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
        v2 = convertedConst = constant instanceof IntegerValueTypeConstant != false && ((IntegerValueTypeConstant)constant).getConvertedFromSigned() != false;
        if (results != null && results.isSingleResult()) {
            v3 = results.getResultingCall();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getResultingCall(...)");
            resolvedCall = v3;
            if (!convertedConst) {
                if (resolvedCall.hasInferredReturnType()) {
                    v4 = resolvedCall.getResultingDescriptor();
                    v5 = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver(resolvedCall, v4 != null ? v4.getReturnType() : null, context);
                } else {
                    v5 = updatedType = null;
                }
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable() && (v6 = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, expression)) == null) {
            v6 = updatedType = updatedType;
        }
        if (parameter == null) ** GOTO lbl-1000
        v7 = parameter;
        v8 = context.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"languageVersionSettings");
        if (ImplicitIntegerCoercion.INSTANCE.isEnabledFor(v7, v8)) {
            argumentCompileTimeValue = (CompileTimeConstant)context.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
            if (argumentCompileTimeValue != null && argumentCompileTimeValue.getParameters().isConvertableConstVal() && (generalNumberType = this.createTypeForConvertableConstant(argumentCompileTimeValue)) != null) {
                updatedType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context.trace, context.statementFilter, context.expectedType, generalNumberType, expression);
            }
        } else if (convertedConst) {
            context.trace.report(Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED.on((KtExpression)((PsiElement)deparenthesized)));
        }
        v9 = context.statementFilter;
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"statementFilter");
        v10 = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"trace");
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, expression, v9, v10);
        v11 = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context);
        if (v11 != null) {
            functionLiteralArgument = v11;
            $i$a$-let-CallCompleter$completeOneArgument$1 = false;
            this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression, functionLiteralArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
        }
        v12 = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression, context);
        if (v12 != null) {
            callableReferenceArgument = v12;
            $i$a$-let-CallCompleter$completeOneArgument$2 = false;
            this.argumentTypeResolver.getCallableReferenceTypeInfo(expression, callableReferenceArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        this.dataFlowAnalyzer.checkType(updatedType, deparenthesized, (ResolutionContext)context);
    }

    private final OverloadResolutionResultsImpl<?> completeCallForArgument(KtExpression expression2, BasicCallResolutionContext context2) {
        ResolutionResultsCache.CachedData cachedData = GenericCandidateResolverKt.getResolutionResultsCachedData(expression2, context2);
        if (cachedData == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData2 = cachedData;
        OverloadResolutionResultsImpl<?> cachedResolutionResults = cachedData2.component1();
        BasicCallResolutionContext cachedContext = cachedData2.component2();
        TracingStrategy tracing = cachedData2.component3();
        Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(context2.trace)).replaceExpectedType(context2.expectedType)).replaceCollectAllCandidates(false)).replaceCallPosition(context2.callPosition);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceCallPosition(...)");
        BasicCallResolutionContext contextForArgument = (BasicCallResolutionContext)Context2;
        return this.completeCall(contextForArgument, cachedResolutionResults, tracing);
    }

    private final KotlinType updateRecordedTypeForArgument(KotlinType updatedType, KotlinType recordedType, KtExpression argumentExpression, StatementFilter statementFilter, BindingTrace trace) {
        if (!ErrorUtils.INSTANCE.containsErrorType(recordedType) && Intrinsics.areEqual((Object)recordedType, (Object)updatedType) || updatedType == null) {
            return updatedType;
        }
        ArrayList<KtExpression> expressions = new ArrayList<KtExpression>();
        KtExpression expression2 = argumentExpression;
        while (expression2 != null) {
            expressions.add(expression2);
            expression2 = CallCompleter.updateRecordedTypeForArgument$deparenthesizeOrGetSelector(statementFilter, expression2);
        }
        boolean shouldBeMadeNullable = false;
        Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)expressions);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression ktExpression = (KtExpression)element$iv;
            boolean bl = false;
            if (!(ktExpression instanceof KtParenthesizedExpression || ktExpression instanceof KtLabeledExpression || ktExpression instanceof KtAnnotatedExpression)) {
                shouldBeMadeNullable = this.hasNecessarySafeCall(ktExpression, trace);
            }
            BindingContextUtils.updateRecordedType(updatedType, ktExpression, trace, shouldBeMadeNullable);
        }
        return trace.getType(argumentExpression);
    }

    private final boolean hasNecessarySafeCall(KtExpression expression2, BindingTrace trace) {
        if (!(expression2 instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        KotlinType expressionType2 = trace.getType(((KtSafeQualifiedExpression)expression2).getReceiverExpression());
        return expressionType2 != null && TypeUtils.isNullableType(expressionType2);
    }

    private final void updateResultDataFlowInfoUsingEffects(MutableResolvedCall<?> $this$updateResultDataFlowInfoUsingEffects, BindingTrace bindingTrace) {
        if ($this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments() instanceof MutableDataFlowInfoForArguments.WithoutArgumentsCheck) {
            return;
        }
        Object d = $this$updateResultDataFlowInfoUsingEffects.getResultingDescriptor();
        if (d == null || (d = d.getContainingDeclaration()) == null) {
            return;
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(d);
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"getContainingModule(...)");
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        DataFlowInfo resultDFIfromES = this.effectSystem.getDataFlowInfoForFinishedCall((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
        $this$updateResultDataFlowInfoUsingEffects.getDataFlowInfoForArguments().updateResultInfo(resultDFIfromES);
        this.effectSystem.recordDefiniteInvocations((ResolvedCall)$this$updateResultDataFlowInfoUsingEffects, bindingTrace, moduleDescriptor2);
    }

    private static final <D extends CallableDescriptor> KotlinType completeConstraintSystem$typeInSystem(ConstraintSystem.Builder $this$completeConstraintSystem_u24typeInSystem, MutableResolvedCall<D> $this_completeConstraintSystem, KotlinType type2) {
        KotlinType kotlinType;
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType it = kotlinType2;
            boolean bl = false;
            Map<CallHandle, TypeSubstitutor> map = $this$completeConstraintSystem_u24typeInSystem.getTypeVariableSubstitutors();
            Call call2 = $this_completeConstraintSystem.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
            TypeSubstitutor typeSubstitutor2 = map.get(TypeVariableKt.toHandle(call2));
            if (typeSubstitutor2 == null) {
                throw new IllegalStateException(("No substitutor for call: " + $this_completeConstraintSystem.getCall()).toString());
            }
            TypeSubstitutor substitutor2 = typeSubstitutor2;
            kotlinType = substitutor2.substitute(it, Variance.INVARIANT);
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    private static final <D extends CallableDescriptor> void completeConstraintSystem$updateSystemIfNeeded(MutableResolvedCall<D> $this_completeConstraintSystem, Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem> buildSystemWithAdditionalConstraints) {
        ConstraintSystem constraintSystem = $this_completeConstraintSystem.getConstraintSystem();
        Intrinsics.checkNotNull((Object)constraintSystem);
        ConstraintSystem system2 = (ConstraintSystem)buildSystemWithAdditionalConstraints.invoke((Object)ConstraintSystem.toBuilder$default(constraintSystem, null, 1, null));
        if (system2 != null) {
            $this_completeConstraintSystem.setConstraintSystem(system2);
        }
    }

    private static final KtExpression updateRecordedTypeForArgument$deparenthesizeOrGetSelector(StatementFilter $statementFilter, KtExpression expression2) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesizeOnce(expression2);
        if (!Intrinsics.areEqual((Object)deparenthesized, (Object)expression2)) {
            return deparenthesized;
        }
        if (expression2 instanceof KtBlockExpression) {
            return StatementFilterKt.getLastStatementInABlock($statementFilter, (KtBlockExpression)expression2);
        }
        KtQualifiedExpression ktQualifiedExpression = expression2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)expression2 : null;
        return ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
    }

    public static final /* synthetic */ KotlinType access$completeConstraintSystem$typeInSystem(ConstraintSystem.Builder $receiver, MutableResolvedCall $this_completeConstraintSystem, KotlinType type2) {
        return CallCompleter.completeConstraintSystem$typeInSystem($receiver, $this_completeConstraintSystem, type2);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(CallCompleter $this) {
        return $this.moduleDescriptor;
    }
}

