/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "frontend"})
public final class OperatorCallChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        boolean isConventionOperator;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = object instanceof FunctionDescriptor ? (FunctionDescriptor)object : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!OperatorCallChecker.Companion.checkNotErrorOrDynamic(functionDescriptor2)) {
            return;
        }
        KtExpression ktExpression = resolvedCall2.getCall().getCalleeExpression();
        object = ktExpression != null ? (KtElement)ktExpression : resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNull(object);
        Object element = object;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        Call call3 = call2;
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall && call3 instanceof CallTransformer.CallForImplicitInvoke && ((CallTransformer.CallForImplicitInvoke)call3).itIsVariableAsFunctionCall) {
            Call call4 = ((CallTransformer.CallForImplicitInvoke)call3).getOuterCall();
            Intrinsics.checkNotNullExpressionValue((Object)call4, (String)"getOuterCall(...)");
            Call outerCall = call4;
            if (CallResolverUtilKt.isConventionCall(outerCall)) {
                DeclarationDescriptor declarationDescriptor = functionDescriptor2.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                String string2 = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                String containingDeclarationName = string2;
                context2.getTrace().report(Errors.PROPERTY_AS_OPERATOR.on(reportOn, functionDescriptor2, containingDeclarationName));
            } else if (OperatorCallChecker.Companion.isWrongCallWithExplicitTypeArguments((VariableAsFunctionResolvedCall)((Object)resolvedCall2), outerCall)) {
                context2.getTrace().report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)((KtElement)reportOn)), "on implicit invoke call"));
            }
        }
        if (call3.getCallElement() instanceof KtDestructuringDeclarationEntry || call3 instanceof CallTransformer.CallForImplicitInvoke) {
            if (!functionDescriptor2.isOperator()) {
                Companion.report(reportOn, functionDescriptor2, context2.getTrace());
            }
            return;
        }
        boolean bl = isConventionOperator = element instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element).isConventionOperator();
        if (isConventionOperator) {
            OperatorCallCheckerKt.access$checkModConvention(functionDescriptor2, context2.getLanguageVersionSettings(), context2.getTrace(), reportOn);
        }
        if ((isConventionOperator || element instanceof KtArrayAccessExpression) && !functionDescriptor2.isOperator()) {
            Companion.report(reportOn, functionDescriptor2, context2.getTrace());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/OperatorCallChecker$Companion;", "", "()V", "checkNotErrorOrDynamic", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isWrongCallWithExplicitTypeArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/VariableAsFunctionResolvedCall;", "outerCall", "Lorg/jetbrains/kotlin/psi/Call;", "report", "", "reportOn", "Lcom/intellij/psi/PsiElement;", "descriptor", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final void report(@NotNull PsiElement reportOn, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink sink) {
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!this.checkNotErrorOrDynamic(descriptor2)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor containingDeclaration2 = declarationDescriptor;
            String string2 = DescriptorUtilsKt.getFqNameUnsafe(containingDeclaration2).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String containingDeclarationName = string2;
            sink.report(Errors.OPERATOR_MODIFIER_REQUIRED.on(reportOn, descriptor2, containingDeclarationName));
        }

        private final boolean checkNotErrorOrDynamic(FunctionDescriptor functionDescriptor) {
            return !DynamicCallsKt.isDynamic(functionDescriptor) && !ErrorUtils.isError(functionDescriptor);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isWrongCallWithExplicitTypeArguments(VariableAsFunctionResolvedCall resolvedCall2, Call outerCall) {
            List<KtTypeProjection> list2 = outerCall.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeArguments(...)");
            if (((Collection)list2).isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            List<TypeParameterDescriptor> list3 = resolvedCall2.getFunctionCall().getCandidateDescriptor().getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getTypeParameters(...)");
            if (((Collection)list3).isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            boolean bl3 = true;
            boolean passedTypeArgumentsToInvoke = bl3;
            if (!passedTypeArgumentsToInvoke) return false;
            List<TypeParameterDescriptor> list4 = resolvedCall2.getVariableCall().getCandidateDescriptor().getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getTypeParameters(...)");
            if (((Collection)list4).isEmpty()) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

