/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/EnumDeclaringClassDeprecationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nEnumDeclaringClassDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumDeclaringClassDeprecationChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/EnumDeclaringClassDeprecationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,32:1\n2622#2,3:33\n*S KotlinDebug\n*F\n+ 1 EnumDeclaringClassDeprecationChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/EnumDeclaringClassDeprecationChecker\n*L\n28#1:33,3\n*E\n"})
public final class EnumDeclaringClassDeprecationChecker
implements CallChecker {
    @NotNull
    public static final EnumDeclaringClassDeprecationChecker INSTANCE = new EnumDeclaringClassDeprecationChecker();

    private EnumDeclaringClassDeprecationChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        if (!(resultingDescriptor instanceof PropertyDescriptor) || ((PropertyDescriptor)resultingDescriptor).getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = ((PropertyDescriptor)resultingDescriptor).getExtensionReceiverParameter();
        ReceiverValue receiverValue = receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null;
        ExtensionReceiver extensionReceiver = receiverValue instanceof ExtensionReceiver ? (ExtensionReceiver)receiverValue : null;
        if (extensionReceiver == null) {
            return;
        }
        ExtensionReceiver extensionReceiver2 = extensionReceiver;
        if (!Intrinsics.areEqual((Object)((PropertyDescriptor)resultingDescriptor).getName().asString(), (Object)"declaringClass")) {
            return;
        }
        TypeConstructor extensionReceiverConstructor = extensionReceiver2.getType().getConstructor();
        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getClassId(extensionReceiverConstructor.getDeclarationDescriptor()), (Object)StandardClassIds.INSTANCE.getEnum())) {
            boolean bl;
            block8: {
                Collection<KotlinType> collection = extensionReceiverConstructor.getSupertypes();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
                Iterable $this$none$iv = collection;
                boolean $i$f$none = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getClassId(it.getConstructor().getDeclarationDescriptor()), (Object)StandardClassIds.INSTANCE.getEnum())) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        }
        context2.getTrace().report(ErrorsJvm.ENUM_DECLARING_CLASS_DEPRECATED.on(context2.getLanguageVersionSettings(), reportOn));
    }
}

