/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.annotations.UtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeObjCNameOverridesChecker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0014*\u00020\u000eH\u0002J\u0012\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0017*\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCNameChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "objCNameFqName", "Lorg/jetbrains/kotlin/name/FqName;", "validChars", "", "", "validFirstChars", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "checkObjCName", "objCName", "Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCNameChecker$ObjCName;", "getObjCName", "getObjCNames", "", "ObjCName", "frontend.native"})
@SourceDebugExtension(value={"SMAP\nNativeObjCNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeObjCNameChecker.kt\norg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCNameChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1853#2,2:120\n1853#2,2:122\n1853#2,2:124\n1853#2,2:127\n1#3:126\n*S KotlinDebug\n*F\n+ 1 NativeObjCNameChecker.kt\norg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCNameChecker\n*L\n35#1:120,2\n40#1:122,2\n54#1:124,2\n113#1:127,2\n*E\n"})
public final class NativeObjCNameChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeObjCNameChecker INSTANCE = new NativeObjCNameChecker();
    @NotNull
    private static final FqName objCNameFqName = new FqName("kotlin.native.ObjCName");
    @NotNull
    private static final Set<Character> validFirstChars = SetsKt.plus((Set)SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('a', 'z')))), (Object)Character.valueOf('_'));
    @NotNull
    private static final Set<Character> validChars = SetsKt.plus(validFirstChars, (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('0', '9'))));

    private NativeObjCNameChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.checkDeclaration(declaration, descriptor2, context2);
        if (descriptor2 instanceof CallableMemberDescriptor) {
            NativeObjCNameOverridesChecker.INSTANCE.check(declaration, (CallableMemberDescriptor)descriptor2, context2);
        }
    }

    private final void checkDeclaration(KtDeclaration declaration, DeclarationDescriptor descriptor2, DeclarationCheckerContext context2) {
        ObjCName it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List objCNames = CollectionsKt.filterNotNull((Iterable)this.getObjCNames(descriptor2));
        if (objCNames.isEmpty()) {
            return;
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
            if (!collection.isEmpty()) {
                $this$forEach$iv = objCNames;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (ObjCName)element$iv;
                    boolean bl = false;
                    KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(it.getAnnotation());
                    KtElement reportLocation = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
                    context2.getTrace().report(ErrorsNative.INAPPLICABLE_OBJC_NAME.on((KtElement)((PsiElement)reportLocation)));
                }
            }
        }
        $this$forEach$iv = objCNames;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ObjCName)element$iv;
            boolean bl = false;
            INSTANCE.checkObjCName(it, declaration, descriptor2, context2);
        }
    }

    private final void checkObjCName(ObjCName objCName, KtDeclaration declaration, DeclarationDescriptor descriptor2, DeclarationCheckerContext context2) {
        Object invalidSwiftNameChars;
        Set invalidChars;
        Object object;
        Object invalidNameChars;
        Object object2;
        Object object3;
        Object object4;
        Object invalidNameFirstChar;
        Object object5;
        Object object6;
        KtElement reportLocation;
        Object it;
        Object element$iv2;
        block18: {
            block17: {
                KtAnnotationEntry annotationSource = DescriptorToSourceUtils.getSourceFromAnnotation(objCName.getAnnotation());
                Object object7 = annotationSource;
                if (object7 != null && (object7 = ((KtAnnotationEntry)object7).getValueArguments()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object7;
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        KtExpression expression2;
                        it = (ValueArgument)element$iv2;
                        boolean bl = false;
                        if (it.getArgumentExpression() == null || expression2 instanceof KtConstantExpression || expression2 instanceof KtStringTemplateExpression || it instanceof KtValueArgument && ((KtValueArgument)it).getStringTemplateExpression() != null) continue;
                        context2.getTrace().report(ErrorsNative.NON_LITERAL_OBJC_NAME_ARG.on((KtElement)((PsiElement)expression2)));
                    }
                }
                KtAnnotationEntry ktAnnotationEntry = annotationSource;
                KtElement ktElement = reportLocation = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
                if (objCName.getName() == null && objCName.getSwiftName() == null) {
                    context2.getTrace().report(ErrorsNative.INVALID_OBJC_NAME.on((KtElement)((PsiElement)reportLocation)));
                }
                String string2 = objCName.getName();
                if (string2 != null ? ((CharSequence)string2).length() == 0 : false) break block17;
                String string3 = objCName.getSwiftName();
                boolean bl = string3 != null ? ((CharSequence)string3).length() == 0 : false;
                if (!bl) break block18;
            }
            context2.getTrace().report(ErrorsNative.EMPTY_OBJC_NAME.on((KtElement)((PsiElement)reportLocation)));
        }
        if ((object6 = objCName.getName()) != null && (object6 = StringsKt.firstOrNull((CharSequence)((CharSequence)object6))) != null) {
            element$iv2 = object6;
            it = validFirstChars;
            char p0 = ((Character)element$iv2).charValue();
            boolean bl = false;
            object5 = !it.contains(Character.valueOf(p0)) ? element$iv2 : null;
        } else {
            object5 = invalidNameFirstChar = null;
        }
        if ((object4 = objCName.getSwiftName()) != null && (object4 = StringsKt.firstOrNull((CharSequence)((CharSequence)object4))) != null) {
            it = object4;
            Set<Character> p0 = validFirstChars;
            char p02 = ((Character)it).charValue();
            boolean bl = false;
            object3 = !p0.contains(Character.valueOf(p02)) ? it : null;
        } else {
            object3 = null;
        }
        Object invalidSwiftNameFirstChar = object3;
        element$iv2 = new Character[]{invalidNameFirstChar, invalidSwiftNameFirstChar};
        Set invalidFirstChars = SetsKt.setOfNotNull((Object[])element$iv2);
        if (!((Collection)invalidFirstChars).isEmpty()) {
            context2.getTrace().report(ErrorsNative.INVALID_OBJC_NAME_FIRST_CHAR.on((KtElement)((PsiElement)reportLocation), CollectionsKt.joinToString$default((Iterable)invalidFirstChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)));
        }
        if ((object2 = objCName.getName()) == null || (object2 = StringsKt.toSet((CharSequence)((CharSequence)object2))) == null || (object2 = CollectionsKt.subtract((Iterable)((Iterable)object2), (Iterable)validChars)) == null) {
            object2 = invalidNameChars = SetsKt.emptySet();
        }
        if ((object = objCName.getSwiftName()) == null || (object = StringsKt.toSet((CharSequence)((CharSequence)object))) == null || (object = CollectionsKt.subtract((Iterable)((Iterable)object), (Iterable)validChars)) == null) {
            object = SetsKt.emptySet();
        }
        if (!((Collection)(invalidChars = SetsKt.plus((Set)invalidNameChars, (Iterable)((Iterable)(invalidSwiftNameChars = object))))).isEmpty()) {
            context2.getTrace().report(ErrorsNative.INVALID_OBJC_NAME_CHARS.on((KtElement)((PsiElement)reportLocation), CollectionsKt.joinToString$default((Iterable)invalidChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)));
        }
        if (objCName.getExact() && (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY)) {
            context2.getTrace().report(ErrorsNative.INAPPLICABLE_EXACT_OBJC_NAME.on((KtElement)((PsiElement)reportLocation)));
        }
        if (objCName.getExact() && objCName.getName() == null) {
            context2.getTrace().report(ErrorsNative.MISSING_EXACT_OBJC_NAME.on((KtElement)((PsiElement)reportLocation)));
        }
    }

    private final ObjCName getObjCName(DeclarationDescriptor $this$getObjCName) {
        ObjCName objCName;
        AnnotationDescriptor annotationDescriptor = $this$getObjCName.getAnnotations().findAnnotation(objCNameFqName);
        if (annotationDescriptor != null) {
            AnnotationDescriptor p0 = annotationDescriptor;
            boolean bl = false;
            objCName = new ObjCName(p0);
        } else {
            objCName = null;
        }
        return objCName;
    }

    @NotNull
    public final List<ObjCName> getObjCNames(@NotNull DeclarationDescriptor $this$getObjCNames) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$getObjCNames, (String)"<this>");
        if ($this$getObjCNames instanceof FunctionDescriptor) {
            ObjCName objCName;
            ReceiverParameterDescriptor receiverParameterDescriptor;
            List list3;
            List $this$getObjCNames_u24lambda_u246 = list3 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$getObjCNames_u24lambda_u246.add(INSTANCE.getObjCName($this$getObjCNames));
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor = ((FunctionDescriptor)$this$getObjCNames).getExtensionReceiverParameter();
            if (receiverParameterDescriptor2 != null) {
                Intrinsics.checkNotNull((Object)receiverParameterDescriptor2);
                objCName = INSTANCE.getObjCName(receiverParameterDescriptor);
            } else {
                objCName = null;
            }
            $this$getObjCNames_u24lambda_u246.add(objCName);
            List<ValueParameterDescriptor> list4 = ((FunctionDescriptor)$this$getObjCNames).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getValueParameters(...)");
            Iterable $this$forEach$iv = list4;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                $this$getObjCNames_u24lambda_u246.add(INSTANCE.getObjCName(it));
            }
            list2 = CollectionsKt.build((List)list3);
        } else {
            list2 = CollectionsKt.listOf((Object)this.getObjCName($this$getObjCNames));
        }
        return list2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCNameChecker$ObjCName;", "", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;)V", "getAnnotation", "()Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "exact", "", "getExact", "()Z", "name", "", "getName", "()Ljava/lang/String;", "swiftName", "getSwiftName", "equals", "other", "hashCode", "", "frontend.native"})
    public static final class ObjCName {
        @NotNull
        private final AnnotationDescriptor annotation;
        @Nullable
        private final String name;
        @Nullable
        private final String swiftName;
        private final boolean exact;

        public ObjCName(@NotNull AnnotationDescriptor annotation2) {
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            this.annotation = annotation2;
            ConstantValue<?> constantValue = UtilsKt.argumentValue(this.annotation, "name");
            Object obj = constantValue != null ? constantValue.getValue() : null;
            this.name = obj instanceof String ? (String)obj : null;
            ConstantValue<?> constantValue2 = UtilsKt.argumentValue(this.annotation, "swiftName");
            obj = constantValue2 != null ? constantValue2.getValue() : null;
            this.swiftName = obj instanceof String ? (String)obj : null;
            ConstantValue<?> constantValue3 = UtilsKt.argumentValue(this.annotation, "exact");
            Object obj2 = constantValue3 != null ? constantValue3.getValue() : null;
            Boolean bl = obj2 instanceof Boolean ? (Boolean)obj2 : null;
            this.exact = bl != null ? bl : false;
        }

        @NotNull
        public final AnnotationDescriptor getAnnotation() {
            return this.annotation;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getSwiftName() {
            return this.swiftName;
        }

        public final boolean getExact() {
            return this.exact;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ObjCName && Intrinsics.areEqual((Object)this.name, (Object)((ObjCName)other).name) && Intrinsics.areEqual((Object)this.swiftName, (Object)((ObjCName)other).swiftName) && this.exact == ((ObjCName)other).exact;
        }

        public int hashCode() {
            String string2 = this.name;
            int result2 = string2 != null ? string2.hashCode() : 0;
            String string3 = this.swiftName;
            result2 = 31 * result2 + (string3 != null ? string3.hashCode() : 0);
            result2 = 31 * result2 + Boolean.hashCode(this.exact);
            return result2;
        }
    }
}

