/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.SpecialJvmAnnotations;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationMemberDefaultValueVisitor;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithArgs;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForClassFileStubBuilder;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.KClassValue;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.AbstractBinaryClassAnnotationLoader;
import org.jetbrains.kotlin.load.kotlin.AnnotationsContainerWithConstants;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.MemberSignature;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstantValueKt;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0002\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00030\u0001B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u0012H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0012H\u0014J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u001cH\u0004J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J&\u0010\u001e\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0014J \u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00032\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/AnnotationLoaderForClassFileStubBuilder;", "Lorg/jetbrains/kotlin/load/kotlin/AbstractBinaryClassAnnotationLoader;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/AnnotationWithArgs;", "Lorg/jetbrains/kotlin/load/kotlin/AnnotationsContainerWithConstants;", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "kotlinClassFinder", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "cachedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cachedFileContent", "", "jvmMetadataVersion", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;Lcom/intellij/openapi/vfs/VirtualFile;[BLorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;)V", "getJvmMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMetadataVersion;", "storage", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getAnnotationsContainer", "binaryClass", "getCachedFileContent", "kotlinClass", "isRepeatableWithImplicitContainer", "", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "arguments", "", "Lorg/jetbrains/kotlin/name/Name;", "loadAnnotation", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationArgumentVisitor;", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "result", "", "loadAnnotationsAndInitializers", "decompiler-to-file-stubs"})
@SourceDebugExtension(value={"SMAP\nKotlinClsStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/AnnotationLoaderForClassFileStubBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1187#2,2:241\n1261#2,4:243\n*S KotlinDebug\n*F\n+ 1 KotlinClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/AnnotationLoaderForClassFileStubBuilder\n*L\n161#1:241,2\n161#1:243,4\n*E\n"})
final class AnnotationLoaderForClassFileStubBuilder
extends AbstractBinaryClassAnnotationLoader<AnnotationWithArgs, AnnotationsContainerWithConstants<? extends AnnotationWithArgs, ? extends ConstantValue<?>>> {
    @NotNull
    private final VirtualFile cachedFile;
    @NotNull
    private final byte[] cachedFileContent;
    @NotNull
    private final JvmMetadataVersion jvmMetadataVersion;
    @NotNull
    private final MemoizedFunctionToNotNull<KotlinJvmBinaryClass, AnnotationsContainerWithConstants<AnnotationWithArgs, ConstantValue<?>>> storage;

    public AnnotationLoaderForClassFileStubBuilder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull VirtualFile cachedFile, @NotNull byte[] cachedFileContent, @NotNull JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        Intrinsics.checkNotNullParameter((Object)cachedFile, (String)"cachedFile");
        Intrinsics.checkNotNullParameter((Object)cachedFileContent, (String)"cachedFileContent");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"jvmMetadataVersion");
        super(kotlinClassFinder);
        this.cachedFile = cachedFile;
        this.cachedFileContent = cachedFileContent;
        this.jvmMetadataVersion = jvmMetadataVersion;
        this.storage = LockBasedStorageManager.NO_LOCKS.createMemoizedFunction((Function1)new Function1<KotlinJvmBinaryClass, AnnotationsContainerWithConstants<? extends AnnotationWithArgs, ? extends ConstantValue<?>>>(this){
            final /* synthetic */ AnnotationLoaderForClassFileStubBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final AnnotationsContainerWithConstants<AnnotationWithArgs, ConstantValue<?>> invoke(KotlinJvmBinaryClass kotlinClass) {
                Intrinsics.checkNotNullParameter((Object)kotlinClass, (String)"kotlinClass");
                return AnnotationLoaderForClassFileStubBuilder.access$loadAnnotationsAndInitializers(this.this$0, kotlinClass);
            }
        });
    }

    @Override
    @NotNull
    public JvmMetadataVersion getJvmMetadataVersion() {
        return this.jvmMetadataVersion;
    }

    @Override
    @NotNull
    protected AnnotationsContainerWithConstants<AnnotationWithArgs, ConstantValue<?>> getAnnotationsContainer(@NotNull KotlinJvmBinaryClass binaryClass) {
        Intrinsics.checkNotNullParameter((Object)binaryClass, (String)"binaryClass");
        return (AnnotationsContainerWithConstants)this.storage.invoke(binaryClass);
    }

    @Override
    @Nullable
    protected byte[] getCachedFileContent(@NotNull KotlinJvmBinaryClass kotlinClass) {
        Intrinsics.checkNotNullParameter((Object)kotlinClass, (String)"kotlinClass");
        VirtualFileKotlinClass virtualFileKotlinClass = kotlinClass instanceof VirtualFileKotlinClass ? (VirtualFileKotlinClass)kotlinClass : null;
        if (Intrinsics.areEqual((Object)(virtualFileKotlinClass != null ? virtualFileKotlinClass.getFile() : null), (Object)this.cachedFile)) {
            return this.cachedFileContent;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AnnotationWithArgs loadAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver2) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        List<ProtoBuf.Annotation.Argument> list2 = proto.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getArgumentList(...)");
        Iterable $this$associate$iv = list2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            ProtoBuf.Annotation.Argument it = (ProtoBuf.Annotation.Argument)element$iv$iv;
            boolean bl = false;
            Name name2 = NameResolverUtilKt.getName(nameResolver2, it.getNameId());
            ProtoBuf.Annotation.Argument.Value value2 = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"getValue(...)");
            Pair pair = TuplesKt.to((Object)name2, KotlinConstantValueKt.createConstantValue(value2, nameResolver2));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map args = destination$iv$iv;
        return new AnnotationWithArgs(NameResolverUtilKt.getClassId(nameResolver2, proto.getId()), args);
    }

    @Override
    @NotNull
    protected KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(@NotNull ClassId annotationClassId, @NotNull SourceElement source, @NotNull List<AnnotationWithArgs> result2) {
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        return new AnnotationMemberDefaultValueVisitor(this, annotationClassId, result2){
            final /* synthetic */ AnnotationLoaderForClassFileStubBuilder this$0;
            final /* synthetic */ ClassId $annotationClassId;
            final /* synthetic */ List<AnnotationWithArgs> $result;
            {
                this.this$0 = $receiver;
                this.$annotationClassId = $annotationClassId;
                this.$result = $result;
            }

            public void visitEnd() {
                if (!this.this$0.isRepeatableWithImplicitContainer(this.$annotationClassId, this.getArgs())) {
                    this.$result.add(new AnnotationWithArgs(this.$annotationClassId, this.getArgs()));
                }
            }
        };
    }

    protected final boolean isRepeatableWithImplicitContainer(@NotNull ClassId annotationClassId, @NotNull Map<Name, ? extends ConstantValue<?>> arguments2) {
        Intrinsics.checkNotNullParameter((Object)annotationClassId, (String)"annotationClassId");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        if (!Intrinsics.areEqual((Object)annotationClassId, (Object)SpecialJvmAnnotations.INSTANCE.getJAVA_LANG_ANNOTATION_REPEATABLE())) {
            return false;
        }
        ConstantValue<?> constantValue = arguments2.get(JvmAnnotationNames.DEFAULT_ANNOTATION_MEMBER_NAME);
        KClassValue kClassValue = constantValue instanceof KClassValue ? (KClassValue)constantValue : null;
        if (kClassValue == null) {
            return false;
        }
        KClassValue containerKClassValue = kClassValue;
        Object t = containerKClassValue.getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.constant.KClassValue.Value.NormalClass");
        return this.isImplicitRepeatableContainer(((KClassValue.Value.NormalClass)t).getClassId());
    }

    private final AnnotationsContainerWithConstants<AnnotationWithArgs, ConstantValue<?>> loadAnnotationsAndInitializers(KotlinJvmBinaryClass kotlinClass) {
        HashMap<MemberSignature, List<AnnotationWithArgs>> memberAnnotations = new HashMap<MemberSignature, List<AnnotationWithArgs>>();
        HashMap propertyConstants = new HashMap();
        HashMap annotationParametersDefaultValues = new HashMap();
        kotlinClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(this, memberAnnotations){
            final /* synthetic */ AnnotationLoaderForClassFileStubBuilder this$0;
            final /* synthetic */ HashMap<MemberSignature, List<AnnotationWithArgs>> $memberAnnotations;
            {
                this.this$0 = $receiver;
                this.$memberAnnotations = $memberAnnotations;
            }

            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(Name name2, String desc) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                String string2 = name2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                return new loadAnnotationsAndInitializers.AnnotationVisitorForMethod(this, MemberSignature.Companion.fromMethodNameAndDesc(string2, desc));
            }

            public KotlinJvmBinaryClass.AnnotationVisitor visitField(Name name2, String desc, Object initializer2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                String string2 = name2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                MemberSignature signature = MemberSignature.Companion.fromFieldNameAndDesc(string2, desc);
                return new loadAnnotationsAndInitializers.MemberAnnotationVisitor(this, signature);
            }
        }, this.getCachedFileContent(kotlinClass));
        return new AnnotationsContainerWithConstants((Map)memberAnnotations, propertyConstants, annotationParametersDefaultValues);
    }

    public static final /* synthetic */ KotlinJvmBinaryClass.AnnotationArgumentVisitor access$loadAnnotationIfNotSpecial(AnnotationLoaderForClassFileStubBuilder $this, ClassId annotationClassId, SourceElement source, List result2) {
        return $this.loadAnnotationIfNotSpecial(annotationClassId, source, result2);
    }

    public static final /* synthetic */ AnnotationsContainerWithConstants access$loadAnnotationsAndInitializers(AnnotationLoaderForClassFileStubBuilder $this, KotlinJvmBinaryClass kotlinClass) {
        return $this.loadAnnotationsAndInitializers(kotlinClass);
    }
}

