/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrMessageLoggerAdapter;", "Lorg/jetbrains/kotlin/util/Logger;", "irMessageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "(Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;)V", "error", "", "message", "", "fatal", "", "log", "warning", "ir.serialization.common"})
final class IrMessageLoggerAdapter
implements Logger {
    @NotNull
    private final IrMessageLogger irMessageLogger;

    public IrMessageLoggerAdapter(@NotNull IrMessageLogger irMessageLogger) {
        Intrinsics.checkNotNullParameter((Object)irMessageLogger, (String)"irMessageLogger");
        this.irMessageLogger = irMessageLogger;
    }

    @Override
    public void log(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.irMessageLogger.report(IrMessageLogger.Severity.INFO, message2, null);
    }

    @Override
    public void warning(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.irMessageLogger.report(IrMessageLogger.Severity.WARNING, message2, null);
    }

    @Override
    public void error(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.irMessageLogger.report(IrMessageLogger.Severity.ERROR, message2, null);
    }

    @Override
    @Deprecated(message="Invocation of fatal() may cause severe side effects such as throwing an exception or even terminating the current JVM process (check various implementations of this function for details). The code that uses Logger.fatal() sometimes expects a particular kind of side effect. This is an undesirable design. And it's definitely not a responsibility of Logger to influence the execution flow of the program.", replaceWith=@ReplaceWith(expression="error(message)", imports={}))
    @NotNull
    public Void fatal(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.error(message2);
        throw new CompilationErrorException();
    }
}

