/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.actualizer.ActualFakeOverridesAdder;
import org.jetbrains.kotlin.backend.common.actualizer.ActualizerSymbolRemapper;
import org.jetbrains.kotlin.backend.common.actualizer.ActualizerVisitor;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualCollector;
import org.jetbrains.kotlin.backend.common.actualizer.FakeOverridesActualizer;
import org.jetbrains.kotlin.backend.common.actualizer.FunctionDefaultParametersActualizer;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizedResult;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.checker.IrExpectActualCheckers;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0006\u0010 \u001a\u00020!J\u001e\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J0\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u001a\u0010&\u001a\u00020'2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eJ$\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/IrActualizer;", "", "ktDiagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "useFirBasedFakeOverrideGenerator", "", "mainFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependentFragments", "", "(Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;ZLorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Ljava/util/List;)V", "classActualizationInfo", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "collector", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector;", "getDependentFragments", "()Ljava/util/List;", "getKtDiagnosticReporter", "()Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "getMainFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getTypeSystemContext", "()Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "getUseFirBasedFakeOverrideGenerator", "()Z", "actualizeCallablesAndMergeModules", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualizeClassifiers", "", "mergeIrFragments", "removeExpectDeclarations", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "expectActualMap", "runChecksAndFinalize", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrActualizedResult;", "shouldRemoveExpectDeclaration", "irDeclaration", "ir.actualization"})
@SourceDebugExtension(value={"SMAP\nIrActualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrActualizer.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1863#2,2:151\n1863#2,2:154\n1863#2,2:156\n1863#2,2:158\n1368#2:160\n1454#2,5:161\n1#3:153\n*S KotlinDebug\n*F\n+ 1 IrActualizer.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizer\n*L\n74#1:151,2\n84#1:154,2\n92#1:156,2\n101#1:158,2\n144#1:160\n144#1:161,5\n*E\n"})
public final class IrActualizer {
    @NotNull
    private final IrDiagnosticReporter ktDiagnosticReporter;
    @NotNull
    private final IrTypeSystemContext typeSystemContext;
    private final boolean useFirBasedFakeOverrideGenerator;
    @NotNull
    private final IrModuleFragment mainFragment;
    @NotNull
    private final List<IrModuleFragment> dependentFragments;
    @NotNull
    private final ExpectActualCollector collector;
    @NotNull
    private final ClassActualizationInfo classActualizationInfo;

    public IrActualizer(@NotNull IrDiagnosticReporter ktDiagnosticReporter, @NotNull IrTypeSystemContext typeSystemContext2, @Nullable ExpectActualTracker expectActualTracker, boolean useFirBasedFakeOverrideGenerator, @NotNull IrModuleFragment mainFragment, @NotNull List<? extends IrModuleFragment> dependentFragments) {
        Intrinsics.checkNotNullParameter((Object)ktDiagnosticReporter, (String)"ktDiagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
        Intrinsics.checkNotNullParameter((Object)mainFragment, (String)"mainFragment");
        Intrinsics.checkNotNullParameter(dependentFragments, (String)"dependentFragments");
        this.ktDiagnosticReporter = ktDiagnosticReporter;
        this.typeSystemContext = typeSystemContext2;
        this.useFirBasedFakeOverrideGenerator = useFirBasedFakeOverrideGenerator;
        this.mainFragment = mainFragment;
        this.dependentFragments = dependentFragments;
        this.collector = new ExpectActualCollector(this.mainFragment, this.dependentFragments, this.typeSystemContext, this.ktDiagnosticReporter, expectActualTracker);
        this.classActualizationInfo = this.collector.collectClassActualizationInfo();
    }

    @NotNull
    public final IrDiagnosticReporter getKtDiagnosticReporter() {
        return this.ktDiagnosticReporter;
    }

    @NotNull
    public final IrTypeSystemContext getTypeSystemContext() {
        return this.typeSystemContext;
    }

    public final boolean getUseFirBasedFakeOverrideGenerator() {
        return this.useFirBasedFakeOverrideGenerator;
    }

    @NotNull
    public final IrModuleFragment getMainFragment() {
        return this.mainFragment;
    }

    @NotNull
    public final List<IrModuleFragment> getDependentFragments() {
        return this.dependentFragments;
    }

    public final void actualizeClassifiers() {
        SymbolRemapper.Empty classSymbolRemapper2 = new SymbolRemapper.Empty(this){
            final /* synthetic */ IrActualizer this$0;
            {
                this.this$0 = $receiver;
            }

            public IrClassSymbol getReferencedClass(IrClassSymbol symbol2) {
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                if (!((IrClass)symbol2.getOwner()).isExpect()) {
                    return symbol2;
                }
                if (IrActualizerUtilsKt.containsOptionalExpectation(symbol2.getOwner())) {
                    return symbol2;
                }
                ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail((IrClass)symbol2.getOwner());
                IrBindableSymbol<TypeAliasDescriptor, IrTypeAlias> irBindableSymbol = IrActualizer.access$getClassActualizationInfo$p(this.this$0).getActualTypeAliases().get(classId);
                if (irBindableSymbol != null) {
                    IrTypeAliasSymbol it = irBindableSymbol;
                    boolean bl = false;
                    return IrTypesKt.getClassOrFail(((IrTypeAlias)it.getOwner()).getExpandedType());
                }
                irBindableSymbol = IrActualizer.access$getClassActualizationInfo$p(this.this$0).getActualClasses().get(classId);
                if (irBindableSymbol != null) {
                    IrBindableSymbol<TypeAliasDescriptor, IrTypeAlias> it = irBindableSymbol;
                    boolean bl = false;
                    return it;
                }
                return symbol2;
            }

            public IrClassSymbol getReferencedClassOrNull(IrClassSymbol symbol2) {
                if (symbol2 == null) {
                    return null;
                }
                return this.getReferencedClass(symbol2);
            }

            public IrClassifierSymbol getReferencedClassifier(IrClassifierSymbol symbol2) {
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                if (!(symbol2 instanceof IrClassSymbol)) {
                    return symbol2;
                }
                return this.getReferencedClass((IrClassSymbol)symbol2);
            }
        };
        Iterable $this$forEach$iv = this.dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl = false;
            it.transform((IrElementTransformer)new ActualizerVisitor(classSymbolRemapper2), (Object)null);
        }
    }

    @NotNull
    public final Map<IrSymbol, IrSymbol> actualizeCallablesAndMergeModules() {
        Map<IrSymbol, IrSymbol> expectActualMap = this.collector.collect(this.classActualizationInfo);
        if (this.useFirBasedFakeOverrideGenerator) {
            IrModuleFragment it;
            IrElementVisitorVoid irElementVisitorVoid = new FakeOverridesActualizer(expectActualMap, this.ktDiagnosticReporter);
            FakeOverridesActualizer $this$actualizeCallablesAndMergeModules_u24lambda_u242 = irElementVisitorVoid;
            boolean bl = false;
            Iterable $this$forEach$iv = this.dependentFragments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrModuleFragment)element$iv;
                boolean bl2 = false;
                $this$actualizeCallablesAndMergeModules_u24lambda_u242.visitModuleFragment(it);
            }
            IrElementVisitorVoid $this$actualizeCallablesAndMergeModules_u24lambda_u244 = irElementVisitorVoid = new ActualFakeOverridesAdder(expectActualMap, this.classActualizationInfo.getActualClasses(), this.typeSystemContext);
            boolean bl3 = false;
            $this$forEach$iv = this.dependentFragments;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrModuleFragment)element$iv;
                boolean bl4 = false;
                ((ActualFakeOverridesAdder)$this$actualizeCallablesAndMergeModules_u24lambda_u244).visitModuleFragment(it);
            }
        }
        ActualizerSymbolRemapper symbolRemapper = new ActualizerSymbolRemapper(expectActualMap);
        new FunctionDefaultParametersActualizer(symbolRemapper, expectActualMap).actualize();
        ActualizerVisitor actualizerVisitor = new ActualizerVisitor(symbolRemapper);
        Iterable $this$forEach$iv = this.dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl = false;
            it.transform((IrElementTransformer)actualizerVisitor, (Object)null);
        }
        this.mergeIrFragments(this.mainFragment, this.dependentFragments);
        return expectActualMap;
    }

    @NotNull
    public final IrActualizedResult runChecksAndFinalize(@NotNull Map<IrSymbol, ? extends IrSymbol> expectActualMap) {
        Intrinsics.checkNotNullParameter(expectActualMap, (String)"expectActualMap");
        List<IrDeclaration> removedExpectDeclarations = this.removeExpectDeclarations(this.dependentFragments, expectActualMap);
        new IrExpectActualCheckers(expectActualMap, this.classActualizationInfo, this.typeSystemContext, this.ktDiagnosticReporter).check();
        return new IrActualizedResult(removedExpectDeclarations, expectActualMap);
    }

    private final List<IrDeclaration> removeExpectDeclarations(List<? extends IrModuleFragment> dependentFragments, Map<IrSymbol, ? extends IrSymbol> expectActualMap) {
        List removedExpectDeclarations = new ArrayList();
        for (IrModuleFragment irModuleFragment : dependentFragments) {
            for (IrFile file2 : irModuleFragment.getFiles()) {
                file2.getDeclarations().removeIf(arg_0 -> IrActualizer.removeExpectDeclarations$lambda$6((Function1)new Function1<IrDeclaration, Boolean>(this, expectActualMap, (List<IrDeclaration>)removedExpectDeclarations){
                    final /* synthetic */ IrActualizer this$0;
                    final /* synthetic */ Map<IrSymbol, IrSymbol> $expectActualMap;
                    final /* synthetic */ List<IrDeclaration> $removedExpectDeclarations;
                    {
                        this.this$0 = $receiver;
                        this.$expectActualMap = $expectActualMap;
                        this.$removedExpectDeclarations = $removedExpectDeclarations;
                        super(1);
                    }

                    public final Boolean invoke(IrDeclaration it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (IrActualizer.access$shouldRemoveExpectDeclaration(this.this$0, it, this.$expectActualMap)) {
                            this.$removedExpectDeclarations.add(it);
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }
                }, arg_0));
            }
        }
        return removedExpectDeclarations;
    }

    private final boolean shouldRemoveExpectDeclaration(IrDeclaration irDeclaration2, Map<IrSymbol, ? extends IrSymbol> expectActualMap) {
        IrDeclaration irDeclaration3 = irDeclaration2;
        return irDeclaration3 instanceof IrClass ? ((IrClass)irDeclaration2).isExpect() && (!IrActualizerUtilsKt.containsOptionalExpectation(irDeclaration2) || expectActualMap.containsKey(((IrClass)irDeclaration2).getSymbol())) : (irDeclaration3 instanceof IrProperty ? ((IrProperty)irDeclaration2).isExpect() : (irDeclaration3 instanceof IrFunction ? ((IrFunction)irDeclaration2).isExpect() : false));
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeIrFragments(IrModuleFragment mainFragment, List<? extends IrModuleFragment> dependentFragments) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = dependentFragments;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List newFiles = (List)destination$iv$iv;
        for (IrFile file2 : newFiles) {
            file2.setModule(mainFragment);
        }
        mainFragment.getFiles().addAll(0, newFiles);
    }

    private static final boolean removeExpectDeclarations$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ClassActualizationInfo access$getClassActualizationInfo$p(IrActualizer $this) {
        return $this.classActualizationInfo;
    }

    public static final /* synthetic */ boolean access$shouldRemoveExpectDeclaration(IrActualizer $this, IrDeclaration irDeclaration2, Map expectActualMap) {
        return $this.shouldRemoveExpectDeclaration(irDeclaration2, expectActualMap);
    }
}

