/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirConflictsDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.PlatformConflictDeclarationsDiagnosticDispatcher;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSessionKey;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JB\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2 \u0010\u001b\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002R\u001c\u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "isPrimaryConstructor", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "inspector", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;", "getDestructuredParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "reportConflicts", "declarationConflictingSymbols", "", "Lorg/jetbrains/kotlin/utils/SmartSet;", "container", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ScopeSession.kt\norg/jetbrains/kotlin/fir/resolve/ScopeSession\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,171:1\n2632#2,3:172\n774#2:175\n865#2,2:176\n1628#2,3:178\n1619#2:181\n1863#2:182\n1864#2:184\n1620#2:185\n1734#2,3:187\n1#3:183\n1#3:190\n216#4:186\n217#4:191\n18#5:192\n19#5:196\n20#5,2:201\n381#6,3:193\n384#6,4:197\n*S KotlinDebug\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n*L\n90#1:172,3\n92#1:175\n92#1:176,2\n93#1:178,3\n95#1:181\n95#1:182\n95#1:184\n95#1:185\n122#1:187,3\n95#1:183\n107#1:186\n107#1:191\n143#1:192\n143#1:196\n143#1:201,2\n143#1:193,3\n143#1:197,4\n*E\n"})
public final class FirConflictsDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictsDeclarationChecker INSTANCE = new FirConflictsDeclarationChecker();

    private FirConflictsDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirFile) {
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            this.checkFile((FirFile)declaration, inspector, context2);
            this.reportConflicts(reporter2, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration);
        } else if (firDeclaration instanceof FirRegularClass) {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirRegularClass)declaration).getTypeParameters(), context2, reporter2);
            }
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            FirConflictsHelpersKt.collectClassMembers(inspector, ((FirRegularClass)declaration).getSymbol());
            this.reportConflicts(reporter2, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration);
        } else {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && declaration instanceof FirTypeParameterRefsOwner) {
                if (declaration instanceof FirFunction) {
                    List<FirVariable> destructuredParameters = this.getDestructuredParameters((FirFunction)declaration);
                    FirConflictsHelpersKt.checkForLocalRedeclarations(destructuredParameters, context2, reporter2);
                }
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirTypeParameterRefsOwner)((Object)declaration)).getTypeParameters(), context2, reporter2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirVariable> getDestructuredParameters(FirFunction function2) {
        void $this$mapNotNullTo$iv;
        Collection destination$iv;
        Iterator iterator2;
        Iterable $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block8: {
            Iterable $this$none$iv = function2.getValueParameters();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$none$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)SpecialNames.DESTRUCT)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return function2.getValueParameters();
        }
        Iterable $this$filter$iv = function2.getValueParameters();
        boolean $i$f$filter22 = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirValueParameter it = (FirValueParameter)element$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)SpecialNames.DESTRUCT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection $i$f$filter22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            iterator2 = (FirValueParameter)item$iv;
            void var17_19 = destination$iv;
            boolean bl4 = false;
            var17_19.add(it.getSymbol());
        }
        Set destructuredParametersBoxes = (Set)destination$iv;
        FirBlock firBlock = function2.getBody();
        List list2 = firBlock != null ? firBlock.getStatements() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$mapTo$iv = list2;
        destination$iv = CollectionsKt.toMutableList((Collection)function2.getValueParameters());
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirVariable it$iv;
            Object destructuredParameter;
            Object element$iv$iv;
            Object element$iv3 = element$iv$iv = iterator2.next();
            boolean bl5 = false;
            FirStatement it = (FirStatement)element$iv3;
            boolean bl6 = false;
            Object object = it instanceof FirVariable ? (FirVariable)it : null;
            if ((object == null || (object = FirConflictsHelpersKt.getDestructuredParameter((FirVariable)object)) == null ? null : (destructuredParametersBoxes.contains(destructuredParameter = object) ? (FirVariable)it : null)) == null) continue;
            it$iv = it$iv;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        return (List)destination$iv;
    }

    private final void reportConflicts(DiagnosticReporter reporter2, CheckerContext context2, Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> declarationConflictingSymbols, FirDeclaration container2) {
        Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> $this$forEach$iv = declarationConflictingSymbols;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            PlatformConflictDeclarationsDiagnosticDispatcher dispatcher;
            KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> factory2;
            boolean bl;
            KtSourceElement source;
            KtSourceElement ktSourceElement;
            Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> element$iv;
            Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            FirBasedSymbol<?> conflictingDeclaration = entry.getKey();
            SmartSet<FirBasedSymbol<?>> symbols = entry.getValue();
            FirBasedSymbol firBasedSymbol = conflictingDeclaration instanceof FirConstructorSymbol ? (FirConstructorSymbol)conflictingDeclaration : null;
            KtSourceElement typeAliasForConstructorSource = firBasedSymbol != null && (firBasedSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirConstructorSymbol)firBasedSymbol)) != null ? firBasedSymbol.getSource() : null;
            FirDeclarationOrigin origin = conflictingDeclaration.getOrigin();
            if (!(conflictingDeclaration instanceof FirCallableSymbol)) {
                ktSourceElement = conflictingDeclaration.getSource();
            } else if (Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
                ktSourceElement = conflictingDeclaration.getSource();
            } else {
                if (Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Library.INSTANCE)) continue;
                ktSourceElement = source = Intrinsics.areEqual((Object)origin, (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE) ? typeAliasForConstructorSource : container2.getSource();
            }
            if (symbols.isEmpty()) continue;
            if (INSTANCE.isPrimaryConstructor(conflictingDeclaration)) {
                boolean bl3;
                block13: {
                    Iterable $this$all$iv = (Iterable)((Object)symbols);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            FirBasedSymbol it = (FirBasedSymbol)element$iv2;
                            boolean bl4 = false;
                            if (INSTANCE.isPrimaryConstructor(it)) continue;
                            bl3 = false;
                            break block13;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) continue;
            }
            if ((FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)((Iterable)((Object)symbols))) != null) {
                FirBasedSymbol it;
                boolean bl5 = false;
                bl = FirConflictsHelpersKt.isExpectAndNonExpect(conflictingDeclaration, it);
            } else {
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECT_AND_ACTUAL_IN_THE_SAME_MODULE(), conflictingDeclaration, (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            PlatformConflictDeclarationsDiagnosticDispatcher platformConflictDeclarationsDiagnosticDispatcher = FirConflictsDeclarationCheckerKt.getConflictDeclarationsDiagnosticDispatcher(context2.getSession());
            if (platformConflictDeclarationsDiagnosticDispatcher == null) {
                platformConflictDeclarationsDiagnosticDispatcher = PlatformConflictDeclarationsDiagnosticDispatcher.DEFAULT.INSTANCE;
            }
            if ((factory2 = (dispatcher = platformConflictDeclarationsDiagnosticDispatcher).getDiagnostic(conflictingDeclaration, symbols, context2)) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, factory2, symbols, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isPrimaryConstructor(FirBasedSymbol<?> $this$isPrimaryConstructor) {
        return $this$isPrimaryConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isPrimaryConstructor).isPrimary() || Intrinsics.areEqual((Object)$this$isPrimaryConstructor.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFile(FirFile file2, FirDeclarationCollector<FirBasedSymbol<?>> inspector, CheckerContext context2) {
        Object object;
        Object object2;
        void id$iv;
        void this_$iv;
        ScopeSession scopeSession = context2.getSessionHolder().getScopeSession();
        FqName fqName2 = UtilsKt.getPackageFqName(file2);
        ScopeSessionKey<FqName, FirPackageMemberScope> key$iv = FirPackageMemberScopeKt.getPACKAGE_MEMBER();
        boolean $i$f$getOrBuild = false;
        Map $this$getOrPut$iv$iv = this_$iv.scopes();
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(id$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            HashMap answer$iv$iv = new HashMap();
            $this$getOrPut$iv$iv.put(id$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        $this$getOrPut$iv$iv = (Map)object2;
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            FirPackageMemberScope answer$iv$iv = new FirPackageMemberScope(UtilsKt.getPackageFqName(file2), context2.getSessionHolder().getSession(), null, null, 12, null);
            $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        FirPackageMemberScope packageMemberScope = (FirPackageMemberScope)object;
        FirConflictsHelpersKt.collectTopLevel(inspector, file2, packageMemberScope);
    }
}

