/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u00101\u001a\u0004\u0018\u00010,*\u0006\u0012\u0002\b\u00030\u001f2\u0006\u00102\u001a\u000203\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0016\"\u0015\u0010\u0017\u001a\u00020\u0014*\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019\"\u0016\u0010\u001a\u001a\u00020\u0014*\u00020\u001b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\"\u0016\u0010\u001d\u001a\u00020\u0014*\u00020\u001b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001c\"\u0019\u0010\u001e\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 \"\u0015\u0010!\u001a\u00020\u0014*\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#\"\u0015\u0010$\u001a\u00020\u0014*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001c\"\u0016\u0010%\u001a\u00020\u0014*\u00020\u001b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001c\"\u0016\u0010&\u001a\u00020\u0014*\u00020\u001b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001c\"\u001b\u0010'\u001a\u0004\u0018\u00010(*\u0006\u0012\u0002\b\u00030\u001f8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\"\u0015\u0010+\u001a\u00020(*\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\"\u001b\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0005\u00a8\u00064"}, d2={"anonymousInitializers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getAnonymousInitializers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Ljava/util/List;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getClassId", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Lorg/jetbrains/kotlin/name/ClassId;", "delegateFields", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "getDelegateFields", "expandedConeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "getExpandedConeType", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "isErrorPrimaryConstructor", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;)Z", "isExtension", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Z", "isFromLibrary", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "isJava", "isMemberDeclaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isMethodOfAny", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)Z", "isNonLocal", "isPrecompiled", "isSynthetic", "memberDeclarationNameOrNull", "Lorg/jetbrains/kotlin/name/Name;", "getMemberDeclarationNameOrNull", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/name/Name;", "nameOrSpecialName", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "getNameOrSpecialName", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Lorg/jetbrains/kotlin/name/Name;", "superConeTypes", "getSuperConeTypes", "asMemberDeclarationResolvedTo", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "tree"})
@SourceDebugExtension(value={"SMAP\nFirDeclarationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n39#1:131\n23#2,4:86\n23#2,4:100\n1611#3,9:90\n1863#3:99\n1864#3:105\n1620#3:106\n808#3,11:107\n808#3,11:118\n774#3:129\n865#3:130\n866#3:132\n1#4:104\n*S KotlinDebug\n*F\n+ 1 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n30#1:131\n19#1:86,4\n24#1:100,4\n24#1:90,9\n24#1:99\n24#1:105\n24#1:106\n27#1:107,11\n30#1:118,11\n30#1:129\n30#1:130\n30#1:132\n24#1:104\n*E\n"})
public final class FirDeclarationUtilKt {
    @Nullable
    public static final ConeClassLikeType getExpandedConeType(@NotNull FirTypeAlias $this$expandedConeType) {
        Intrinsics.checkNotNullParameter((Object)$this$expandedConeType, (String)"<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$expandedConeType.getExpandedTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
    }

    @NotNull
    public static final ClassId getClassId(@NotNull FirClassLikeDeclaration $this$classId) {
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"<this>");
        return $this$classId.getSymbol().getClassId();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeClassLikeType> getSuperConeTypes(@NotNull FirClass $this$superConeTypes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$superConeTypes, (String)"<this>");
        Iterable $this$mapNotNull$iv = $this$superConeTypes.getSuperTypeRefs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConeClassLikeType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl2 = false;
            FirTypeRef $this$coneTypeSafe$iv = it;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnonymousInitializer> getAnonymousInitializers(@NotNull FirClass $this$anonymousInitializers) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$anonymousInitializers, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$anonymousInitializers.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirField> getDelegateFields(@NotNull FirClass $this$delegateFields) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$delegateFields, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$delegateFields.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirField it = (FirField)element$iv$iv;
            boolean bl = false;
            FirDeclaration $this$isSynthetic$iv = it;
            boolean $i$f$isSynthetic = false;
            if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isJava(@NotNull FirDeclaration $this$isJava) {
        Intrinsics.checkNotNullParameter((Object)$this$isJava, (String)"<this>");
        boolean $i$f$isJava = false;
        return $this$isJava.getOrigin() instanceof FirDeclarationOrigin.Java;
    }

    public static final boolean isFromLibrary(@NotNull FirDeclaration $this$isFromLibrary) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromLibrary, (String)"<this>");
        boolean $i$f$isFromLibrary = false;
        return Intrinsics.areEqual((Object)$this$isFromLibrary.getOrigin(), (Object)FirDeclarationOrigin.Library.INSTANCE) || Intrinsics.areEqual((Object)$this$isFromLibrary.getOrigin(), (Object)FirDeclarationOrigin.Java.Library.INSTANCE);
    }

    public static final boolean isPrecompiled(@NotNull FirDeclaration $this$isPrecompiled) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrecompiled, (String)"<this>");
        boolean $i$f$isPrecompiled = false;
        return Intrinsics.areEqual((Object)$this$isPrecompiled.getOrigin(), (Object)FirDeclarationOrigin.Precompiled.INSTANCE);
    }

    public static final boolean isSynthetic(@NotNull FirDeclaration $this$isSynthetic) {
        Intrinsics.checkNotNullParameter((Object)$this$isSynthetic, (String)"<this>");
        boolean $i$f$isSynthetic = false;
        return $this$isSynthetic.getOrigin() instanceof FirDeclarationOrigin.Synthetic;
    }

    public static final boolean isNonLocal(@NotNull FirDeclaration $this$isNonLocal) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonLocal, (String)"<this>");
        FirDeclaration firDeclaration = $this$isNonLocal;
        return firDeclaration instanceof FirFile ? true : (firDeclaration instanceof FirCallableDeclaration ? !((FirCallableDeclaration)$this$isNonLocal).getSymbol().getCallableId().isLocal() : (firDeclaration instanceof FirClassLikeDeclaration ? !((FirClassLikeDeclaration)$this$isNonLocal).getSymbol().getClassId().isLocal() : false));
    }

    public static final boolean isExtension(@NotNull FirCallableDeclaration $this$isExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtension, (String)"<this>");
        return $this$isExtension.getReceiverParameter() != null;
    }

    public static final boolean isMemberDeclaration(@NotNull FirBasedSymbol<?> $this$isMemberDeclaration) {
        Intrinsics.checkNotNullParameter($this$isMemberDeclaration, (String)"<this>");
        return $this$isMemberDeclaration.getFir() instanceof FirMemberDeclaration;
    }

    @Nullable
    public static final Name getMemberDeclarationNameOrNull(@NotNull FirBasedSymbol<?> $this$memberDeclarationNameOrNull) {
        Intrinsics.checkNotNullParameter($this$memberDeclarationNameOrNull, (String)"<this>");
        Object obj = $this$memberDeclarationNameOrNull.getFir();
        FirMemberDeclaration firMemberDeclaration = obj instanceof FirMemberDeclaration ? (FirMemberDeclaration)obj : null;
        return firMemberDeclaration != null ? FirDeclarationUtilKt.getNameOrSpecialName(firMemberDeclaration) : null;
    }

    @NotNull
    public static final Name getNameOrSpecialName(@NotNull FirMemberDeclaration $this$nameOrSpecialName) {
        Name name2;
        Intrinsics.checkNotNullParameter((Object)$this$nameOrSpecialName, (String)"<this>");
        FirMemberDeclaration firMemberDeclaration = $this$nameOrSpecialName;
        if (firMemberDeclaration instanceof FirCallableDeclaration) {
            name2 = ((FirCallableDeclaration)$this$nameOrSpecialName).getSymbol().getCallableId().getCallableName();
        } else if (firMemberDeclaration instanceof FirClassLikeDeclaration) {
            name2 = FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)$this$nameOrSpecialName).getShortClassName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return name2;
    }

    @Nullable
    public static final FirMemberDeclaration asMemberDeclarationResolvedTo(@NotNull FirBasedSymbol<?> $this$asMemberDeclarationResolvedTo, @NotNull FirResolvePhase phase) {
        FirMemberDeclaration firMemberDeclaration;
        Intrinsics.checkNotNullParameter($this$asMemberDeclarationResolvedTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        Object object = $this$asMemberDeclarationResolvedTo.getFir();
        FirMemberDeclaration firMemberDeclaration2 = object instanceof FirMemberDeclaration ? (FirMemberDeclaration)object : null;
        if (firMemberDeclaration2 != null) {
            Object it = object = firMemberDeclaration2;
            boolean bl = false;
            FirLazyDeclarationResolverKt.lazyResolveToPhase($this$asMemberDeclarationResolvedTo, phase);
            firMemberDeclaration = (FirMemberDeclaration)object;
        } else {
            firMemberDeclaration = null;
        }
        return firMemberDeclaration;
    }

    public static final boolean isMethodOfAny(@NotNull FirNamedFunctionSymbol $this$isMethodOfAny) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isMethodOfAny, (String)"<this>");
        if ($this$isMethodOfAny.getReceiverParameter() != null) {
            return false;
        }
        if (!((Collection)$this$isMethodOfAny.getResolvedContextReceivers()).isEmpty()) {
            return false;
        }
        Name name2 = $this$isMethodOfAny.getName();
        return Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.EQUALS) ? ((object = (FirValueParameterSymbol)CollectionsKt.singleOrNull($this$isMethodOfAny.getValueParameterSymbols())) != null && (object = ((FirCallableSymbol)object).getResolvedReturnType()) != null ? ConeBuiltinTypeUtilsKt.isNullableAny((ConeKotlinType)object) : false) : ((Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.HASH_CODE) ? true : Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.TO_STRING)) ? ((FirSimpleFunction)$this$isMethodOfAny.getFir()).getValueParameters().isEmpty() : false);
    }

    public static final boolean isErrorPrimaryConstructor(@NotNull FirConstructorSymbol $this$isErrorPrimaryConstructor) {
        Intrinsics.checkNotNullParameter((Object)$this$isErrorPrimaryConstructor, (String)"<this>");
        return $this$isErrorPrimaryConstructor.getFir() instanceof FirErrorPrimaryConstructor;
    }
}

