/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.descriptors;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.ModuleCapability;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.descriptors.FirPackageViewDescriptor;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u0001:\u0001BB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010*\u001a\u00020+2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.\u0018\u00010-H\u0016J\b\u0010/\u001a\u00020+H\u0016J#\u00100\u001a\u0004\u0018\u0001H1\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H103H\u0016\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020'H\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J*\u0010<\u001a\b\u0012\u0004\u0012\u00020;0=2\u0006\u0010:\u001a\u00020;2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001c0?H\u0016J\u0010\u0010@\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020\u0001H\u0016R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "allDependencyModules", "", "getAllDependencyModules", "()Ljava/util/List;", "setAllDependencyModules", "(Ljava/util/List;)V", "allExpectedByModules", "", "getAllExpectedByModules", "()Ljava/util/Set;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "getAnnotations", "()Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "expectedByModules", "getExpectedByModules", "isValid", "", "()Z", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "stableName", "Lorg/jetbrains/kotlin/name/Name;", "getStableName", "()Lorg/jetbrains/kotlin/name/Name;", "acceptVoid", "", "visitor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;", "Ljava/lang/Void;", "assertValid", "getCapability", "T", "capability", "Lorg/jetbrains/kotlin/descriptors/ModuleCapability;", "(Lorg/jetbrains/kotlin/descriptors/ModuleCapability;)Ljava/lang/Object;", "getName", "getOriginal", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getPackage", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getSubPackagesOf", "", "nameFilter", "Lkotlin/Function1;", "shouldSeeInternalsOf", "targetModule", "Companion", "fir2ir"})
public final class FirModuleDescriptor
implements ModuleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirModuleData moduleData;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private List<? extends ModuleDescriptor> allDependencyModules;

    private FirModuleDescriptor(FirSession session2, FirModuleData moduleData, KotlinBuiltIns builtIns2) {
        this.session = session2;
        this.moduleData = moduleData;
        this.builtIns = builtIns2;
        this.allDependencyModules = CollectionsKt.emptyList();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirModuleData getModuleData() {
        return this.moduleData;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @Override
    public boolean shouldSeeInternalsOf(@NotNull ModuleDescriptor targetModule) {
        Intrinsics.checkNotNullParameter((Object)targetModule, (String)"targetModule");
        if (!(targetModule instanceof FirModuleDescriptor)) {
            return false;
        }
        FirModuleData firModuleData = ((FirModuleDescriptor)targetModule).moduleData;
        return (Intrinsics.areEqual((Object)firModuleData, (Object)this.moduleData) ? true : this.moduleData.getFriendDependencies().contains(firModuleData)) ? true : this.moduleData.getDependsOnDependencies().contains(firModuleData);
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return this.moduleData.getPlatform();
    }

    @Override
    @NotNull
    public PackageViewDescriptor getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
        if (symbolProvider.getPackage(fqName2) != null) {
            return new FirPackageViewDescriptor(fqName2, this);
        }
        throw new IllegalStateException(("Module " + this.moduleData + " doesn't contain package " + fqName2).toString());
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    @Override
    @NotNull
    public List<ModuleDescriptor> getAllDependencyModules() {
        return this.allDependencyModules;
    }

    public void setAllDependencyModules(@NotNull List<? extends ModuleDescriptor> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.allDependencyModules = list2;
    }

    @Override
    @NotNull
    public List<ModuleDescriptor> getExpectedByModules() {
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    @Override
    @NotNull
    public Set<ModuleDescriptor> getAllExpectedByModules() {
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull ModuleCapability<T> capability) {
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        return null;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void assertValid() {
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.moduleData.getName();
    }

    @Override
    @NotNull
    public Name getStableName() {
        return this.getName();
    }

    @Override
    public void acceptVoid(@Nullable DeclarationDescriptorVisitor<Void, Void> visitor2) {
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return Annotations.Companion.getEMPTY();
    }

    @Override
    @Nullable
    public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return ModuleDescriptor.DefaultImpls.accept(this, visitor2, data2);
    }

    @Override
    @Nullable
    public DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor.DefaultImpls.getContainingDeclaration(this);
    }

    public /* synthetic */ FirModuleDescriptor(FirSession session2, FirModuleData moduleData, KotlinBuiltIns builtIns2, DefaultConstructorMarker $constructor_marker) {
        this(session2, moduleData, builtIns2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor$Companion;", "", "()V", "createDependencyModuleDescriptor", "Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "createSourceModuleDescriptor", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "fir2ir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirModuleDescriptor createSourceModuleDescriptor(@NotNull FirSession session2, @NotNull KotlinBuiltIns builtIns2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
            if (!(session2.getKind() == FirSession.Kind.Source)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            return new FirModuleDescriptor(session2, FirModuleDataKt.getModuleData(session2), builtIns2, null);
        }

        @NotNull
        public final FirModuleDescriptor createDependencyModuleDescriptor(@NotNull FirModuleData moduleData, @NotNull KotlinBuiltIns builtIns2) {
            Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
            Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
            return new FirModuleDescriptor(moduleData.getSession(), moduleData, builtIns2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

