/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAssignmentOperatorStatement;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.Stack;
import org.jetbrains.kotlin.fir.resolve.dfa.StackKt;
import org.jetbrains.kotlin.fir.resolve.dfa.UtilKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\u00020\u00162\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010#\u001a\u00020$J&\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\tH\u0002J\u0006\u0010(\u001a\u00020\u0016J\u0006\u0010)\u001a\u00020\u0016J\u000e\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\tJ\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0012\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020\u0001H\u0002J \u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204J*\u00105\u001a\u00020\t2\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010 2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0002J\u0006\u00107\u001a\u00020\u0016J\u0016\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u000202R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u000e0\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "", "()V", "assignedLocalVariablesByDeclaration", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "postponedLambdas", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Stack;", "", "", "rootFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "scopes", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "variableAssignments", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "buildInfoForRoot", "root", "enterClass", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "enterFunction", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "enterFunctionCall", "lambdaArgs", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "enterLoop", "loop", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "enterScope", "symbol", "evaluatedInPlace", "exitClass", "exitFunction", "exitFunctionCall", "callCompleted", "exitLoop", "getInfoForDeclaration", "isAccessToUnstableLocalVariable", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "targetType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isStableType", "assignments", "reset", "visitAssignment", "property", "type", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,535:1\n1755#2,2:536\n1757#2:541\n1755#2,3:542\n1734#2,3:545\n1611#2,9:549\n1863#2:558\n1864#2:560\n1620#2:561\n1293#2,4:562\n1293#2,4:566\n295#2,2:570\n188#3,3:538\n1#4:548\n1#4:559\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer\n*L\n69#1:536,2\n69#1:541\n80#1:542,3\n83#1:545,3\n186#1:549,9\n186#1:558\n186#1:560\n186#1:561\n186#1:562,4\n207#1:566,4\n232#1:570,2\n73#1:538,3\n186#1:559\n*E\n"})
public final class FirLocalVariableAssignmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FirFunctionSymbol<?> rootFunction;
    @Nullable
    private Map<Object, Companion.Fork> assignedLocalVariablesByDeclaration;
    @Nullable
    private Map<FirProperty, ? extends List<Companion.Assignment>> variableAssignments;
    @NotNull
    private final Stack<Pair<Companion.Fork, Companion.VariableAssignments>> scopes = StackKt.stackOf(new Pair[0]);
    @NotNull
    private final Stack<Map<Companion.Fork, Boolean>> postponedLambdas = StackKt.stackOf(new Map[0]);

    public final void reset() {
        this.rootFunction = null;
        this.assignedLocalVariablesByDeclaration = null;
        this.variableAssignments = null;
        this.postponedLambdas.reset();
        this.scopes.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAccessToUnstableLocalVariable(@NotNull FirElement fir, @Nullable ConeKotlinType targetType, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (this.assignedLocalVariablesByDeclaration == null) {
            return false;
        }
        FirElement firElement = UtilKt.unwrapElement(fir);
        if (!(firElement instanceof FirQualifiedAccessExpression)) return false;
        FirQualifiedAccessExpression firQualifiedAccessExpression = (FirQualifiedAccessExpression)firElement;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression realFir = firQualifiedAccessExpression;
        FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(realFir.getCalleeReference(), false, 1, null);
        Object object = firPropertySymbol;
        if (firPropertySymbol == null) return false;
        if ((object = (FirProperty)((FirBasedSymbol)object).getFir()) == null) {
            return false;
        }
        Object property2 = object;
        if (!this.isStableType((Collection<Companion.Assignment>)((Companion.VariableAssignments)this.scopes.top().getSecond()).get((FirProperty)property2), targetType, session2)) return true;
        Iterable $this$any$iv = this.postponedLambdas.all();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Map lambdas = (Map)element$iv;
            boolean bl2 = false;
            Map $this$any$iv2 = lambdas;
            boolean $i$f$any2 = false;
            if ($this$any$iv2.isEmpty()) {
                bl = false;
                continue;
            }
            Iterator iterator3 = $this$any$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator3.next();
                boolean bl3 = false;
                Companion.Fork lambda = (Companion.Fork)entry.getKey();
                boolean dataFlowOnly = (Boolean)entry.getValue();
                if (dataFlowOnly && lambda.getAssignedInside().contains((FirProperty)property2)) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isStableType(Collection<Companion.Assignment> assignments, ConeKotlinType targetType, FirSession session2) {
        boolean bl;
        block10: {
            Companion.Assignment it;
            boolean bl2;
            block9: {
                if (assignments == null) {
                    return true;
                }
                if (targetType == null) {
                    return false;
                }
                Iterable $this$any$iv = assignments;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Companion.Assignment)element$iv;
                        boolean bl3 = false;
                        if (!(it.getType() == null)) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return false;
            }
            Iterable $this$all$iv = assignments;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (Companion.Assignment)element$iv;
                    boolean bl4 = false;
                    TypeCheckerProviderContext typeCheckerProviderContext = TypeComponentsKt.getTypeContext(session2);
                    ConeKotlinType coneKotlinType = it.getType();
                    Intrinsics.checkNotNull((Object)coneKotlinType);
                    if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerProviderContext, (KotlinTypeMarker)coneKotlinType, (KotlinTypeMarker)targetType, false, 8, null)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final Companion.Fork getInfoForDeclaration(Object symbol2) {
        FirFunctionSymbol<?> firFunctionSymbol = this.rootFunction;
        if (firFunctionSymbol == null) {
            return null;
        }
        FirFunctionSymbol<?> root = firFunctionSymbol;
        if (Intrinsics.areEqual(root, (Object)symbol2)) {
            return null;
        }
        Map<Object, Companion.Fork> cachedMap = this.buildInfoForRoot(root);
        return cachedMap.get(symbol2);
    }

    private final Map<Object, Companion.Fork> buildInfoForRoot(FirFunctionSymbol<?> root) {
        Map<Object, Companion.Fork> map = this.assignedLocalVariablesByDeclaration;
        if (map != null) {
            Map<Object, Companion.Fork> it = map;
            boolean bl = false;
            return it;
        }
        Companion.MiniCfgBuilder.MiniCfgData data2 = new Companion.MiniCfgBuilder.MiniCfgData();
        new Companion.MiniCfgBuilder().visitElement((FirElement)root.getFir(), data2);
        this.assignedLocalVariablesByDeclaration = data2.getForks();
        this.variableAssignments = data2.getAssignments();
        return data2.getForks();
    }

    private final Pair<Companion.Fork, Companion.VariableAssignments> enterScope(Object symbol2, boolean evaluatedInPlace) {
        Companion.Fork currentInfo = this.getInfoForDeclaration(symbol2);
        Companion.VariableAssignments prohibitInThisScope = ((Companion.VariableAssignments)this.scopes.top().getSecond()).copy();
        this.scopes.push((Pair<Companion.Fork, Companion.VariableAssignments>)TuplesKt.to((Object)currentInfo, (Object)prohibitInThisScope));
        if (!evaluatedInPlace) {
            for (Pair<Companion.Fork, Companion.VariableAssignments> pair : this.scopes.all()) {
                Companion.Fork outerInfo = (Companion.Fork)pair.component1();
                Companion.VariableAssignments prohibitInOuterScope = (Companion.VariableAssignments)pair.component2();
                Companion.Fork fork = currentInfo;
                prohibitInOuterScope.merge(fork != null ? fork.getAssignedInside() : null);
                Companion.Fork fork2 = outerInfo;
                prohibitInThisScope.merge(fork2 != null ? fork2.getAssignedLater() : null);
            }
        }
        return this.scopes.top();
    }

    @NotNull
    public final Set<FirPropertySymbol> enterFunction(@NotNull FirFunction function2) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (this.rootFunction == null) {
            this.rootFunction = function2.getSymbol();
            this.scopes.push((Pair<Companion.Fork, Companion.VariableAssignments>)TuplesKt.to(null, (Object)new Companion.VariableAssignments()));
            return SetsKt.emptySet();
        }
        Pair<Companion.Fork, Companion.VariableAssignments> pair = this.enterScope(function2.getSymbol(), function2 instanceof FirAnonymousFunction && EventOccurrencesRangeKt.isInPlace(((FirAnonymousFunction)function2).getInvocationKind()));
        Companion.Fork info = (Companion.Fork)pair.component1();
        Companion.VariableAssignments prohibitSmartCasts = (Companion.VariableAssignments)pair.component2();
        for (Map<Companion.Fork, Boolean> concurrentLambdas : this.postponedLambdas.all()) {
            for (Map.Entry<Companion.Fork, Boolean> entry : concurrentLambdas.entrySet()) {
                Companion.Fork otherLambda = entry.getKey();
                boolean dataFlowOnly = entry.getValue();
                if (dataFlowOnly || Intrinsics.areEqual((Object)otherLambda, (Object)info)) continue;
                prohibitSmartCasts.merge(otherLambda.getAssignedInside());
            }
        }
        Object object = (Companion.Fork)this.scopes.top().getFirst();
        if ((object != null && (object = ((Companion.Fork)object).getAssignedInside()) != null ? ((Companion.VariableAssignments)object).getAssignedProperties() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void exitFunction() {
        this.scopes.pop();
        if (StackKt.isEmpty(this.scopes)) {
            this.rootFunction = null;
            this.assignedLocalVariablesByDeclaration = null;
            this.variableAssignments = null;
        }
    }

    public final void enterClass(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (this.rootFunction == null) {
            return;
        }
        Pair<Companion.Fork, Companion.VariableAssignments> pair = this.enterScope(klass.getSymbol(), klass instanceof FirAnonymousObject);
        Companion.Fork info = (Companion.Fork)pair.component1();
        Companion.VariableAssignments prohibitSmartCasts = (Companion.VariableAssignments)pair.component2();
        if (klass instanceof FirAnonymousObject && info != null) {
            prohibitSmartCasts.merge(info.getAssignedInside());
        }
    }

    public final void exitClass() {
        if (this.rootFunction == null) {
            return;
        }
        this.scopes.pop();
    }

    /*
     * WARNING - void declaration
     */
    public final void enterFunctionCall(@NotNull Collection<? extends FirAnonymousFunction> lambdaArgs) {
        void var3_5;
        void $this$associateWithTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(lambdaArgs, (String)"lambdaArgs");
        if (this.rootFunction == null) {
            return;
        }
        Iterable iterable = lambdaArgs;
        Stack<Map<Companion.Fork, Boolean>> stack = this.postponedLambdas;
        boolean $i$f$mapNotNull22 = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Companion.Fork $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Companion.Fork it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnonymousFunction it = (FirAnonymousFunction)element$iv$iv;
            boolean bl2 = false;
            if (this.getInfoForDeclaration(it.getSymbol()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Map $i$f$mapNotNull22 = new LinkedHashMap();
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            void destination$iv;
            $this$forEach$iv$iv$iv = (Companion.Fork)element$iv;
            Object t = element$iv;
            void var18_21 = destination$iv;
            boolean bl = false;
            Boolean bl4 = false;
            var18_21.put(t, bl4);
        }
        stack.push((Map<Companion.Fork, Boolean>)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final void exitFunctionCall(boolean callCompleted) {
        if (this.rootFunction == null) {
            return;
        }
        Map<Companion.Fork, Boolean> lambdasInCall = this.postponedLambdas.pop();
        if (!callCompleted) {
            void $this$associateWithTo$iv;
            Iterable iterable = lambdasInCall.keySet();
            Map<Companion.Fork, Boolean> map = StackKt.topOrNull(this.postponedLambdas);
            if (map == null) {
                return;
            }
            Map<Companion.Fork, Boolean> destination$iv = map;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                Companion.Fork fork = (Companion.Fork)element$iv;
                Object t = element$iv;
                Map<Companion.Fork, Boolean> map2 = destination$iv;
                boolean bl = false;
                Boolean bl2 = true;
                map2.put((Companion.Fork)t, bl2);
            }
        }
    }

    @NotNull
    public final Set<FirPropertySymbol> enterLoop(@NotNull FirLoop loop2) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        if (this.rootFunction == null) {
            return SetsKt.emptySet();
        }
        Companion.Fork info = (Companion.Fork)this.enterScope(loop2, true).component1();
        Object object = info;
        if ((object != null && (object = ((Companion.Fork)object).getAssignedInside()) != null ? ((Companion.VariableAssignments)object).getAssignedProperties() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<FirPropertySymbol> exitLoop() {
        Set set;
        if (this.rootFunction == null) {
            return SetsKt.emptySet();
        }
        Companion.Fork info = (Companion.Fork)this.scopes.pop().component1();
        Object object = info;
        if ((object != null && (object = ((Companion.Fork)object).getAssignedInside()) != null ? ((Companion.VariableAssignments)object).getAssignedProperties() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void visitAssignment(@NotNull FirProperty property2, @NotNull ConeKotlinType type2) {
        Object v2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            FirFunctionSymbol<?> firFunctionSymbol = this.rootFunction;
            if (firFunctionSymbol == null) {
                return;
            }
            this.buildInfoForRoot(firFunctionSymbol);
            Map<FirProperty, ? extends List<Companion.Assignment>> map = this.variableAssignments;
            if (map == null || (map = map.get(property2)) == null) {
                return;
            }
            Map<FirProperty, ? extends List<Companion.Assignment>> assignments = map;
            Iterable $this$firstOrNull$iv = (Iterable)((Object)assignments);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Companion.Assignment it = (Companion.Assignment)element$iv;
                boolean bl = false;
                if (!(it.getType() == null)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Companion.Assignment assignment = v2;
        if (assignment == null) {
            return;
        }
        Companion.Assignment assignment2 = assignment;
        assignment2.setType(type2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0005\u0003\u0004\u0005\u0006\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion;", "", "()V", "Assignment", "Fork", "MiniCfgBuilder", "MiniFlow", "VariableAssignments", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "", "operatorAssignment", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(ZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "getOperatorAssignment", "()Z", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "setType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "resolve"})
        private static final class Assignment {
            private final boolean operatorAssignment;
            @Nullable
            private ConeKotlinType type;

            public Assignment(boolean operatorAssignment, @Nullable ConeKotlinType type2) {
                this.operatorAssignment = operatorAssignment;
                this.type = type2;
            }

            public /* synthetic */ Assignment(boolean bl, ConeKotlinType coneKotlinType, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    coneKotlinType = null;
                }
                this(bl, coneKotlinType);
            }

            public final boolean getOperatorAssignment() {
                return this.operatorAssignment;
            }

            @Nullable
            public final ConeKotlinType getType() {
                return this.type;
            }

            public final void setType(@Nullable ConeKotlinType coneKotlinType) {
                this.type = coneKotlinType;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "", "assignedLater", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "assignedInside", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;)V", "getAssignedInside", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getAssignedLater", "resolve"})
        private static final class Fork {
            @NotNull
            private final VariableAssignments assignedLater;
            @NotNull
            private final VariableAssignments assignedInside;

            public Fork(@NotNull VariableAssignments assignedLater, @NotNull VariableAssignments assignedInside) {
                Intrinsics.checkNotNullParameter((Object)assignedLater, (String)"assignedLater");
                Intrinsics.checkNotNullParameter((Object)assignedInside, (String)"assignedInside");
                this.assignedLater = assignedLater;
                this.assignedInside = assignedInside;
            }

            @NotNull
            public final VariableAssignments getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final VariableAssignments getAssignedInside() {
                return this.assignedInside;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001DB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0012\u00108\u001a\u000209*\b\u0012\u0004\u0012\u0002090:H\u0002J\u001c\u0010;\u001a\u00020\u0002*\u00020\u00032\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u001c\u0010;\u001a\u00020\u0002*\u0002092\u0006\u0010$\u001a\u00020%2\u0006\u0010@\u001a\u00020AH\u0002J\u0014\u0010B\u001a\u00020\u0002*\u0002092\u0006\u0010C\u001a\u00020\u0019H\u0002\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "()V", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "data", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visitAssignmentOperatorStatement", "assignmentOperatorStatement", "Lorg/jetbrains/kotlin/fir/expressions/FirAssignmentOperatorStatement;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitDoWhileLoop", "doWhileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitElementWithLexicalScope", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitLocalDeclaration", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "visitLoop", "loop", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTryExpression", "tryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "visitVariableAssignment", "variableAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "visitWhenExpression", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "visitWhileLoop", "whileLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "join", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "recordAssignment", "reference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "operatorAssignment", "", "assignment", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "recordAssignments", "properties", "MiniCfgData", "resolve"})
        @SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,535:1\n1454#2,5:536\n1628#2,3:542\n1628#2,3:545\n1863#2,2:548\n3193#2,10:550\n1863#2,2:560\n1863#2,2:562\n543#2,6:564\n1863#2,2:577\n1863#2,2:579\n1#3:541\n381#4,7:570\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder\n*L\n384#1:536,5\n416#1:542,3\n427#1:545,3\n465#1:548,2\n469#1:550,10\n470#1:560,2\n471#1:562,2\n507#1:564,6\n516#1:577,2\n523#1:579,2\n510#1:570,7\n*E\n"})
        private static final class MiniCfgBuilder
        extends FirVisitor<Unit, MiniCfgData> {
            @Override
            public void visitElement(@NotNull FirElement element, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                element.acceptChildren(this, data2);
            }

            /*
             * WARNING - void declaration
             */
            private final VariableAssignments visitElementWithLexicalScope(FirElement element, MiniCfgData data2) {
                void destination$iv;
                void $this$flatMapTo$iv;
                MiniFlow flow = MiniFlow.Companion.start();
                Object object = (Iterable)data2.getVariableDeclarations();
                Collection collection = new LinkedHashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    Map it = (Map)element$iv;
                    boolean bl = false;
                    Iterable list$iv = it.values();
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                Set freeVariables = (Set)destination$iv;
                data2.setFlow(flow);
                element.acceptChildren(this, data2);
                Object $this$visitElementWithLexicalScope_u24lambda_u241 = object = flow.getAssignedLater();
                boolean bl = false;
                ((VariableAssignments)$this$visitElementWithLexicalScope_u24lambda_u241).retain(freeVariables);
                return object;
            }

            @Override
            public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLocalDeclaration(anonymousFunction, data2);
            }

            @Override
            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLocalDeclaration(simpleFunction, data2);
            }

            @Override
            public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLocalDeclaration(regularClass, data2);
            }

            @Override
            public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLocalDeclaration(anonymousObject, data2);
            }

            private final void visitLocalDeclaration(FirDeclaration declaration, MiniCfgData data2) {
                MiniFlow flow = data2.getFlow();
                VariableAssignments assignedInside = this.visitElementWithLexicalScope(declaration, data2);
                this.recordAssignments(flow, assignedInside);
                data2.setFlow(flow.fork());
                data2.getForks().put(declaration.getSymbol(), new Fork(data2.getFlow().getAssignedLater(), assignedInside));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull MiniCfgData data2) {
                void var13_13;
                void destination$iv;
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                FirVariable firVariable = whenExpression.getSubjectVariable();
                FirElement firElement = firVariable != null ? (FirElement)firVariable : (FirElement)whenExpression.getSubject();
                if (firElement != null) {
                    ((FirStatement)firElement).accept(this, data2);
                }
                MiniFlow flow = data2.getFlow();
                Iterable iterable = whenExpression.getBranches();
                Object object = new MiniFlow[]{flow};
                object = SetsKt.mutableSetOf((Object[])object);
                MiniCfgBuilder miniCfgBuilder = this;
                MiniCfgData miniCfgData = data2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirWhenBranch firWhenBranch = (FirWhenBranch)item$iv;
                    var13_13 = destination$iv;
                    boolean bl = false;
                    data2.setFlow(flow);
                    it.accept(this, data2);
                    var13_13.add(data2.getFlow());
                }
                var13_13 = destination$iv;
                miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitTryExpression(@NotNull FirTryExpression tryExpression, @NotNull MiniCfgData data2) {
                block1: {
                    void var13_13;
                    void destination$iv;
                    void $this$mapTo$iv;
                    Intrinsics.checkNotNullParameter((Object)tryExpression, (String)"tryExpression");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    tryExpression.getTryBlock().accept(this, data2);
                    MiniFlow flow = data2.getFlow();
                    Iterable iterable = tryExpression.getCatches();
                    Object object = new MiniFlow[]{flow};
                    object = SetsKt.mutableSetOf((Object[])object);
                    MiniCfgBuilder miniCfgBuilder = this;
                    MiniCfgData miniCfgData = data2;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        FirCatch firCatch = (FirCatch)item$iv;
                        var13_13 = destination$iv;
                        boolean bl = false;
                        data2.setFlow(flow);
                        it.accept(this, data2);
                        var13_13.add(data2.getFlow());
                    }
                    var13_13 = destination$iv;
                    miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
                    FirBlock firBlock = tryExpression.getFinallyBlock();
                    if (firBlock == null) break block1;
                    firBlock.accept(this, data2);
                }
            }

            private final MiniFlow join(Set<MiniFlow> $this$join) {
                MiniFlow miniFlow = (MiniFlow)CollectionsKt.singleOrNull((Iterable)$this$join);
                if (miniFlow == null) {
                    miniFlow = new MiniFlow($this$join);
                }
                return miniFlow;
            }

            @Override
            public void visitLoop(@NotNull FirLoop loop2, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                MiniFlow entry = data2.getFlow();
                VariableAssignments assignedInside = this.visitElementWithLexicalScope(loop2, data2);
                this.recordAssignments(entry, assignedInside);
                this.recordAssignments(data2.getFlow(), assignedInside);
                data2.setFlow(entry.fork());
                data2.getForks().put(loop2, new Fork(data2.getFlow().getAssignedLater(), assignedInside));
            }

            @Override
            public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)whileLoop, (String)"whileLoop");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLoop((FirLoop)whileLoop, data2);
            }

            @Override
            public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)doWhileLoop, (String)"doWhileLoop");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitLoop((FirLoop)doWhileLoop, data2);
            }

            @Override
            public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull MiniCfgData data2) {
                FirExpression it;
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                MiniCfgBuilder visitor2 = this;
                FirFunctionCall $this$visitFunctionCall_u24lambda_u248 = functionCall;
                boolean bl = false;
                FirExpression[] firExpressionArray = new FirExpression[]{$this$visitFunctionCall_u24lambda_u248.getExplicitReceiver(), $this$visitFunctionCall_u24lambda_u248.getDispatchReceiver(), $this$visitFunctionCall_u24lambda_u248.getExtensionReceiver()};
                Iterable $this$forEach$iv = SetsKt.setOfNotNull((Object[])firExpressionArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirExpression it2 = (FirExpression)element$iv;
                    boolean bl2 = false;
                    it2.accept(visitor2, data2);
                }
                Iterable $this$partition$iv = $this$visitFunctionCall_u24lambda_u248.getArgumentList().getArguments();
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    it = (FirExpression)element$iv;
                    boolean bl3 = false;
                    if (it instanceof FirAnonymousFunctionExpression) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                firExpressionArray = new Pair(first$iv, second$iv);
                List postponedFunctionArgs = (List)firExpressionArray.component1();
                List normalArgs = (List)firExpressionArray.component2();
                Iterable $this$forEach$iv2 = normalArgs;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl4 = false;
                    it.accept(visitor2, data2);
                }
                $this$forEach$iv2 = postponedFunctionArgs;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl5 = false;
                    it.accept(visitor2, data2);
                }
                $this$visitFunctionCall_u24lambda_u248.getCalleeReference().accept(visitor2, data2);
            }

            @Override
            public void visitBlock(@NotNull FirBlock block, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                data2.getVariableDeclarations().addLast((Object)new LinkedHashMap());
                this.visitElement((FirElement)block, data2);
                data2.getVariableDeclarations().removeLast();
            }

            @Override
            public void visitProperty(@NotNull FirProperty property2, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitElement((FirElement)property2, data2);
                if (property2.isLocal()) {
                    ((Map)data2.getVariableDeclarations().last()).put(property2.getName(), property2);
                }
            }

            @Override
            public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull MiniCfgData data2) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)variableAssignment, (String)"variableAssignment");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    this.visitElement((FirElement)variableAssignment, data2);
                    if (FirExpressionUtilKt.getExplicitReceiver(variableAssignment) != null) {
                        return;
                    }
                    FirReference firReference = ReferenceUtilsKt.getCalleeReference(variableAssignment);
                    if (firReference == null) break block1;
                    FirReference it = firReference;
                    boolean bl = false;
                    KtSourceElement ktSourceElement = variableAssignment.getSource();
                    boolean operatorAssignment = (ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement;
                    this.recordAssignment(data2, it, operatorAssignment);
                }
            }

            @Override
            public void visitAssignmentOperatorStatement(@NotNull FirAssignmentOperatorStatement assignmentOperatorStatement, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter((Object)assignmentOperatorStatement, (String)"assignmentOperatorStatement");
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.visitElement((FirElement)assignmentOperatorStatement, data2);
                FirExpression firExpression2 = assignmentOperatorStatement.getLeftArgument();
                FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
                if (firQualifiedAccessExpression == null) {
                    return;
                }
                FirQualifiedAccessExpression lhs = firQualifiedAccessExpression;
                if (lhs.getExplicitReceiver() != null) {
                    return;
                }
                this.recordAssignment(data2, lhs.getCalleeReference(), true);
            }

            private final void recordAssignment(MiniCfgData $this$recordAssignment, FirReference reference2, boolean operatorAssignment) {
                List list2;
                Object object;
                Object v1;
                Object name2;
                block5: {
                    Object object2 = reference2 instanceof FirNamedReference ? (FirNamedReference)reference2 : null;
                    if (object2 == null || (object2 = ((FirNamedReference)object2).getName()) == null) {
                        return;
                    }
                    name2 = object2;
                    List $this$lastOrNull$iv = (List)$this$recordAssignment.getVariableDeclarations();
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        Map it = (Map)element$iv;
                        boolean bl = false;
                        if (!it.containsKey(name2)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                if ((object = (Map)v1) == null || (object = (FirProperty)object.get(name2)) == null) {
                    return;
                }
                Object property2 = object;
                Assignment assignment = new Assignment(operatorAssignment, null, 2, null);
                Map<FirProperty, List<Assignment>> $this$getOrPut$iv = $this$recordAssignment.getAssignments();
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(property2);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put((FirProperty)property2, answer$iv);
                    list2 = answer$iv;
                } else {
                    list2 = value$iv;
                }
                list2.add((Assignment)assignment);
                this.recordAssignment($this$recordAssignment.getFlow(), (FirProperty)property2, assignment);
            }

            private final void recordAssignment(MiniFlow $this$recordAssignment, FirProperty property2, Assignment assignment) {
                $this$recordAssignment.getAssignedLater().add(property2, assignment);
                Iterable $this$forEach$iv = $this$recordAssignment.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignment(it, property2, assignment);
                }
            }

            private final void recordAssignments(MiniFlow $this$recordAssignments, VariableAssignments properties2) {
                if (properties2.isEmpty()) {
                    return;
                }
                $this$recordAssignments.getAssignedLater().merge(properties2);
                Iterable $this$forEach$iv = $this$recordAssignments.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignments(it, properties2);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR#\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00050\u00040\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "", "()V", "assignments", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "getAssignments", "()Ljava/util/Map;", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "getFlow", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "setFlow", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;)V", "forks", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "getForks", "variableDeclarations", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/name/Name;", "getVariableDeclarations", "()Lkotlin/collections/ArrayDeque;", "resolve"})
            public static final class MiniCfgData {
                @NotNull
                private MiniFlow flow = MiniFlow.Companion.start();
                @NotNull
                private final ArrayDeque<Map<Name, FirProperty>> variableDeclarations = new ArrayDeque((Collection)CollectionsKt.listOf((Object)new LinkedHashMap()));
                @NotNull
                private final Map<FirProperty, List<Assignment>> assignments = new LinkedHashMap();
                @NotNull
                private final Map<Object, Fork> forks = new LinkedHashMap();

                @NotNull
                public final MiniFlow getFlow() {
                    return this.flow;
                }

                public final void setFlow(@NotNull MiniFlow miniFlow) {
                    Intrinsics.checkNotNullParameter((Object)miniFlow, (String)"<set-?>");
                    this.flow = miniFlow;
                }

                @NotNull
                public final ArrayDeque<Map<Name, FirProperty>> getVariableDeclarations() {
                    return this.variableDeclarations;
                }

                @NotNull
                public final Map<FirProperty, List<Assignment>> getAssignments() {
                    return this.assignments;
                }

                @NotNull
                public final Map<Object, Fork> getForks() {
                    return this.forks;
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "parents", "", "(Ljava/util/Set;)V", "assignedLater", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getAssignedLater", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getParents", "()Ljava/util/Set;", "fork", "Companion", "resolve"})
        private static final class MiniFlow {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Set<MiniFlow> parents;
            @NotNull
            private final VariableAssignments assignedLater;

            public MiniFlow(@NotNull Set<MiniFlow> parents2) {
                Intrinsics.checkNotNullParameter(parents2, (String)"parents");
                this.parents = parents2;
                this.assignedLater = new VariableAssignments();
            }

            @NotNull
            public final Set<MiniFlow> getParents() {
                return this.parents;
            }

            @NotNull
            public final VariableAssignments getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final MiniFlow fork() {
                return new MiniFlow(SetsKt.setOf((Object)this));
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow$Companion;", "", "()V", "start", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "resolve"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final MiniFlow start() {
                    return new MiniFlow(SetsKt.emptySet());
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u000e\u001a\u00020\u0000J\u0019\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010J\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0000J\u0014\u0010\u0016\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "", "()V", "assignments", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "add", "", "property", "assignment", "contains", "", "copy", "get", "", "getAssignedProperties", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "isEmpty", "merge", "other", "retain", "properties", "resolve"})
        @SourceDebugExtension(value={"SMAP\nFirLocalVariableAssignmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,535:1\n381#2,7:536\n381#2,7:543\n774#3:550\n865#3:551\n1755#3,3:552\n866#3:555\n1628#3,3:556\n*S KotlinDebug\n*F\n+ 1 FirLocalVariableAssignmentAnalyzer.kt\norg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments\n*L\n336#1:536,7\n348#1:543,7\n361#1:550\n361#1:551\n361#1:552,3\n361#1:555\n362#1:556,3\n*E\n"})
        private static final class VariableAssignments {
            @NotNull
            private final Map<FirProperty, Set<Assignment>> assignments = new LinkedHashMap();

            @Nullable
            public final Set<Assignment> get(@NotNull FirProperty property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                return this.assignments.get(property2);
            }

            public final boolean contains(@NotNull FirProperty property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                return this.assignments.containsKey(property2);
            }

            public final void add(@NotNull FirProperty property2, @NotNull Assignment assignment) {
                Set set;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
                Map<FirProperty, Set<Assignment>> $this$getOrPut$iv = this.assignments;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(property2);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(property2, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                set.add((Assignment)assignment);
            }

            @NotNull
            public final VariableAssignments copy() {
                VariableAssignments copy2 = new VariableAssignments();
                copy2.assignments.putAll(this.assignments);
                return copy2;
            }

            public final void merge(@Nullable VariableAssignments other) {
                if (other == null) {
                    return;
                }
                for (Map.Entry<FirProperty, Set<Assignment>> entry : other.assignments.entrySet()) {
                    Set set;
                    FirProperty property2 = entry.getKey();
                    Set<Assignment> values2 = entry.getValue();
                    Map<FirProperty, Set<Assignment>> $this$getOrPut$iv = this.assignments;
                    boolean $i$f$getOrPut = false;
                    Set value$iv = $this$getOrPut$iv.get(property2);
                    if (value$iv == null) {
                        boolean bl = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(property2, answer$iv);
                        set = answer$iv;
                    } else {
                        set = value$iv;
                    }
                    set.addAll((Collection<Assignment>)values2);
                }
            }

            public final void retain(@NotNull Set<? extends FirProperty> properties2) {
                Intrinsics.checkNotNullParameter(properties2, (String)"properties");
                this.assignments.keySet().retainAll((Collection)properties2);
            }

            public final boolean isEmpty() {
                return this.assignments.isEmpty();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<FirPropertySymbol> getAssignedProperties() {
                void var2_3;
                void $this$mapTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.assignments.entrySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block5: {
                        Map.Entry entry = (Map.Entry)element$iv$iv;
                        boolean bl2 = false;
                        Set v = (Set)entry.getValue();
                        Iterable $this$any$iv = v;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Assignment it = (Assignment)element$iv;
                                boolean bl3 = false;
                                if (!(!it.getOperatorAssignment())) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Collection destination$iv = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    Map.Entry entry = (Map.Entry)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    FirProperty k = (FirProperty)entry.getKey();
                    collection.add(k.getSymbol());
                }
                return (Set)var2_3;
            }
        }
    }
}

