/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeType;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.RangeCheckTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005\u001a \u0010\f\u001a\u00020\r2\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a(\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a8\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\n\u0012\u0006\b\u0001\u0012\u00020\u00130\tH\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\n\u0012\u0006\b\u0001\u0012\u00020\u00130\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"intRangeToFqName", "Lorg/jetbrains/kotlin/name/FqName;", "longRangeToFqName", "untilFqName", "computeExplicitReceiversForInvoke", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "explicitReceivers", "mayBeMarkByRangeMetadata", "", "callExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "translateCall", "translateFunctionCall", "inlineResolvedCall", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "expectedReceivers", "", "getReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCallTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallTranslator.kt\norg/jetbrains/kotlin/js/translate/callTranslator/CallTranslatorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1#2:274\n*E\n"})
public final class CallTranslatorKt {
    @NotNull
    private static final FqName intRangeToFqName = new FqName("kotlin.Int.rangeTo");
    @NotNull
    private static final FqName longRangeToFqName = new FqName("kotlin.Long.rangeTo");
    @NotNull
    private static final FqName untilFqName = new FqName("kotlin.ranges.until");

    private static final boolean expectedReceivers(ResolvedCall<? extends CallableDescriptor> $this$expectedReceivers) {
        return $this$expectedReceivers.getExplicitReceiverKind() != ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
    }

    private static final JsExpression translateCall(TranslationContext context2, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ExplicitReceivers explicitReceivers) {
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            ExplicitReceivers explicitReceivers2;
            ResolvedCall<CallableDescriptor> inlineCall2;
            boolean bl;
            boolean bl2 = bl = explicitReceivers.getExtensionReceiver() == null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-CallTranslatorKt$translateCall$22 = false;
                String $i$a$-assert-CallTranslatorKt$translateCall$22 = "VariableAsFunctionResolvedCall must have one receiver";
                throw new AssertionError((Object)$i$a$-assert-CallTranslatorKt$translateCall$22);
            }
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
            KotlinType $this$translateCall_u24lambda_u241 = variableCall.getResultingDescriptor().getType();
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)$this$translateCall_u24lambda_u241);
            boolean isFunctionType = FunctionTypesKt.isFunctionTypeOrSubtype($this$translateCall_u24lambda_u241) || FunctionTypesKt.isSuspendFunctionTypeOrSubtype($this$translateCall_u24lambda_u241);
            ResolvedCall<CallableDescriptor> resolvedCall3 = inlineCall2 = isFunctionType ? variableCall : resolvedCall2;
            if (CallTranslatorKt.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE.translateGet(context2, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                explicitReceivers2 = new ExplicitReceivers(newReceiver, null, 2, null);
            } else {
                JsExpression dispatchReceiver = CallTranslator.INSTANCE.translateGet(context2, variableCall, null);
                explicitReceivers2 = explicitReceivers.getExtensionOrDispatchReceiver() == null ? new ExplicitReceivers(dispatchReceiver, null, 2, null) : new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver());
            }
            ExplicitReceivers newExplicitReceivers = explicitReceivers2;
            return CallTranslatorKt.translateFunctionCall(context2, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), inlineCall2, newExplicitReceivers);
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        Call call3 = call2;
        if (call3.getCallType() == Call.CallType.INVOKE && !CallResolverUtilKt.isInvokeCallOnVariable(call3)) {
            ExplicitReceivers explicitReceiversForInvoke = CallTranslatorKt.computeExplicitReceiversForInvoke(context2, resolvedCall2, explicitReceivers);
            return CallTranslatorKt.translateFunctionCall(context2, resolvedCall2, resolvedCall2, explicitReceiversForInvoke);
        }
        return CallTranslatorKt.translateFunctionCall(context2, resolvedCall2, resolvedCall2, explicitReceivers);
    }

    /*
     * WARNING - void declaration
     */
    private static final JsExpression translateFunctionCall(TranslationContext context2, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ResolvedCall<? extends CallableDescriptor> inlineResolvedCall, ExplicitReceivers explicitReceivers) {
        void it;
        JsExpression rangeCheck;
        JsExpression jsExpression = rangeCheck = new RangeCheckTranslator(context2).translateAsRangeCheck(resolvedCall2, explicitReceivers);
        if (jsExpression != null) {
            return jsExpression;
        }
        FunctionCallInfo callInfo = CallInfoKt.getCallInfo(context2, resolvedCall2, explicitReceivers);
        JsExpression callExpression = FunctionCallCasesKt.translateFunctionCall(callInfo);
        if (CallExpressionTranslator.shouldBeInlined(inlineResolvedCall.getResultingDescriptor(), context2)) {
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
            InlineUtils.setInlineCallMetadata(callExpression, ktElement, inlineResolvedCall.getResultingDescriptor(), context2);
        }
        if (resolvedCall2.getResultingDescriptor().isSuspend()) {
            void $this$translateFunctionCall_u24lambda_u242;
            JsExpression jsExpression2;
            JsExpression jsExpression3 = jsExpression2 = callExpression;
            FunctionCallInfo functionCallInfo = callInfo;
            boolean bl = false;
            MetadataProperties.setSuspend((JsExpression)$this$translateFunctionCall_u24lambda_u242, true);
            $this$translateFunctionCall_u24lambda_u242.setSource(resolvedCall2.getCall().getCallElement());
            JsStatement jsStatement = JsAstUtils.asSyntheticStatement(jsExpression2);
            Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"asSyntheticStatement(...)");
            JsStatement statement2 = functionCallInfo.constructSuspendSafeCallIfNeeded(jsStatement);
            List<JsStatement> list2 = context2.getCurrentBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
            ((Collection)list2).add(statement2);
            return UtilsKt.createCoroutineResult(context2, resolvedCall2);
        }
        callExpression = callInfo.constructSafeCallIfNeeded(callExpression);
        KotlinType kotlinType = CallTranslatorKt.getReturnType(resolvedCall2);
        JsExpression jsExpression4 = callExpression;
        boolean bl = false;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        MetadataProperties.setType(jsExpression4, (KotlinType)(CallUtilKt.isSafeCall(call2) ? TypeUtilsKt.makeNullable((KotlinType)it) : it));
        CallTranslatorKt.mayBeMarkByRangeMetadata(resolvedCall2, callExpression);
        return callExpression;
    }

    private static final void mayBeMarkByRangeMetadata(ResolvedCall<? extends FunctionDescriptor> resolvedCall2, JsExpression callExpression) {
        FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(resolvedCall2.getResultingDescriptor());
        if (Intrinsics.areEqual((Object)fqName2, (Object)intRangeToFqName)) {
            MetadataProperties.setRange(callExpression, (Pair<? extends RangeType, ? extends RangeKind>)new Pair((Object)RangeType.INT, (Object)RangeKind.RANGE_TO));
        } else if (Intrinsics.areEqual((Object)fqName2, (Object)longRangeToFqName)) {
            MetadataProperties.setRange(callExpression, (Pair<? extends RangeType, ? extends RangeKind>)new Pair((Object)RangeType.LONG, (Object)RangeKind.RANGE_TO));
        } else if (Intrinsics.areEqual((Object)fqName2, (Object)untilFqName)) {
            FqNameUnsafe fqNameUnsafe;
            Object object = resolvedCall2.getResultingDescriptor().getReturnType();
            FqNameUnsafe fqNameUnsafe2 = object != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)object) : (fqNameUnsafe = null);
            if (Intrinsics.areEqual(fqNameUnsafe, (Object)StandardNames.FqNames.intRange)) {
                MetadataProperties.setRange(callExpression, (Pair<? extends RangeType, ? extends RangeKind>)new Pair((Object)RangeType.INT, (Object)RangeKind.UNTIL));
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames.longRange)) {
                MetadataProperties.setRange(callExpression, (Pair<? extends RangeType, ? extends RangeKind>)new Pair((Object)RangeType.LONG, (Object)RangeKind.UNTIL));
            }
        }
    }

    @NotNull
    public static final KotlinType getReturnType(@NotNull ResolvedCall<? extends CallableDescriptor> $this$getReturnType) {
        Intrinsics.checkNotNullParameter($this$getReturnType, (String)"<this>");
        KotlinType kotlinType = TranslationUtils.getReturnTypeForCoercion($this$getReturnType.getResultingDescriptor());
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getReturnTypeForCoercion(...)");
        return kotlinType;
    }

    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@NotNull TranslationContext context2, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)explicitReceivers, (String)"explicitReceivers");
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        KtElement callElement = ktElement;
        boolean bl2 = bl = explicitReceivers.getExtensionReceiver() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$42 = false;
            String $i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$42 = "'Invoke' call must have one receiver: " + callElement;
            throw new AssertionError((Object)$i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$42);
        }
        ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
        ReceiverValue extensionReceiver = resolvedCall2.getExtensionReceiver();
        if (dispatchReceiver != null && extensionReceiver != null && resolvedCall2.getExplicitReceiverKind() == ExplicitReceiverKind.BOTH_RECEIVERS) {
            boolean bl3;
            boolean bl4 = bl3 = explicitReceivers.getExtensionOrDispatchReceiver() != null;
            if (_Assertions.ENABLED && !bl3) {
                boolean $i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$52 = false;
                String $i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$52 = "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement + ", text: " + callElement.getText() + "Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver;
                throw new AssertionError((Object)$i$a$-assert-CallTranslatorKt$computeExplicitReceiversForInvoke$52);
            }
        } else {
            boolean bl5;
            boolean bl6 = bl5 = explicitReceivers.getExtensionOrDispatchReceiver() == null;
            if (_Assertions.ENABLED && !bl5) {
                boolean bl7 = false;
                String string2 = "Non trivial explicit receiver " + explicitReceivers.getExtensionOrDispatchReceiver() + "\nfor 'invoke' resolved call: " + callElement + ", text: " + callElement.getText() + "\nDispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver;
                throw new AssertionError((Object)string2);
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                explicitReceivers2 = new ExplicitReceivers(null, null, 2, null);
                break;
            }
            case 2: {
                explicitReceivers2 = new ExplicitReceivers(CallTranslatorKt.computeExplicitReceiversForInvoke$translateReceiverAsExpression(context2, dispatchReceiver), null, 2, null);
                break;
            }
            case 3: {
                explicitReceivers2 = new ExplicitReceivers(CallTranslatorKt.computeExplicitReceiversForInvoke$translateReceiverAsExpression(context2, extensionReceiver), null, 2, null);
                break;
            }
            case 4: {
                explicitReceivers2 = new ExplicitReceivers(CallTranslatorKt.computeExplicitReceiversForInvoke$translateReceiverAsExpression(context2, dispatchReceiver), CallTranslatorKt.computeExplicitReceiversForInvoke$translateReceiverAsExpression(context2, extensionReceiver));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return explicitReceivers2;
    }

    private static final JsExpression computeExplicitReceiversForInvoke$translateReceiverAsExpression(TranslationContext $context, ReceiverValue receiver) {
        JsExpression jsExpression;
        ExpressionReceiver expressionReceiver = receiver instanceof ExpressionReceiver ? (ExpressionReceiver)receiver : null;
        if (expressionReceiver != null) {
            ExpressionReceiver it = expressionReceiver;
            boolean bl = false;
            jsExpression = Translation.translateAsExpression(it.getExpression(), $context);
        } else {
            jsExpression = null;
        }
        return jsExpression;
    }

    public static final /* synthetic */ JsExpression access$translateCall(TranslationContext context2, ResolvedCall resolvedCall2, ExplicitReceivers explicitReceivers) {
        return CallTranslatorKt.translateCall(context2, resolvedCall2, explicitReceivers);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            try {
                nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

