/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UnsupportedUntilRangeDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class UnsupportedUntilRangeDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final UnsupportedUntilRangeDeclarationChecker INSTANCE = new UnsupportedUntilRangeDeclarationChecker();

    private UnsupportedUntilRangeDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean isRangeUntilOperatorSupported = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.RangeUntilOperator);
        if (!isRangeUntilOperatorSupported && descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isOperator() && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName(), (Object)OperatorNameConventions.RANGE_UNTIL)) {
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.OPERATOR_KEYWORD)) == null) {
                return;
            }
            KtModifierList operatorKeyword = ktModifierList;
            context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)operatorKeyword, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.RangeUntilOperator), (Object)context2.getLanguageVersionSettings())));
        }
    }
}

