/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.Objects;
import org.jline.style.InterpolationHelper;
import org.jline.style.NopStyleSource;
import org.jline.style.StyleResolver;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class StyleExpression {
    private final StyleResolver resolver;

    public StyleExpression() {
        this(new StyleResolver(new NopStyleSource(), ""));
    }

    public StyleExpression(StyleResolver resolver2) {
        this.resolver = Objects.requireNonNull(resolver2);
    }

    public void evaluate(AttributedStringBuilder buff, String expression2) {
        Objects.requireNonNull(buff);
        Objects.requireNonNull(expression2);
        String translated = InterpolationHelper.substVars(expression2, this::style, false);
        buff.appendAnsi(translated);
    }

    private String style(String key) {
        int idx = key.indexOf(32);
        if (idx > 0) {
            String spec = key.substring(0, idx);
            String value2 = key.substring(idx + 1);
            AttributedStyle style = this.resolver.resolve(spec);
            return new AttributedStringBuilder().style(style).ansiAppend(value2).toAnsi();
        }
        return null;
    }

    public AttributedString evaluate(String expression2) {
        AttributedStringBuilder buff = new AttributedStringBuilder();
        this.evaluate(buff, expression2);
        return buff.toAttributedString();
    }
}

