/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCNameUtilities;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "validChars", "", "", "validFirstChars", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkObjCName", "objCName", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameUtilities$ObjCName;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n40#2:87\n1863#3,2:88\n1#4:90\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCNameChecker\n*L\n42#1:87\n47#1:88,2\n*E\n"})
public final class FirNativeObjCNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeObjCNameChecker INSTANCE = new FirNativeObjCNameChecker();
    @NotNull
    private static final Set<Character> validFirstChars = SetsKt.plus((Set)SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('a', 'z')))), (Object)Character.valueOf('_'));
    @NotNull
    private static final Set<Character> validChars = SetsKt.plus(validFirstChars, (Iterable)CollectionsKt.toSet((Iterable)((Iterable)new CharRange('0', '9'))));

    private FirNativeObjCNameChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (declaration instanceof FirValueParameter) {
            return;
        }
        List objCNames = CollectionsKt.filterNotNull((Iterable)FirNativeObjCNameUtilities.INSTANCE.getObjCNames(declaration.getSymbol(), context2.getSession()));
        if (objCNames.isEmpty()) {
            return;
        }
        if (declaration instanceof FirCallableDeclaration) {
            FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                for (FirNativeObjCNameUtilities.ObjCName objCName : objCNames) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)objCName.getAnnotation().getSource(), FirNativeErrors.INSTANCE.getINAPPLICABLE_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
        Iterable $this$forEach$iv = objCNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirNativeObjCNameUtilities.ObjCName it = (FirNativeObjCNameUtilities.ObjCName)element$iv;
            boolean bl = false;
            INSTANCE.checkObjCName(it, declaration, context2, reporter2);
        }
    }

    private final void checkObjCName(FirNativeObjCNameUtilities.ObjCName objCName, FirDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter2) {
        Object invalidSwiftNameChars;
        Set invalidChars;
        Object object;
        Object invalidNameChars;
        Object object2;
        Set invalidFirstChars;
        KtSourceElement annotationSource;
        block16: {
            block15: {
                Object object3;
                Object object4;
                Object[] invalidNameFirstChar;
                Object object5;
                Object object6;
                Object[] objectArray;
                Object[] objectArray2;
                annotationSource = objCName.getAnnotation().getSource();
                Iterator<Map.Entry<Name, FirExpression>> iterator2 = objCName.getAnnotation().getArgumentMapping().getMapping().entrySet().iterator();
                while (iterator2.hasNext()) {
                    FirExpression argument2 = iterator2.next().getValue();
                    if (argument2 instanceof FirLiteralExpression) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)argument2.getSource(), FirNativeErrors.INSTANCE.getNON_LITERAL_OBJC_NAME_ARG(), (DiagnosticContext)context2, null, 8, null);
                }
                if (objCName.getName() == null && objCName.getSwiftName() == null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
                }
                if ((objectArray2 = objCName.getName()) != null && (objectArray2 = StringsKt.firstOrNull((CharSequence)((CharSequence)objectArray2))) != null) {
                    objectArray = objectArray2;
                    object6 = validFirstChars;
                    char p0 = objectArray.charValue();
                    boolean bl = false;
                    object5 = !object6.contains(Character.valueOf(p0)) ? objectArray : null;
                } else {
                    object5 = invalidNameFirstChar = null;
                }
                if ((object4 = objCName.getSwiftName()) != null && (object4 = StringsKt.firstOrNull((CharSequence)((CharSequence)object4))) != null) {
                    object6 = object4;
                    Set<Character> p0 = validFirstChars;
                    char p02 = ((Character)object6).charValue();
                    boolean bl = false;
                    object3 = !p0.contains(Character.valueOf(p02)) ? object6 : null;
                } else {
                    object3 = null;
                }
                Object invalidSwiftNameFirstChar = object3;
                objectArray = new Character[]{invalidNameFirstChar, invalidSwiftNameFirstChar};
                invalidFirstChars = SetsKt.setOfNotNull((Object[])objectArray);
                if (!((Collection)invalidFirstChars).isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME_FIRST_CHAR(), (Object)CollectionsKt.joinToString$default((Iterable)invalidFirstChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (DiagnosticContext)context2, null, 16, null);
                }
                String string2 = objCName.getName();
                if (string2 != null ? ((CharSequence)string2).length() == 0 : false) break block15;
                String string3 = objCName.getSwiftName();
                boolean bl = string3 != null ? ((CharSequence)string3).length() == 0 : false;
                if (!bl) break block16;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getEMPTY_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
        if ((object2 = objCName.getName()) == null || (object2 = StringsKt.toSet((CharSequence)((CharSequence)object2))) == null || (object2 = CollectionsKt.subtract((Iterable)((Iterable)object2), (Iterable)validChars)) == null) {
            object2 = invalidNameChars = SetsKt.emptySet();
        }
        if ((object = objCName.getSwiftName()) == null || (object = StringsKt.toSet((CharSequence)((CharSequence)object))) == null || (object = CollectionsKt.subtract((Iterable)((Iterable)object), (Iterable)validChars)) == null) {
            object = SetsKt.emptySet();
        }
        if (!((Collection)(invalidChars = SetsKt.plus((Set)invalidNameChars, (Iterable)((Iterable)(invalidSwiftNameChars = object))))).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINVALID_OBJC_NAME_CHARS(), (Object)CollectionsKt.joinToString$default((Iterable)invalidFirstChars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (DiagnosticContext)context2, null, 16, null);
        }
        if (objCName.getExact() && (!(declaration instanceof FirClass) || ((FirClass)declaration).getClassKind() == ClassKind.ENUM_ENTRY)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getINAPPLICABLE_EXACT_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
        if (objCName.getExact() && objCName.getName() == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirNativeErrors.INSTANCE.getMISSING_EXACT_OBJC_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

