/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.inline.clean.BoxingUnboxingElimination;
import org.jetbrains.kotlin.js.inline.clean.CoroutineStateElimination;
import org.jetbrains.kotlin.js.inline.clean.DeadCodeElimination;
import org.jetbrains.kotlin.js.inline.clean.DoWhileGuardElimination;
import org.jetbrains.kotlin.js.inline.clean.EmptyStatementElimination;
import org.jetbrains.kotlin.js.inline.clean.IfStatementReduction;
import org.jetbrains.kotlin.js.inline.clean.MoveTemporaryVariableDeclarationToAssignment;
import org.jetbrains.kotlin.js.inline.clean.RedundantCallElimination;
import org.jetbrains.kotlin.js.inline.clean.RedundantLabelRemoval;
import org.jetbrains.kotlin.js.inline.clean.RedundantStatementElimination;
import org.jetbrains.kotlin.js.inline.clean.RedundantVariableDeclarationElimination;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination;
import org.jetbrains.kotlin.js.inline.clean.VoidPropertiesElimination;
import org.jetbrains.kotlin.js.inline.clean.WhileConditionFolding;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/FunctionPostProcessor;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "voidName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Lorg/jetbrains/kotlin/js/backend/ast/JsName;)V", "optimizations", "", "Lkotlin/Function0;", "", "getOptimizations", "()Ljava/util/List;", "getRoot", "()Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "apply", "", "js.translator"})
public final class FunctionPostProcessor {
    @NotNull
    private final JsFunction root;
    @Nullable
    private final JsName voidName;
    @NotNull
    private final List<Function0<Boolean>> optimizations;

    public FunctionPostProcessor(@NotNull JsFunction root, @Nullable JsName voidName) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.voidName = voidName;
        Object[] objectArray = new Function0[]{new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new RedundantLabelRemoval(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new EmptyStatementElimination(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new WhileConditionFolding(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new DoWhileGuardElimination(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                return new TemporaryVariableElimination(this.this$0.getRoot()).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new RedundantCallElimination(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new IfStatementReduction(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new DeadCodeElimination(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new RedundantVariableDeclarationElimination(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                return new RedundantStatementElimination(this.this$0.getRoot()).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new CoroutineStateElimination(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new BoxingUnboxingElimination(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                JsBlock jsBlock = this.this$0.getRoot().getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                return new MoveTemporaryVariableDeclarationToAssignment(jsBlock).apply();
            }
        }, new Function0<Boolean>(this){
            final /* synthetic */ FunctionPostProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                boolean bl;
                JsName jsName = FunctionPostProcessor.access$getVoidName$p(this.this$0);
                if (jsName != null) {
                    JsName jsName2 = jsName;
                    FunctionPostProcessor functionPostProcessor = this.this$0;
                    JsName it = jsName2;
                    boolean bl2 = false;
                    JsBlock jsBlock = functionPostProcessor.getRoot().getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
                    bl = new VoidPropertiesElimination(jsBlock, FunctionPostProcessor.access$getVoidName$p(functionPostProcessor)).apply();
                } else {
                    bl = false;
                }
                return bl;
            }
        }};
        this.optimizations = CollectionsKt.listOf((Object[])objectArray);
    }

    public /* synthetic */ FunctionPostProcessor(JsFunction jsFunction, JsName jsName, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jsName = null;
        }
        this(jsFunction, jsName);
    }

    @NotNull
    public final JsFunction getRoot() {
        return this.root;
    }

    @NotNull
    public final List<Function0<Boolean>> getOptimizations() {
        return this.optimizations;
    }

    public final void apply() {
        boolean hasChanges;
        do {
            hasChanges = false;
            for (Function0<Boolean> opt : this.optimizations) {
                hasChanges |= ((Boolean)opt.invoke()).booleanValue();
            }
        } while (hasChanges);
    }

    public static final /* synthetic */ JsName access$getVoidName$p(FunctionPostProcessor $this) {
        return $this.voidName;
    }
}

