/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.Objects;
import org.jline.style.StyleExpression;
import org.jline.style.StyleResolver;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class StyleFactory {
    private final StyleResolver resolver;

    public StyleFactory(StyleResolver resolver2) {
        this.resolver = Objects.requireNonNull(resolver2);
    }

    public AttributedString style(String style, String value2) {
        Objects.requireNonNull(value2);
        AttributedStyle astyle = this.resolver.resolve(style);
        return new AttributedString(value2, astyle);
    }

    public AttributedString style(String style, String format, Object ... params) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(params);
        return this.style(style, String.format(format, params));
    }

    public AttributedString evaluate(String expression2) {
        Objects.requireNonNull(expression2);
        return new StyleExpression(this.resolver).evaluate(expression2);
    }

    public AttributedString evaluate(String format, Object ... params) {
        Objects.requireNonNull(format);
        Objects.requireNonNull(params);
        return this.evaluate(String.format(format, params));
    }
}

