/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.modules;

import com.intellij.util.SmartList;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.modules.DelegatedSaxHandler;
import org.jetbrains.kotlin.cli.common.modules.ModuleBuilder;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleXmlParser {
    public static final String MODULES = "modules";
    public static final String MODULE = "module";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String TYPE_PRODUCTION = "java-production";
    public static final String TYPE_TEST = "java-test";
    public static final String OUTPUT_DIR = "outputDir";
    public static final String FRIEND_DIR = "friendDir";
    public static final String SOURCES = "sources";
    public static final String COMMON_SOURCES = "commonSources";
    public static final String JAVA_SOURCE_ROOTS = "javaSourceRoots";
    public static final String JAVA_SOURCE_PACKAGE_PREFIX = "packagePrefix";
    public static final String PATH = "path";
    public static final String CLASSPATH = "classpath";
    public static final String MODULAR_JDK_ROOT = "modularJdkRoot";
    private final MessageCollector messageCollector;
    private final List<Module> modules;
    private DefaultHandler currentState;
    private final DefaultHandler initial;
    private final DefaultHandler insideModules;

    /*
     * Loose catch block
     */
    @NotNull
    public static ModuleChunk parseModuleScript(@NotNull String xmlFile, @NotNull MessageCollector messageCollector2) {
        ModuleChunk moduleChunk;
        Throwable throwable;
        FileInputStream stream;
        block22: {
            block23: {
                if (xmlFile == null) {
                    ModuleXmlParser.$$$reportNull$$$1(0);
                }
                if (messageCollector2 == null) {
                    ModuleXmlParser.$$$reportNull$$$1(1);
                }
                if (xmlFile == null) {
                    ModuleXmlParser.$$$reportNull$$$0(0);
                }
                if (messageCollector2 == null) {
                    ModuleXmlParser.$$$reportNull$$$0(1);
                }
                stream = new FileInputStream(xmlFile);
                throwable = null;
                moduleChunk = new ModuleXmlParser(messageCollector2).parse(new BufferedInputStream(stream));
                if (stream == null) break block22;
                if (throwable == null) break block23;
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block22;
            }
            stream.close();
        }
        ModuleChunk moduleChunk2 = moduleChunk;
        if (moduleChunk2 == null) {
            ModuleXmlParser.$$$reportNull$$$0(2);
        }
        if (moduleChunk2 == null) {
            ModuleXmlParser.$$$reportNull$$$1(2);
        }
        return moduleChunk2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                stream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    MessageCollectorUtil.reportException(messageCollector2, e);
                    ModuleChunk moduleChunk3 = ModuleChunk.EMPTY;
                    if (moduleChunk3 == null) {
                        ModuleXmlParser.$$$reportNull$$$0(3);
                    }
                    if (moduleChunk3 == null) {
                        ModuleXmlParser.$$$reportNull$$$1(3);
                    }
                    return moduleChunk3;
                }
            }
        }
    }

    private ModuleXmlParser(@NotNull MessageCollector messageCollector2) {
        if (messageCollector2 == null) {
            ModuleXmlParser.$$$reportNull$$$1(4);
        }
        if (messageCollector2 == null) {
            ModuleXmlParser.$$$reportNull$$$0(4);
        }
        this.modules = new SmartList();
        this.initial = new DefaultHandler(){

            @Override
            public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
                if (uri == null) {
                    2.$$$reportNull$$$1(0);
                }
                if (localName == null) {
                    2.$$$reportNull$$$1(1);
                }
                if (qName == null) {
                    2.$$$reportNull$$$1(2);
                }
                if (attributes == null) {
                    2.$$$reportNull$$$1(3);
                }
                if (uri == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (localName == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (qName == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (attributes == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (!ModuleXmlParser.MODULES.equalsIgnoreCase(qName)) {
                    throw ModuleXmlParser.createError(qName);
                }
                ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "uri";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "localName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "qName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$2";
                objectArray[2] = "startElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "uri";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "localName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "qName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$2";
                objectArray[2] = "startElement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.insideModules = new DefaultHandler(){

            @Override
            public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
                if (uri == null) {
                    3.$$$reportNull$$$1(0);
                }
                if (localName == null) {
                    3.$$$reportNull$$$1(1);
                }
                if (qName == null) {
                    3.$$$reportNull$$$1(2);
                }
                if (attributes == null) {
                    3.$$$reportNull$$$1(3);
                }
                if (uri == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (localName == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (qName == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (attributes == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (!ModuleXmlParser.MODULE.equalsIgnoreCase(qName)) {
                    throw ModuleXmlParser.createError(qName);
                }
                String moduleType = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.TYPE, qName);
                assert (ModuleXmlParser.TYPE_PRODUCTION.equals(moduleType) || ModuleXmlParser.TYPE_TEST.equals(moduleType)) : "Unknown module type: " + moduleType;
                ModuleXmlParser.this.setCurrentState(new InsideModule(ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.NAME, qName), ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.OUTPUT_DIR, qName), moduleType));
            }

            @Override
            public void endElement(String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
                if (localName == null) {
                    3.$$$reportNull$$$1(4);
                }
                if (qName == null) {
                    3.$$$reportNull$$$1(5);
                }
                if (localName == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (qName == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (ModuleXmlParser.MODULE.equalsIgnoreCase(qName) || ModuleXmlParser.MODULES.equalsIgnoreCase(qName)) {
                    ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "uri";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localName";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributes";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startElement";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "endElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "uri";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localName";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributes";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startElement";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "endElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.messageCollector = messageCollector2;
    }

    private void setCurrentState(@NotNull DefaultHandler currentState) {
        if (currentState == null) {
            ModuleXmlParser.$$$reportNull$$$1(5);
        }
        if (currentState == null) {
            ModuleXmlParser.$$$reportNull$$$0(5);
        }
        this.currentState = currentState;
    }

    private ModuleChunk parse(@NotNull InputStream xml) {
        if (xml == null) {
            ModuleXmlParser.$$$reportNull$$$1(6);
        }
        if (xml == null) {
            ModuleXmlParser.$$$reportNull$$$0(6);
        }
        try {
            this.setCurrentState(this.initial);
            SAXParserFactory factory2 = SAXParserFactory.newInstance();
            factory2.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory2.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory2.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory2.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser saxParser = factory2.newSAXParser();
            saxParser.parse(xml, (DefaultHandler)new DelegatedSaxHandler(){

                @Override
                @NotNull
                protected DefaultHandler getDelegate() {
                    DefaultHandler defaultHandler = ModuleXmlParser.this.currentState;
                    if (defaultHandler == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (defaultHandler == null) {
                        1.$$$reportNull$$$1(0);
                    }
                    return defaultHandler;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$1", "getDelegate"));
                }

                private static /* synthetic */ void $$$reportNull$$$1(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$1", "getDelegate"));
                }
            });
            return new ModuleChunk(this.modules);
        }
        catch (IOException | ParserConfigurationException e) {
            MessageCollectorUtil.reportException(this.messageCollector, e);
        }
        catch (SAXException e) {
            this.messageCollector.report(CompilerMessageSeverity.ERROR, "Build file does not have a valid XML: " + e, null);
        }
        return ModuleChunk.EMPTY;
    }

    @NotNull
    private static String getAttribute(Attributes attributes, String qName, String tag) throws SAXException {
        String name2 = attributes.getValue(qName);
        if (name2 == null) {
            throw new SAXException("No '" + qName + "' attribute for " + tag);
        }
        String string2 = name2;
        if (string2 == null) {
            ModuleXmlParser.$$$reportNull$$$0(7);
        }
        if (string2 == null) {
            ModuleXmlParser.$$$reportNull$$$1(7);
        }
        return string2;
    }

    @Nullable
    private static String getNullableAttribute(Attributes attributes, String qName) throws SAXException {
        return attributes.getValue(qName);
    }

    private static SAXException createError(String qName) throws SAXException {
        return new SAXException("Unexpected tag: " + qName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseModuleScript";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseModuleScript";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageCollector";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseModuleScript";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseModuleScript";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class InsideModule
    extends DefaultHandler {
        private final ModuleBuilder moduleBuilder;

        private InsideModule(String name2, @NotNull String outputDir, String type2) {
            if (type2 == null) {
                InsideModule.$$$reportNull$$$1(0);
            }
            if (type2 == null) {
                InsideModule.$$$reportNull$$$0(0);
            }
            this.moduleBuilder = new ModuleBuilder(name2, outputDir, type2);
            ModuleXmlParser.this.modules.add(this.moduleBuilder);
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            if (uri == null) {
                InsideModule.$$$reportNull$$$1(1);
            }
            if (localName == null) {
                InsideModule.$$$reportNull$$$1(2);
            }
            if (qName == null) {
                InsideModule.$$$reportNull$$$1(3);
            }
            if (attributes == null) {
                InsideModule.$$$reportNull$$$1(4);
            }
            if (uri == null) {
                InsideModule.$$$reportNull$$$0(1);
            }
            if (localName == null) {
                InsideModule.$$$reportNull$$$0(2);
            }
            if (qName == null) {
                InsideModule.$$$reportNull$$$0(3);
            }
            if (attributes == null) {
                InsideModule.$$$reportNull$$$0(4);
            }
            if (ModuleXmlParser.SOURCES.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addSourceFiles(path);
            } else if (ModuleXmlParser.COMMON_SOURCES.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addCommonSourceFiles(path);
            } else if (ModuleXmlParser.FRIEND_DIR.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addFriendDir(path);
            } else if (ModuleXmlParser.CLASSPATH.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.addClasspathEntry(path);
            } else if (ModuleXmlParser.JAVA_SOURCE_ROOTS.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                String packagePrefix = ModuleXmlParser.getNullableAttribute(attributes, ModuleXmlParser.JAVA_SOURCE_PACKAGE_PREFIX);
                this.moduleBuilder.addJavaSourceRoot(new JavaRootPath(path, packagePrefix));
            } else if (ModuleXmlParser.MODULAR_JDK_ROOT.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleBuilder.setModularJdkRoot(path);
            } else {
                throw ModuleXmlParser.createError(qName);
            }
        }

        @Override
        public void endElement(String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            if (localName == null) {
                InsideModule.$$$reportNull$$$1(5);
            }
            if (qName == null) {
                InsideModule.$$$reportNull$$$1(6);
            }
            if (localName == null) {
                InsideModule.$$$reportNull$$$0(5);
            }
            if (qName == null) {
                InsideModule.$$$reportNull$$$0(6);
            }
            if (ModuleXmlParser.MODULE.equalsIgnoreCase(qName)) {
                ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ModuleXmlParser.TYPE;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uri";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localName";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$InsideModule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "endElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ModuleXmlParser.TYPE;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uri";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localName";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/cli/common/modules/ModuleXmlParser$InsideModule";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "endElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

