/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRendererFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0005j\b\u0012\u0004\u0012\u00020\u0001`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RootDiagnosticRendererFactory;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRendererFactory;", "<init>", "()V", "factories", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "invoke", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "registerFactory", "", "factory", "frontend.common"})
public final class RootDiagnosticRendererFactory
implements DiagnosticRendererFactory {
    @NotNull
    public static final RootDiagnosticRendererFactory INSTANCE = new RootDiagnosticRendererFactory();
    @NotNull
    private static final LinkedHashSet<DiagnosticRendererFactory> factories = new LinkedHashSet();
    @NotNull
    private static final ReentrantLock lock = new ReentrantLock();

    private RootDiagnosticRendererFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KtDiagnosticRenderer invoke(@NotNull KtDiagnostic diagnostic) {
        KtDiagnosticRenderer ktDiagnosticRenderer;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            Iterator iterator2 = factories.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                KtDiagnosticRenderer renderer;
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                DiagnosticRendererFactory factory2 = (DiagnosticRendererFactory)e;
                KtDiagnosticRenderer ktDiagnosticRenderer2 = renderer = factory2.invoke(diagnostic);
                if (ktDiagnosticRenderer2 == null) continue;
                KtDiagnosticRenderer ktDiagnosticRenderer3 = ktDiagnosticRenderer2;
                return ktDiagnosticRenderer3;
            }
            ktDiagnosticRenderer = diagnostic.getFactory().getKtRenderer();
        }
        finally {
            lock2.unlock();
        }
        return ktDiagnosticRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerFactory(@NotNull DiagnosticRendererFactory factory2) {
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            boolean bl2 = factories.add(factory2);
        }
        finally {
            lock2.unlock();
        }
    }
}

