/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.utils.KaFirCacheCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionInvalidationService;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00070\u0007 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "analyzerCount", "", "analyzerDepth", "Ljava/lang/ThreadLocal;", "kotlin.jvm.PlatformType", "Ljava/lang/ThreadLocal;", "cleanupLatch", "Ljava/util/concurrent/CountDownLatch;", "cleanupScheduleMs", "", "hasOngoingAnalysis", "", "getHasOngoingAnalysis", "()Z", "isAnalysisAllowed", "enterAnalysis", "", "exitAnalysis", "incAnalysisDepth", "decAnalysisDepth", "scheduleCleanup", "performCleanup", "Companion", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKaFirCacheCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirCacheCleaner.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,236:1\n1#2:237\n29#3,3:238\n*S KotlinDebug\n*F\n+ 1 KaFirCacheCleaner.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner\n*L\n226#1:238,3\n*E\n"})
public final class KaFirStopWorldCacheCleaner
implements KaFirCacheCleaner {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private volatile int analyzerCount;
    private final ThreadLocal<Integer> analyzerDepth;
    @Nullable
    private volatile CountDownLatch cleanupLatch;
    private volatile long cleanupScheduleMs;
    @NotNull
    private static final Logger LOG;
    private static final long CACHE_CLEANER_LOCK_TIMEOUT_MS = 50L;

    public KaFirStopWorldCacheCleaner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.analyzerDepth = ThreadLocal.withInitial(KaFirStopWorldCacheCleaner::analyzerDepth$lambda$0);
    }

    private final boolean getHasOngoingAnalysis() {
        return ((Number)this.analyzerDepth.get()).intValue() > 0;
    }

    private final boolean isAnalysisAllowed() {
        return ApplicationManager.getApplication().isReadAccessAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterAnalysis() {
        if (this.getHasOngoingAnalysis()) {
            this.incAnalysisDepth();
            return;
        }
        CountDownLatch existingLatch = this.cleanupLatch;
        if (existingLatch != null) {
            while (!existingLatch.await(50L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
        }
        if (!this.isAnalysisAllowed()) {
            this.incAnalysisDepth();
            return;
        }
        KaFirStopWorldCacheCleaner kaFirStopWorldCacheCleaner = this;
        synchronized (kaFirStopWorldCacheCleaner) {
            boolean bl = false;
            ++this.analyzerCount;
            Unit unit = Unit.INSTANCE;
        }
        this.incAnalysisDepth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitAnalysis() {
        this.decAnalysisDepth();
        if (!this.isAnalysisAllowed() || this.getHasOngoingAnalysis()) {
            return;
        }
        KaFirStopWorldCacheCleaner kaFirStopWorldCacheCleaner = this;
        synchronized (kaFirStopWorldCacheCleaner) {
            CountDownLatch existingLatch;
            boolean bl = false;
            --this.analyzerCount;
            if (!(this.analyzerCount >= 0)) {
                boolean bl2 = false;
                String string2 = "Inconsistency in analyzer block counter";
                throw new IllegalArgumentException(string2.toString());
            }
            if (this.cleanupLatch != null) {
                LOG.info("Analysis complete in " + Thread.currentThread() + ", " + this.analyzerCount + " left before the K2 cache cleanup");
            }
            if (this.analyzerCount == 0 && (existingLatch = this.cleanupLatch) != null) {
                this.performCleanup();
                existingLatch.countDown();
                this.cleanupLatch = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void incAnalysisDepth() {
        this.analyzerDepth.set(((Number)this.analyzerDepth.get()).intValue() + 1);
    }

    private final void decAnalysisDepth() {
        boolean bl;
        Integer oldValue = this.analyzerDepth.get();
        boolean bl2 = bl = oldValue > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Inconsistency in analysis depth counter";
            throw new AssertionError((Object)string2);
        }
        this.analyzerDepth.set(oldValue - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleCleanup() {
        KaFirStopWorldCacheCleaner kaFirStopWorldCacheCleaner = this;
        synchronized (kaFirStopWorldCacheCleaner) {
            boolean bl = false;
            CountDownLatch existingLatch = this.cleanupLatch;
            if (this.analyzerCount == 0) {
                this.cleanupScheduleMs = System.currentTimeMillis();
                this.performCleanup();
                if (existingLatch != null) {
                    existingLatch.countDown();
                    this.cleanupLatch = null;
                    LOG.error("K2 cache cleanup was expected to happen right after the last analysis block completion");
                }
            } else if (existingLatch == null) {
                LOG.info("K2 cache cleanup scheduled from " + Thread.currentThread() + ", " + this.analyzerCount + " analyses left");
                this.cleanupScheduleMs = System.currentTimeMillis();
                this.cleanupLatch = new CountDownLatch(1);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void performCleanup() {
        try {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            LLFirSessionInvalidationService invalidationService = LLFirSessionInvalidationService.Companion.getInstance(this.project);
            invalidationService.invalidateAll(true);
            long cleanupMs = System.currentTimeMillis() - start$iv;
            long totalMs = System.currentTimeMillis() - this.cleanupScheduleMs;
            LOG.info("K2 cache cleanup complete from " + Thread.currentThread() + " in " + cleanupMs + " ms (" + totalMs + " ms after the request)");
        }
        catch (Throwable e) {
            LOG.error("Could not clean up K2 caches", e);
        }
    }

    private static final Integer analyzerDepth$lambda$0() {
        return 0;
    }

    static {
        Logger logger = Logger.getInstance(KaFirStopWorldCacheCleaner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "CACHE_CLEANER_LOCK_TIMEOUT_MS", "", "analysis-api-fir"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

