/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.compile;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u000201H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CompilationPeerCollectingVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitorVoid;", "<init>", "()V", "processed", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "queue", "Lkotlin/collections/ArrayDeque;", "collectedFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectedInlinedClasses", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isInlineFunctionContext", "", "files", "", "getFiles", "()Ljava/util/List;", "inlinedClasses", "", "getInlinedClasses", "()Ljava/util/Set;", "process", "", "declaration", "processSingle", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitContractDescription", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "processResolvable", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nCompilationPeerCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationPeerCollector.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CompilationPeerCollectingVisitor\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 4 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,168:1\n40#2:169\n40#2:178\n67#2:179\n143#3,4:170\n91#3:174\n147#3,2:176\n39#4:175\n*S KotlinDebug\n*F\n+ 1 CompilationPeerCollector.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CompilationPeerCollectingVisitor\n*L\n119#1:169\n144#1:178\n144#1:179\n143#1:170,4\n143#1:174\n143#1:176,2\n143#1:175\n*E\n"})
final class CompilationPeerCollectingVisitor
extends FirDefaultVisitorVoid {
    @NotNull
    private final Set<FirDeclaration> processed = new LinkedHashSet();
    @NotNull
    private final ArrayDeque<FirDeclaration> queue = new ArrayDeque();
    @NotNull
    private final Set<KtFile> collectedFiles = new LinkedHashSet();
    @NotNull
    private final Set<KtClassOrObject> collectedInlinedClasses = new LinkedHashSet();
    private boolean isInlineFunctionContext;

    @NotNull
    public final List<KtFile> getFiles() {
        return kotlin.collections.CollectionsKt.toList((Iterable)this.collectedFiles);
    }

    @NotNull
    public final Set<KtClassOrObject> getInlinedClasses() {
        return this.collectedInlinedClasses;
    }

    public final void process(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.processSingle(declaration);
        while (!((Collection)this.queue).isEmpty()) {
            this.processSingle((FirDeclaration)this.queue.removeFirst());
        }
    }

    private final void processSingle(FirDeclaration declaration) {
        ProgressManager.checkCanceled();
        if (this.processed.add(declaration)) {
            PsiFile containingFile;
            PsiElement psiElement = UtilsKt.getPsi(declaration);
            Object object = containingFile = psiElement != null ? psiElement.getContainingFile() : null;
            if (containingFile instanceof KtFile && !((KtFile)containingFile).isCompiled()) {
                this.collectedFiles.add((KtFile)containingFile);
                declaration.accept(this);
            }
        }
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof FirResolvable) {
            this.processResolvable((FirResolvable)element);
        }
        element.acceptChildren(this);
    }

    @Override
    public void visitBlock(@NotNull FirBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (!(block instanceof FirContractCallBlock)) {
            super.visitBlock(block);
        }
    }

    @Override
    public void visitContractDescription(@NotNull FirContractDescription contractDescription) {
        Intrinsics.checkNotNullParameter((Object)contractDescription, (String)"contractDescription");
    }

    @Override
    public void visitConstructor(@NotNull FirConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        FirLazyDeclarationResolverKt.lazyResolveToPhase(constructor, FirResolvePhase.BODY_RESOLVE);
        super.visitConstructor(constructor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        FirLazyDeclarationResolverKt.lazyResolveToPhase(simpleFunction, FirResolvePhase.BODY_RESOLVE);
        boolean oldIsInlineFunctionContext = this.isInlineFunctionContext;
        try {
            FirMemberDeclaration $this$isInline$iv = simpleFunction;
            boolean $i$f$isInline = false;
            this.isInlineFunctionContext = $this$isInline$iv.getStatus().isInline();
            super.visitFunction(simpleFunction);
        }
        finally {
            this.isInlineFunctionContext = oldIsInlineFunctionContext;
        }
    }

    @Override
    public void visitProperty(@NotNull FirProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        FirLazyDeclarationResolverKt.lazyResolveToPhase(property2, FirResolvePhase.BODY_RESOLVE);
        super.visitProperty(property2);
    }

    @Override
    public void visitClass(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        super.visitClass(klass);
        if (this.isInlineFunctionContext) {
            PsiElement psiElement = UtilsKt.getPsi(klass);
            CollectionsKt.addIfNotNull((Collection)this.collectedInlinedClasses, psiElement instanceof KtClassOrObject ? (KtClassOrObject)psiElement : null);
        }
    }

    private final void processResolvable(FirResolvable element) {
        FirReference reference2 = element.getCalleeReference();
        if (!(reference2 instanceof FirResolvedNamedReference)) {
            return;
        }
        FirBasedSymbol<?> symbol = ((FirResolvedNamedReference)reference2).getResolvedSymbol();
        if (symbol instanceof FirCallableSymbol) {
            FirCallableDeclaration fir = (FirCallableDeclaration)((FirCallableSymbol)symbol).getFir();
            if (fir instanceof FirFunction) {
                CompilationPeerCollectingVisitor.processResolvable$addToQueue(this, (FirFunction)fir);
            } else if (fir instanceof FirProperty) {
                CompilationPeerCollectingVisitor.processResolvable$addToQueue(this, ((FirProperty)fir).getGetter());
                CompilationPeerCollectingVisitor.processResolvable$addToQueue(this, ((FirProperty)fir).getSetter());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void processResolvable$addToQueue(CompilationPeerCollectingVisitor this$0, FirFunction function) {
        block9: {
            block8: {
                v0 = function;
                if (v0 == null) break block8;
                $this$unwrapSubstitutionOverrides$iv = v0;
                $i$f$unwrapSubstitutionOverrides = false;
                current$iv = $this$unwrapSubstitutionOverrides$iv;
                while (true) {
                    $this$originalForSubstitutionOverride$iv$iv = current$iv;
                    $i$f$getOriginalForSubstitutionOverride = false;
                    if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv)) ** GOTO lbl-1000
                    $this$isSynthetic$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv;
                    $i$f$isSynthetic = false;
                    if ($this$isSynthetic$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                    // 2 sources

                    {
                        v1 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv);
                    } else {
                        v1 = null;
                    }
                    if (v1 == null) break;
                    current$iv = next$iv = v1;
                }
                v0 = (FirFunction)current$iv;
                if (v0 != null) break block9;
            }
            return;
        }
        original = v0;
        $this$isInline$iv = original;
        $i$f$isInline = false;
        if ($this$isInline$iv.getStatus().isInline()) {
            $this$hasBody$iv = original;
            $i$f$getHasBody = false;
            if ($this$hasBody$iv.getBody() != null) {
                this$0.queue.add((Object)function);
            }
        }
    }
}

