/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JdkClassesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.JvmRecordApplicabilityCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "<init>", "(Lorg/jetbrains/kotlin/config/JvmTarget;)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmRecordApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmRecordApplicabilityChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n295#2,2:170\n*S KotlinDebug\n*F\n+ 1 JvmRecordApplicabilityChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmRecordApplicabilityChecker\n*L\n45#1:170,2\n*E\n"})
public final class JvmRecordApplicabilityChecker
implements DeclarationChecker {
    @NotNull
    private final JvmTarget jvmTarget;

    public JvmRecordApplicabilityChecker(@NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        this.jvmTarget = jvmTarget;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Object parameters;
        Iterator<Object> modifierOrName;
        KtElementImplStub reportOn;
        Object v2;
        Object element$iv;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray;
        block24: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(descriptor instanceof ClassDescriptor) || !(declaration instanceof KtClassOrObject)) {
                return;
            }
            for (KtSuperTypeListEntry supertypeEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
                KotlinType supertype = (KotlinType)context.getTrace().get(BindingContext.TYPE, supertypeEntry.getTypeReference());
                Object object = supertype;
                if (!Intrinsics.areEqual(object != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object) : null, (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
                context.getTrace().report(ErrorsJvm.ILLEGAL_JAVA_LANG_RECORD_SUPERTYPE.on((PsiElement)supertypeEntry));
                return;
            }
            if (!JvmAnnotationUtilKt.isJvmRecord((ClassDescriptor)descriptor)) {
                return;
            }
            List<KtAnnotationEntry> list = ((KtClassOrObject)declaration).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationEntries(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            ktModifierKeywordTokenArray = $this$firstOrNull$iv.iterator();
            while (ktModifierKeywordTokenArray.hasNext()) {
                element$iv = ktModifierKeywordTokenArray.next();
                KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getShortName(), (Object)JvmStandardClassIds.JVM_RECORD_ANNOTATION_FQ_NAME.shortName())) continue;
                v2 = element$iv;
                break block24;
            }
            v2 = null;
        }
        KtAnnotationEntry ktAnnotationEntry = v2;
        KtElementImplStub ktElementImplStub = reportOn = ktAnnotationEntry != null ? (KtElementImplStub)ktAnnotationEntry : (KtElementImplStub)((Object)declaration);
        if (DescriptorUtilsKt.resolveTopLevelClass(context.getModuleDescriptor(), JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME(), NoLookupLocation.FOR_DEFAULT_IMPORTS) == null) {
            context.getTrace().report(ErrorsJvm.JVM_RECORD_REQUIRES_JDK15.on((PsiElement)reportOn));
            return;
        }
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmRecordSupport)) {
            context.getTrace().report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)reportOn, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.JvmRecordSupport), (Object)context.getLanguageVersionSettings())));
            return;
        }
        if (!JvmRecordApplicabilityCheckerKt.access$areRecordsAllowed(this.jvmTarget, context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getEnableJvmPreview()))) {
            context.getTrace().report(ErrorsJvm.JVM_RECORDS_ILLEGAL_BYTECODE_TARGET.on((PsiElement)reportOn));
            return;
        }
        if (((ClassDescriptor)descriptor).getKind() == ClassKind.ENUM_CLASS) {
            KtModifierList ktModifierList = ((KtClassOrObject)declaration).getModifierList();
            if ((ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.ENUM_KEYWORD)) == null) && (ktModifierList = ((KtClassOrObject)declaration).getNameIdentifier()) == null) {
                ktModifierList = declaration;
            }
            modifierOrName = ktModifierList;
            context.getTrace().report(ErrorsJvm.ENUM_JVM_RECORD.on((PsiElement)modifierOrName));
            return;
        }
        if (!ModalityUtilsKt.isFinalClass((ClassDescriptor)descriptor)) {
            KtModifierList ktModifierList = ((KtClassOrObject)declaration).getModifierList();
            if ((ktModifierList == null || (ktModifierList = JvmRecordApplicabilityCheckerKt.access$findOneOfModifiers(ktModifierList, ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.ABSTRACT_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.SEALED_KEYWORD})) == null) && (ktModifierList = ((KtClassOrObject)declaration).getNameIdentifier()) == null) {
                ktModifierList = declaration;
            }
            modifierOrName = ktModifierList;
            context.getTrace().report(ErrorsJvm.NON_FINAL_JVM_RECORD.on((PsiElement)modifierOrName));
            return;
        }
        if (((ClassDescriptor)descriptor).isInner()) {
            KtModifierList ktModifierList = ((KtClassOrObject)declaration).getModifierList();
            if ((ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.INNER_KEYWORD)) == null) && (ktModifierList = ((KtClassOrObject)declaration).getNameIdentifier()) == null) {
                ktModifierList = declaration;
            }
            modifierOrName = ktModifierList;
            context.getTrace().report(ErrorsJvm.INNER_JVM_RECORD.on((PsiElement)modifierOrName));
            return;
        }
        if (DescriptorUtils.isLocal(descriptor)) {
            context.getTrace().report(ErrorsJvm.LOCAL_JVM_RECORD.on((PsiElement)reportOn));
            return;
        }
        for (KtDeclaration member : ((KtClassOrObject)declaration).getDeclarations()) {
            PropertyDescriptor propertyDescriptor;
            if (!(member instanceof KtProperty) || ((element$iv = context.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, member)) instanceof PropertyDescriptor ? (PropertyDescriptor)element$iv : null) == null) continue;
            propertyDescriptor = propertyDescriptor;
            if (!Intrinsics.areEqual(context.getTrace().getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor), (Object)true) && ((KtProperty)member).getDelegate() == null) continue;
            context.getTrace().report(ErrorsJvm.FIELD_IN_JVM_RECORD.on(member));
            return;
        }
        for (KtSuperTypeListEntry superTypeEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            if (!(superTypeEntry instanceof KtDelegatedSuperTypeEntry)) continue;
            context.getTrace().report(ErrorsJvm.DELEGATION_BY_IN_JVM_RECORD.on((PsiElement)superTypeEntry));
            return;
        }
        for (KotlinType supertype : ((ClassDescriptor)descriptor).getTypeConstructor().getSupertypes()) {
            ClassDescriptor classDescriptor;
            element$iv = supertype.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor2 = element$iv instanceof ClassDescriptor ? (ClassDescriptor)element$iv : null;
            if (classDescriptor2 == null || (classDescriptor = classDescriptor2).getKind() == ClassKind.INTERFACE || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor), (Object)JdkClassesKt.getJAVA_LANG_RECORD_FQ_NAME())) continue;
            PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
            if (psiElement == null) {
                psiElement = declaration;
            }
            PsiElement reportSupertypeOn = psiElement;
            context.getTrace().report(ErrorsJvm.JVM_RECORD_EXTENDS_CLASS.on(reportSupertypeOn, supertype));
            return;
        }
        if (!((ClassDescriptor)descriptor).isData()) {
            context.getTrace().report(ErrorsJvm.NON_DATA_CLASS_JVM_RECORD.on((PsiElement)reportOn));
            return;
        }
        KtPrimaryConstructor primaryConstructor = ((KtClassOrObject)declaration).getPrimaryConstructor();
        Object object = primaryConstructor;
        if (object == null || (object = ((KtConstructor)object).getValueParameters()) == null) {
            object = CollectionsKt.emptyList();
        }
        if ((parameters = object).isEmpty()) {
            PsiElement psiElement;
            KtElementImplStub ktElementImplStub2 = primaryConstructor;
            PsiElement psiElement2 = ktElementImplStub2 != null && (ktElementImplStub2 = ktElementImplStub2.getValueParameterList()) != null ? (PsiElement)ktElementImplStub2 : (psiElement = ((KtClassOrObject)declaration).getNameIdentifier());
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                context.getTrace().report(ErrorsJvm.JVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS.on(it));
                return;
            }
        }
        Iterator iterator2 = parameters.iterator();
        while (iterator2.hasNext()) {
            KtParameter parameter = (KtParameter)iterator2.next();
            if (parameter.hasValOrVar() && !parameter.isMutable()) continue;
            context.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_VAL_PARAMETER.on(parameter));
            return;
        }
        for (KtParameter parameter : CollectionsKt.dropLast((List)parameters, (int)1)) {
            if (!parameter.isVarArg()) continue;
            context.getTrace().report(ErrorsJvm.JVM_RECORD_NOT_LAST_VARARG_PARAMETER.on(parameter));
            return;
        }
    }
}

