/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.model.FlexibleTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001c\u0010\u000b\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001c\u0010\f\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/types/AbstractStrictEqualityTypeChecker;", "", "<init>", "()V", "strictEqualTypes", "", "context", "Lorg/jetbrains/kotlin/types/model/TypeSystemContext;", "a", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "b", "strictEqualTypesInternal", "strictEqualRigidTypes", "Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;", "compiler.common"})
public final class AbstractStrictEqualityTypeChecker {
    @NotNull
    public static final AbstractStrictEqualityTypeChecker INSTANCE = new AbstractStrictEqualityTypeChecker();

    private AbstractStrictEqualityTypeChecker() {
    }

    public final boolean strictEqualTypes(@NotNull TypeSystemContext context, @NotNull KotlinTypeMarker a, @NotNull KotlinTypeMarker b) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.strictEqualTypesInternal(context, a, b);
    }

    private final boolean strictEqualTypesInternal(TypeSystemContext $this$strictEqualTypesInternal, KotlinTypeMarker a, KotlinTypeMarker b) {
        if (a == b) {
            return true;
        }
        RigidTypeMarker simpleA = $this$strictEqualTypesInternal.asRigidType(a);
        RigidTypeMarker simpleB = $this$strictEqualTypesInternal.asRigidType(b);
        if (simpleA != null && simpleB != null) {
            return this.strictEqualRigidTypes($this$strictEqualTypesInternal, simpleA, simpleB);
        }
        FlexibleTypeMarker flexibleA = $this$strictEqualTypesInternal.asFlexibleType(a);
        FlexibleTypeMarker flexibleB = $this$strictEqualTypesInternal.asFlexibleType(b);
        if (flexibleA != null && flexibleB != null) {
            return this.strictEqualRigidTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.lowerBound(flexibleA), $this$strictEqualTypesInternal.lowerBound(flexibleB)) && this.strictEqualRigidTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.upperBound(flexibleA), $this$strictEqualTypesInternal.upperBound(flexibleB));
        }
        return false;
    }

    private final boolean strictEqualRigidTypes(TypeSystemContext $this$strictEqualRigidTypes, RigidTypeMarker a, RigidTypeMarker b) {
        if ($this$strictEqualRigidTypes.argumentsCount(a) != $this$strictEqualRigidTypes.argumentsCount(b) || $this$strictEqualRigidTypes.isMarkedNullable(a) != $this$strictEqualRigidTypes.isMarkedNullable(b) || $this$strictEqualRigidTypes.isDefinitelyNotNullType(a) != $this$strictEqualRigidTypes.isDefinitelyNotNullType(b) || !$this$strictEqualRigidTypes.areEqualTypeConstructors($this$strictEqualRigidTypes.typeConstructor(a), $this$strictEqualRigidTypes.typeConstructor(b))) {
            return false;
        }
        if ($this$strictEqualRigidTypes.identicalArguments(a, b)) {
            return true;
        }
        int n = $this$strictEqualRigidTypes.argumentsCount(a);
        for (int i2 = 0; i2 < n; ++i2) {
            TypeArgumentMarker aArg = $this$strictEqualRigidTypes.getArgument(a, i2);
            TypeArgumentMarker bArg = $this$strictEqualRigidTypes.getArgument(b, i2);
            if ($this$strictEqualRigidTypes.isStarProjection(aArg) != $this$strictEqualRigidTypes.isStarProjection(bArg)) {
                return false;
            }
            if ($this$strictEqualRigidTypes.isStarProjection(aArg)) continue;
            if ($this$strictEqualRigidTypes.getVariance(aArg) != $this$strictEqualRigidTypes.getVariance(bArg)) {
                return false;
            }
            KotlinTypeMarker kotlinTypeMarker = $this$strictEqualRigidTypes.getType(aArg);
            Intrinsics.checkNotNull((Object)kotlinTypeMarker);
            KotlinTypeMarker kotlinTypeMarker2 = $this$strictEqualRigidTypes.getType(bArg);
            Intrinsics.checkNotNull((Object)kotlinTypeMarker2);
            if (this.strictEqualTypesInternal($this$strictEqualRigidTypes, kotlinTypeMarker, kotlinTypeMarker2)) continue;
            return false;
        }
        return true;
    }
}

