/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.org.objectweb.asm.Label;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/OrOr;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "<init>", "()V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "BooleanDisjunction", "backend.jvm.codegen"})
public final class OrOr
extends IntrinsicMethod {
    @NotNull
    public static final OrOr INSTANCE = new OrOr();

    private OrOr() {
    }

    @Override
    @NotNull
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List<IrExpression> list = IrUtilsKt.receiverAndArgs(expression2);
        IrExpression left = list.get(0);
        IrExpression right = list.get(1);
        return new BooleanDisjunction(left, right, codegen2, data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/OrOr$BooleanDisjunction;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "left", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "right", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;)V", "getLeft", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getRight", "getData", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "jumpIfFalse", "", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "discard", "backend.jvm.codegen"})
    private static final class BooleanDisjunction
    extends BooleanValue {
        @NotNull
        private final IrExpression left;
        @NotNull
        private final IrExpression right;
        @NotNull
        private final BlockInfo data;

        public BooleanDisjunction(@NotNull IrExpression left, @NotNull IrExpression right, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Intrinsics.checkNotNullParameter((Object)codegen2, (String)"codegen");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(codegen2);
            this.left = left;
            this.right = right;
            this.data = data;
        }

        @NotNull
        public final IrExpression getLeft() {
            return this.left;
        }

        @NotNull
        public final IrExpression getRight() {
            return this.right;
        }

        @NotNull
        public final BlockInfo getData() {
            return this.data;
        }

        @Override
        public void jumpIfFalse(@NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Label stayLabel = new Label();
            BooleanValue leftValue = PromisedValueKt.coerceToBoolean((PromisedValue)this.left.accept(this.getCodegen(), this.data));
            this.markLineNumber(this.left);
            leftValue.jumpIfTrue(stayLabel);
            BooleanValue rightValue = PromisedValueKt.coerceToBoolean((PromisedValue)this.right.accept(this.getCodegen(), this.data));
            this.markLineNumber(this.right);
            rightValue.jumpIfFalse(target);
            this.getMv().visitLabel(stayLabel);
        }

        @Override
        public void jumpIfTrue(@NotNull Label target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            BooleanValue leftValue = PromisedValueKt.coerceToBoolean((PromisedValue)this.left.accept(this.getCodegen(), this.data));
            this.markLineNumber(this.left);
            leftValue.jumpIfTrue(target);
            BooleanValue rightValue = PromisedValueKt.coerceToBoolean((PromisedValue)this.right.accept(this.getCodegen(), this.data));
            this.markLineNumber(this.right);
            rightValue.jumpIfTrue(target);
        }

        @Override
        public void discard() {
            Label end = new Label();
            BooleanValue leftValue = PromisedValueKt.coerceToBoolean((PromisedValue)this.left.accept(this.getCodegen(), this.data));
            this.markLineNumber(this.left);
            leftValue.jumpIfTrue(end);
            PromisedValue rightValue = (PromisedValue)this.right.accept(this.getCodegen(), this.data);
            this.markLineNumber(this.right);
            rightValue.discard();
            this.getMv().visitLabel(end);
        }
    }
}

