/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotationInvocationHandler
implements InvocationHandler {
    @NotNull
    private final Class<? extends Annotation> type;
    @NotNull
    private final PsiAnnotation myAnnotation;

    AnnotationInvocationHandler(@NotNull Class<? extends Annotation> type2, @NotNull PsiAnnotation annotation) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/AnnotationInvocationHandler", "<init>"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/AnnotationInvocationHandler", "<init>"));
        }
        this.type = type2;
        this.myAnnotation = annotation;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Object[] paramTypes = method.getParameterTypes();
        assert (paramTypes.length == 0) : Arrays.toString(paramTypes);
        String member = method.getName();
        if (member.equals("toString")) {
            return this.toStringImpl();
        }
        if (member.equals("annotationType")) {
            return this.type;
        }
        Pair<PsiAnnotationMemberValue, String> pair = AnnotationInvocationHandler.attributeValueOrError(this.myAnnotation, member);
        PsiAnnotationMemberValue value2 = (PsiAnnotationMemberValue)pair.first;
        if (value2 == null) {
            String error = (String)pair.second;
            throw new IncompleteAnnotationException(this.type, member + ". (Unable to find attribute in '" + this.myAnnotation.getText() + "': " + error + ")");
        }
        Object result = JavaPsiFacade.getInstance(this.myAnnotation.getProject()).getConstantEvaluationHelper().computeConstantExpression(value2);
        if (result == null) {
            throw new IncompleteAnnotationException(this.type, member + ". (Unable to evaluate annotation value '" + value2 + "')");
        }
        return result;
    }

    @NotNull
    private static Pair<PsiAnnotationMemberValue, String> attributeValueOrError(@NotNull PsiAnnotation annotation, @Nullable @NonNls String attributeName) {
        PsiMethod[] methods;
        PsiClass psiClass;
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotationMemberValue value2;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/AnnotationInvocationHandler", "attributeValueOrError"));
        }
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute(annotation, attributeName);
        PsiAnnotationMemberValue psiAnnotationMemberValue = value2 = attribute == null ? null : attribute.getValue();
        if (value2 != null) {
            Pair<PsiAnnotationMemberValue, Object> pair = Pair.create(value2, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationInvocationHandler", "attributeValueOrError"));
            }
            return pair;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation.getNameReferenceElement()) == null) {
            Pair<Object, String> pair = Pair.create(null, "no reference found in " + annotation.getText());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationInvocationHandler", "attributeValueOrError"));
            }
            return pair;
        }
        PsiElement resolved = referenceElement.resolve();
        if (resolved == null) {
            Pair<Object, String> pair = Pair.create(null, "can't resolve reference '" + referenceElement.getText() + "'");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationInvocationHandler", "attributeValueOrError"));
            }
            return pair;
        }
        if (!(resolved instanceof PsiClass) || !(psiClass = (PsiClass)resolved).isAnnotationType()) {
            Pair<Object, String> pair = Pair.create(null, "reference '" + referenceElement.getText() + "' resolved to " + resolved + " (" + resolved.getClass() + ") instead of enum");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationInvocationHandler", "attributeValueOrError"));
            }
            return pair;
        }
        for (PsiMethod method : methods = psiClass.findMethodsByName(attributeName, false)) {
            if (!(method instanceof PsiAnnotationMethod)) continue;
            PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)method).getDefaultValue();
            if (defaultValue != null) {
                Pair<PsiAnnotationMemberValue, Object> pair = Pair.create(defaultValue, null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationInvocationHandler", "attributeValueOrError"));
                }
                return pair;
            }
            Pair<Object, String> pair = Pair.create(null, "method has no value nor default value: " + method.getText());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationInvocationHandler", "attributeValueOrError"));
            }
            return pair;
        }
        Pair<Object, String> pair = Pair.create(null, "method '" + attributeName + "' not found in " + psiClass.getQualifiedName() + " among methods " + Arrays.asList(psiClass.getMethods()));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationInvocationHandler", "attributeValueOrError"));
        }
        return pair;
    }

    private String toStringImpl() {
        PsiNameValuePair[] attributes;
        StringBuilder result = new StringBuilder(128);
        result.append('@');
        result.append(this.type.getName());
        result.append('(');
        boolean firstMember = true;
        for (PsiNameValuePair e : attributes = this.myAnnotation.getParameterList().getAttributes()) {
            if (firstMember) {
                firstMember = false;
            } else {
                result.append(", ");
            }
            result.append(e.getName());
            result.append('=');
            PsiAnnotationMemberValue value2 = e.getValue();
            result.append(value2 == null ? "null" : value2.getText());
        }
        result.append(')');
        return result.toString();
    }
}

