/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationInvocationHandler;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processors;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final String NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String NOT_NULL = "org.jetbrains.annotations.NotNull";
    @NonNls
    public static final String NOT_NULL_SIMPLE_NAME = "NotNull";
    @NonNls
    public static final String NULLABLE_SIMPLE_NAME = "Nullable";
    public static final String NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String NLS = "org.jetbrains.annotations.Nls";
    public static final String PROPERTY_KEY = "org.jetbrains.annotations.PropertyKey";
    @NonNls
    public static final String PROPERTY_KEY_RESOURCE_BUNDLE_PARAMETER = "resourceBundle";
    @NonNls
    public static final String NON_NLS_SIMPLE_NAME = "NonNls";
    @NonNls
    public static final String PROPERTY_KEY_SIMPLE_NAME = "PropertyKey";
    public static final String TEST_ONLY = "org.jetbrains.annotations.TestOnly";
    @NonNls
    public static final String TEST_ONLY_SIMPLE_NAME = "TestOnly";
    public static final String LANGUAGE = "org.intellij.lang.annotations.Language";
    public static final Set<String> ALL_ANNOTATIONS;
    @NonNls
    private static final String[] SIMPLE_NAMES;

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (annotationNames.length == 0) {
            return null;
        }
        HashSet<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : ContainerUtil.newHashSet(annotationNames);
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (listOwner == null) {
            return null;
        }
        PsiAnnotation annotation = AnnotationUtil.findOwnAnnotation(listOwner, annotationNames);
        if (annotation != null) {
            return annotation;
        }
        return skipExternal ? null : AnnotationUtil.findNonCodeAnnotation(listOwner, annotationNames);
    }

    private static PsiAnnotation findOwnAnnotation(final PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        ConcurrentFactoryMap map2 = (ConcurrentFactoryMap)CachedValuesManager.getCachedValue(listOwner, () -> {
            ConcurrentFactoryMap<Collection<String>, PsiAnnotation> value2 = new ConcurrentFactoryMap<Collection<String>, PsiAnnotation>(){

                @Override
                @Nullable
                protected PsiAnnotation create(Collection<String> annotationNames1) {
                    PsiModifierList list = listOwner.getModifierList();
                    if (list == null) {
                        return null;
                    }
                    for (PsiAnnotation annotation : list.getAnnotations()) {
                        if (!annotationNames1.contains(annotation.getQualifiedName())) continue;
                        return annotation;
                    }
                    return null;
                }
            };
            return CachedValueProvider.Result.create(value2, PsiModificationTracker.MODIFICATION_COUNT);
        });
        return (PsiAnnotation)map2.get(annotationNames);
    }

    private static PsiAnnotation findNonCodeAnnotation(final PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        ConcurrentFactoryMap map2 = (ConcurrentFactoryMap)CachedValuesManager.getCachedValue(listOwner, () -> {
            ConcurrentFactoryMap<Collection<String>, PsiAnnotation> value2 = new ConcurrentFactoryMap<Collection<String>, PsiAnnotation>(){

                @Override
                @Nullable
                protected PsiAnnotation create(Collection<String> annotationNames1) {
                    Project project = listOwner.getProject();
                    ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(project);
                    for (String annotationName : annotationNames1) {
                        PsiAnnotation annotation = annotationsManager.findExternalAnnotation(listOwner, annotationName);
                        if (annotation == null) continue;
                        return annotation;
                    }
                    InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
                    for (String annotationName : annotationNames1) {
                        PsiAnnotation annotation = inferredAnnotationsManager.findInferredAnnotation(listOwner, annotationName);
                        if (annotation == null) continue;
                        return annotation;
                    }
                    return null;
                }
            };
            return CachedValueProvider.Result.create(value2, PsiModificationTracker.MODIFICATION_COUNT);
        });
        return (PsiAnnotation)map2.get(annotationNames);
    }

    @NotNull
    public static PsiAnnotation[] findAnnotations(@Nullable PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotations"));
        }
        if (modifierListOwner == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationUtil", "findAnnotations"));
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationUtil", "findAnnotations"));
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] annotations2 = modifierList.getAnnotations();
        ArrayList<PsiAnnotation> result = null;
        for (PsiAnnotation psiAnnotation : annotations2) {
            if (!annotationNames.contains(psiAnnotation.getQualifiedName())) continue;
            if (result == null) {
                result = new ArrayList<PsiAnnotation>();
            }
            result.add(psiAnnotation);
        }
        PsiAnnotation[] psiAnnotationArray = result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(new PsiAnnotation[result.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationUtil", "findAnnotations"));
        }
        return psiAnnotationArray;
    }

    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(T element) {
        return (List)CachedValuesManager.getCachedValue(element, () -> {
            LinkedHashSet<PsiModifierListOwner> result = ContainerUtil.newLinkedHashSet();
            if (element instanceof PsiMethod) {
                AnnotationUtil.collectSuperMethods(result, ((PsiMethod)element).getHierarchicalMethodSignature(), element, JavaPsiFacade.getInstance(element.getProject()).getResolveHelper());
            } else if (element instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)element, false, Processors.cancelableCollectProcessor(result));
            } else if (element instanceof PsiParameter) {
                AnnotationUtil.collectSuperParameters(result, (PsiParameter)element);
            }
            ArrayList<PsiModifierListOwner> list = new ArrayList<PsiModifierListOwner>();
            list.addAll(result);
            return CachedValueProvider.Result.create(list, PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(final @NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationNames", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        ConcurrentFactoryMap map2 = (ConcurrentFactoryMap)CachedValuesManager.getCachedValue(listOwner, () -> {
            if (listOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "lambda$findAnnotationInHierarchy$3"));
            }
            ConcurrentFactoryMap<Set<String>, PsiAnnotation> value2 = new ConcurrentFactoryMap<Set<String>, PsiAnnotation>(){

                @Override
                @Nullable
                protected PsiAnnotation create(Set<String> annotationNames1) {
                    for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
                        PsiAnnotation annotation = AnnotationUtil.findAnnotation(superOwner, annotationNames1);
                        if (annotation == null) continue;
                        return annotation;
                    }
                    return null;
                }
            };
            return CachedValueProvider.Result.create(value2, PsiModificationTracker.MODIFICATION_COUNT);
        });
        return (PsiAnnotation)map2.get(annotationNames);
    }

    private static void collectSuperParameters(@NotNull Set<PsiModifierListOwner> result, @NotNull PsiParameter parameter) {
        block7: {
            PsiElement scope;
            Consumer<PsiMethod> forEachSuperMethod;
            block6: {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/AnnotationUtil", "collectSuperParameters"));
                }
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/AnnotationUtil", "collectSuperParameters"));
                }
                PsiElement parent = parameter.getParent();
                if (!(parent instanceof PsiParameterList)) {
                    return;
                }
                int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                forEachSuperMethod = method -> {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/AnnotationUtil", "lambda$collectSuperParameters$4"));
                    }
                    PsiParameter[] superParameters = method.getParameterList().getParameters();
                    if (index < superParameters.length) {
                        result.add(superParameters[index]);
                    }
                };
                scope = parent.getParent();
                if (!(scope instanceof PsiLambdaExpression)) break block6;
                PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)scope).getFunctionalInterfaceType());
                if (method2 == null) break block7;
                forEachSuperMethod.consume(method2);
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method2)) {
                    forEachSuperMethod.consume(superMethod);
                }
                break block7;
            }
            if (scope instanceof PsiMethod) {
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners((PsiMethod)scope)) {
                    forEachSuperMethod.consume(superMethod);
                }
            }
        }
    }

    private static void collectSuperMethods(@NotNull Set<PsiModifierListOwner> result, @NotNull HierarchicalMethodSignature signature, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/AnnotationUtil", "collectSuperMethods"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInsight/AnnotationUtil", "collectSuperMethods"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/AnnotationUtil", "collectSuperMethods"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/AnnotationUtil", "collectSuperMethods"));
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result, superSignature, place, resolveHelper);
        }
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations2) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations2, false);
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations2, boolean checkHierarchy) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotations2, checkHierarchy, true);
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations2, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        for (String annotation : annotations2) {
            if (!AnnotationUtil.isAnnotated(listOwner, annotation, checkHierarchy, skipExternal)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls @NotNull String annotationFQN, boolean checkHierarchy) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, true, null);
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, skipExternal, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls @NotNull String annotationFQN, boolean checkHierarchy, boolean skipExternal, @Nullable Set<PsiMember> processed) {
        block12: {
            PsiClass[] superClasses;
            block13: {
                PsiMethod[] superMethods;
                Project project;
                if (listOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
                }
                if (annotationFQN == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
                }
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (!(skipExternal || ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) == null && InferredAnnotationsManager.getInstance(project).findInferredAnnotation(listOwner, annotationFQN) == null)) {
                    return true;
                }
                if (!checkHierarchy) break block12;
                if (!(listOwner instanceof PsiMethod)) break block13;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet();
                }
                if (!processed.add((PsiMember)method)) {
                    return false;
                }
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, true, skipExternal, (Set<PsiMember>)processed)) continue;
                    return true;
                }
                break block12;
            }
            if (!(listOwner instanceof PsiClass)) break block12;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : superClasses = clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, true, skipExternal, (Set<PsiMember>)processed)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/AnnotationUtil", "isAnnotatingApplicable"));
        }
        return AnnotationUtil.isAnnotatingApplicable(elt, NullableNotNullManager.getInstance(elt.getProject()).getDefaultNullable());
    }

    public static boolean isAnnotatingApplicable(@NotNull PsiElement elt, @NotNull String annotationFQN) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/AnnotationUtil", "isAnnotatingApplicable"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/codeInsight/AnnotationUtil", "isAnnotatingApplicable"));
        }
        Project project = elt.getProject();
        return PsiUtil.isLanguageLevel5OrHigher(elt) && JavaPsiFacade.getInstance(project).findClass(annotationFQN, elt.getResolveScope()) != null;
    }

    public static boolean isJetbrainsAnnotation(@NonNls @NotNull String simpleName) {
        if (simpleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleName", "com/intellij/codeInsight/AnnotationUtil", "isJetbrainsAnnotation"));
        }
        return ArrayUtil.find(SIMPLE_NAMES, simpleName) != -1;
    }

    @Contract(value="null,_ -> false")
    public static boolean checkAnnotatedUsingPatterns(@Nullable PsiModifierListOwner owner, @NotNull Collection<String> annotations2) {
        PsiModifierList modList;
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/codeInsight/AnnotationUtil", "checkAnnotatedUsingPatterns"));
        }
        if (owner == null || (modList = owner.getModifierList()) == null) {
            return false;
        }
        ArrayList<String> fqns = null;
        for (String fqn : annotations2) {
            boolean isPattern = fqn.endsWith("*");
            if (!isPattern && AnnotationUtil.isAnnotated(owner, fqn, false)) {
                return true;
            }
            if (!isPattern) continue;
            if (fqns == null) {
                PsiAnnotation[] ownAnnotations;
                fqns = new ArrayList<String>();
                for (PsiAnnotation anno : ownAnnotations = modList.getAnnotations()) {
                    String qName = anno.getQualifiedName();
                    if (qName == null) continue;
                    fqns.add(qName);
                }
                if (fqns.isEmpty()) {
                    return false;
                }
            }
            fqn = fqn.substring(0, fqn.length() - 2);
            for (String annoFQN : fqns) {
                if (!annoFQN.startsWith(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod getAnnotationMethod(@NotNull PsiNameValuePair pair) {
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/codeInsight/AnnotationUtil", "getAnnotationMethod"));
        }
        PsiAnnotation annotation = PsiTreeUtil.getParentOfType(pair.getParent(), PsiAnnotation.class);
        assert (annotation != null);
        String fqn = annotation.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance(pair.getProject()).findClass(fqn, pair.getResolveScope());
        if (psiClass != null && psiClass.isAnnotationType()) {
            String name = pair.getName();
            return ArrayUtil.getFirstElement(psiClass.findMethodsByName(name != null ? name : "value", false));
        }
        return null;
    }

    @NotNull
    public static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<PsiModifierListOwner> visited) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/AnnotationUtil", "getAllAnnotations"));
        }
        PsiAnnotation[] psiAnnotationArray = AnnotationUtil.getAllAnnotations(owner, inHierarchy, visited, true);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationUtil", "getAllAnnotations"));
        }
        return psiAnnotationArray;
    }

    @NotNull
    public static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy, @Nullable Set<PsiModifierListOwner> visited, boolean withInferred) {
        Project project;
        PsiAnnotation[] externalAnnotations;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/AnnotationUtil", "getAllAnnotations"));
        }
        PsiModifierList list = owner.getModifierList();
        PsiAnnotation[] annotations2 = PsiAnnotation.EMPTY_ARRAY;
        if (list != null) {
            annotations2 = list.getAnnotations();
        }
        if ((externalAnnotations = ExternalAnnotationsManager.getInstance(project = owner.getProject()).findExternalAnnotations(owner)) != null) {
            annotations2 = ArrayUtil.mergeArrays(annotations2, externalAnnotations, PsiAnnotation.ARRAY_FACTORY);
        }
        if (withInferred) {
            PsiElement[] inferredAnnotations = InferredAnnotationsManager.getInstance(project).findInferredAnnotations(owner);
            annotations2 = ArrayUtil.mergeArrays(annotations2, inferredAnnotations, PsiAnnotation.ARRAY_FACTORY);
        }
        if (inHierarchy) {
            PsiParameter parameter;
            PsiElement scope;
            if (owner instanceof PsiClass) {
                for (PsiElement psiElement : ((PsiClass)owner).getSupers()) {
                    if (visited == null) {
                        visited = new THashSet();
                    }
                    if (!visited.add(psiElement)) continue;
                    annotations2 = ArrayUtil.mergeArrays(annotations2, AnnotationUtil.getAllAnnotations((PsiModifierListOwner)psiElement, true, (Set<PsiModifierListOwner>)visited, withInferred));
                }
            } else if (owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                PsiClass aClass = method.getContainingClass();
                if (aClass != null) {
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> list2 = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
                    for (HierarchicalMethodSignature superSignature : list2) {
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited == null) {
                            visited = new THashSet();
                        }
                        if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null)) continue;
                        annotations2 = ArrayUtil.mergeArrays(annotations2, AnnotationUtil.getAllAnnotations(superMethod, true, (Set<PsiModifierListOwner>)visited, withInferred));
                    }
                }
            } else if (owner instanceof PsiParameter && (scope = (parameter = (PsiParameter)owner).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiClass psiClass = method.getContainingClass();
                PsiElement parent = parameter.getParent();
                if (psiClass != null && parent instanceof PsiParameterList) {
                    int index = ((PsiParameterList)parent).getParameterIndex(parameter);
                    HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
                    List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
                    PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(psiClass.getProject());
                    for (HierarchicalMethodSignature superSignature : superSignatures) {
                        PsiParameter[] superParameters;
                        PsiMethod superMethod = superSignature.getMethod();
                        if (visited == null) {
                            visited = new THashSet();
                        }
                        if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, owner, null) || index >= (superParameters = superMethod.getParameterList().getParameters()).length) continue;
                        annotations2 = ArrayUtil.mergeArrays(annotations2, AnnotationUtil.getAllAnnotations(superParameters[index], true, (Set<PsiModifierListOwner>)visited, withInferred));
                    }
                }
            }
        }
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/AnnotationUtil", "getAllAnnotations"));
        }
        return annotations2;
    }

    public static boolean isInsideAnnotation(PsiElement element) {
        for (int level = 0; level < 4; ++level) {
            if (element instanceof PsiNameValuePair) {
                return true;
            }
            if ((element = element.getParent()) != null) continue;
            return false;
        }
        return false;
    }

    public static boolean isInferredAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/AnnotationUtil", "isInferredAnnotation"));
        }
        return InferredAnnotationsManager.getInstance(annotation.getProject()).isInferredAnnotation(annotation);
    }

    public static boolean isExternalAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/AnnotationUtil", "isExternalAnnotation"));
        }
        return ExternalAnnotationsManager.getInstance(annotation.getProject()).isExternalAnnotation(annotation);
    }

    @Nullable
    public static String getStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/codeInsight/AnnotationUtil", "getStringAttributeValue"));
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof String ? (String)constValue : null;
    }

    @Nullable
    public static Boolean getBooleanAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/codeInsight/AnnotationUtil", "getBooleanAttributeValue"));
        }
        PsiAnnotationMemberValue attrValue = anno.findAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof Boolean ? (Boolean)constValue : null;
    }

    @Nullable
    public static String getDeclaredStringAttributeValue(@NotNull PsiAnnotation anno, @Nullable String attributeName) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/codeInsight/AnnotationUtil", "getDeclaredStringAttributeValue"));
        }
        PsiAnnotationMemberValue attrValue = anno.findDeclaredAttributeValue(attributeName);
        Object constValue = JavaPsiFacade.getInstance(anno.getProject()).getConstantEvaluationHelper().computeConstantExpression(attrValue);
        return constValue instanceof String ? (String)constValue : null;
    }

    @Nullable
    public static <T extends Annotation> T findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Class<T> annotationClass) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOwner", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy(listOwner, Collections.singleton(annotationClass.getName()));
        if (annotation == null) {
            return null;
        }
        AnnotationInvocationHandler handler = new AnnotationInvocationHandler(annotationClass, annotation);
        Annotation t = (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)handler);
        return (T)t;
    }

    @Nullable
    public static PsiNameValuePair findDeclaredAttribute(@NotNull PsiAnnotation annotation, @NonNls @Nullable(value="null means 'value'") String attributeName) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/AnnotationUtil", "findDeclaredAttribute"));
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : annotation.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Comparing.equal(name, attributeName) && (attributeName != null || !"value".equals(name))) continue;
            return attribute;
        }
        return null;
    }

    public static boolean equal(@Nullable PsiAnnotation a, @Nullable PsiAnnotation b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        String name = a.getQualifiedName();
        if (name == null || !name.equals(b.getQualifiedName())) {
            return false;
        }
        THashMap valueMap1 = new THashMap(2);
        THashMap valueMap2 = new THashMap(2);
        if (!AnnotationUtil.fillValueMap(a.getParameterList(), (Map<String, PsiAnnotationMemberValue>)valueMap1) || !AnnotationUtil.fillValueMap(b.getParameterList(), (Map<String, PsiAnnotationMemberValue>)valueMap2) || valueMap1.size() != valueMap2.size()) {
            return false;
        }
        for (Map.Entry entry : valueMap1.entrySet()) {
            if (AnnotationUtil.equal((PsiAnnotationMemberValue)entry.getValue(), (PsiAnnotationMemberValue)valueMap2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean fillValueMap(PsiAnnotationParameterList parameterList, Map<String, PsiAnnotationMemberValue> valueMap) {
        PsiNameValuePair[] attributes1;
        for (PsiNameValuePair attribute : attributes1 = parameterList.getAttributes()) {
            PsiReference reference = attribute.getReference();
            if (reference == null) {
                return false;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiAnnotationMethod)) {
                return false;
            }
            PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)target;
            PsiAnnotationMemberValue defaultValue = annotationMethod.getDefaultValue();
            PsiAnnotationMemberValue value2 = attribute.getValue();
            if (AnnotationUtil.equal(value2, defaultValue)) continue;
            String name1 = attribute.getName();
            valueMap.put(name1 == null ? "value" : name1, value2);
        }
        return true;
    }

    public static boolean equal(PsiAnnotationMemberValue value1, PsiAnnotationMemberValue value2) {
        if (value1 instanceof PsiArrayInitializerMemberValue && value2 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers2;
            PsiAnnotationMemberValue[] initializers1 = ((PsiArrayInitializerMemberValue)value1).getInitializers();
            if (initializers1.length != (initializers2 = ((PsiArrayInitializerMemberValue)value2).getInitializers()).length) {
                return false;
            }
            for (int i = 0; i < initializers1.length; ++i) {
                if (AnnotationUtil.equal(initializers1[i], initializers2[i])) continue;
                return false;
            }
            return true;
        }
        if (value1 != null && value2 != null) {
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance(value1.getProject()).getConstantEvaluationHelper();
            Object const1 = constantEvaluationHelper.computeConstantExpression(value1);
            Object const2 = constantEvaluationHelper.computeConstantExpression(value2);
            return const1 != null && const1.equals(const2);
        }
        return false;
    }

    public static boolean equal(PsiAnnotation[] annotations1, PsiAnnotation[] annotations2) {
        Map<String, PsiAnnotation> map1 = AnnotationUtil.buildAnnotationMap(annotations1);
        Map<String, PsiAnnotation> map2 = AnnotationUtil.buildAnnotationMap(annotations2);
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, PsiAnnotation> entry : map1.entrySet()) {
            if (AnnotationUtil.equal(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static Map<String, PsiAnnotation> buildAnnotationMap(PsiAnnotation[] annotations2) {
        HashMap<String, PsiAnnotation> map2 = new HashMap<String, PsiAnnotation>();
        for (PsiAnnotation annotation : annotations2) {
            map2.put(annotation.getQualifiedName(), annotation);
        }
        map2.remove("java.lang.Override");
        return map2;
    }

    static {
        SIMPLE_NAMES = new String[]{NOT_NULL_SIMPLE_NAME, NULLABLE_SIMPLE_NAME, NON_NLS_SIMPLE_NAME, PROPERTY_KEY_SIMPLE_NAME, TEST_ONLY_SIMPLE_NAME, "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};
        ALL_ANNOTATIONS = new HashSet<String>(2);
        ALL_ANNOTATIONS.add(NULLABLE);
        ALL_ANNOTATIONS.add(NOT_NULL);
    }
}

