/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.ui.ComponentSettings;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;

public class PowerSaveMode {
    private static final String POWER_SAVE_MODE = "power.save.mode";
    private boolean myEnabled = PropertiesComponent.getInstance().getBoolean("power.save.mode");
    private final MessageBus myBus;
    public static final Topic<Listener> TOPIC = Topic.create("PowerSaveMode.Listener", Listener.class);

    public PowerSaveMode(MessageBus bus) {
        this.myBus = bus;
        ComponentSettings.getInstance().setPowerSaveModeEnabled(this.myEnabled);
    }

    public static boolean isEnabled() {
        return ServiceManager.getService(PowerSaveMode.class).myEnabled;
    }

    public static void setEnabled(boolean value2) {
        PowerSaveMode instance = ServiceManager.getService(PowerSaveMode.class);
        if (instance.myEnabled != value2) {
            instance.myEnabled = value2;
            instance.myBus.syncPublisher(TOPIC).powerSaveStateChanged();
            PropertiesComponent.getInstance().setValue(POWER_SAVE_MODE, value2);
            ComponentSettings.getInstance().setPowerSaveModeEnabled(value2);
        }
    }

    public static interface Listener {
        public void powerSaveStateChanged();
    }
}

