/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class FilterLexer
extends DelegateLexer {
    private final Filter myFilter;
    private final boolean[] myStateFilter;
    private int myPrevTokenEnd;

    public FilterLexer(Lexer original, Filter filter, boolean[] stateFilter) {
        super(original);
        this.myFilter = filter;
        this.myStateFilter = stateFilter;
    }

    public FilterLexer(Lexer original, Filter filter) {
        this(original, filter, null);
    }

    public Lexer getOriginal() {
        return this.getDelegate();
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lexer/FilterLexer", "start"));
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.myPrevTokenEnd = -1;
        this.locateToken();
    }

    @Override
    public void advance() {
        this.myPrevTokenEnd = this.getDelegate().getTokenEnd();
        super.advance();
        this.locateToken();
    }

    public int getPrevTokenEnd() {
        return this.myPrevTokenEnd;
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        LexerPosition lexerPosition = this.getDelegate().getCurrentPosition();
        if (lexerPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lexer/FilterLexer", "getCurrentPosition"));
        }
        return lexerPosition;
    }

    @Override
    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/lexer/FilterLexer", "restore"));
        }
        this.getDelegate().restore(position);
        this.myPrevTokenEnd = -1;
    }

    public final void locateToken() {
        Lexer delegate;
        IElementType tokenType;
        while ((tokenType = (delegate = this.getDelegate()).getTokenType()) != null && (this.myFilter != null && this.myFilter.reject(tokenType) || this.myStateFilter != null && this.myStateFilter[delegate.getState()])) {
            delegate.advance();
        }
    }

    public static final class SetFilter
    implements Filter {
        private final TokenSet mySet;

        public SetFilter(TokenSet set) {
            this.mySet = set;
        }

        @Override
        public boolean reject(IElementType type2) {
            return this.mySet.contains(type2);
        }
    }

    public static interface Filter {
        public boolean reject(IElementType var1);
    }
}

