/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DefaultLogger
extends Logger {
    public DefaultLogger(String category) {
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(String message2) {
    }

    @Override
    public void debug(Throwable t) {
    }

    @Override
    public void debug(@NonNls String message2, Throwable t) {
    }

    @Override
    public void info(String message2) {
    }

    @Override
    public void info(String message2, Throwable t) {
    }

    @Override
    public void warn(@NonNls String message2, @Nullable Throwable t) {
        t = DefaultLogger.checkException(t);
        System.err.println("WARN: " + message2);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message2, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/openapi/diagnostic/DefaultLogger", "error"));
        }
        t = DefaultLogger.checkException(t);
        message2 = message2 + DefaultLogger.attachmentsToString(t);
        System.err.println("ERROR: " + message2);
        if (t != null) {
            t.printStackTrace(System.err);
        }
        if (details.length > 0) {
            System.out.println("details: ");
            for (String detail : details) {
                System.out.println(detail);
            }
        }
        AssertionError error = new AssertionError((Object)message2);
        ((Throwable)((Object)error)).initCause(t);
        throw error;
    }

    @Override
    public void setLevel(Level level) {
    }

    public static String attachmentsToString(@Nullable Throwable t) {
        Throwable rootCause;
        Throwable throwable = rootCause = t == null ? null : ExceptionUtil.getRootCause(t);
        if (rootCause instanceof ExceptionWithAttachments) {
            return "\nAttachments:" + StringUtil.join(((ExceptionWithAttachments)((Object)rootCause)).getAttachments(), ATTACHMENT_TO_STRING, "\n----\n");
        }
        return "";
    }
}

