/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.event;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;

public class DocumentEventImpl
extends DocumentEvent {
    private final int myOffset;
    private final CharSequence myOldString;
    private final int myOldLength;
    private final CharSequence myNewString;
    private final int myNewLength;
    private final long myOldTimeStamp;
    private final boolean myIsWholeDocReplaced;
    private Diff.Change myChange;
    private static final Diff.Change TOO_BIG_FILE = new Diff.Change(0, 0, 0, 0, null);
    private final int myInitialStartOffset;
    private final int myInitialOldLength;

    /*
     * WARNING - void declaration
     */
    public DocumentEventImpl(@NotNull Document document, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp, boolean bl) {
        void wholeTextReplaced;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        if (oldString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldString", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        this(document, offset, oldString, newString, oldTimeStamp, (boolean)wholeTextReplaced, offset, oldString.length());
    }

    /*
     * WARNING - void declaration
     */
    public DocumentEventImpl(@NotNull Document document, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp, boolean wholeTextReplaced, int initialStartOffset, int n) {
        void initialOldLength;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        if (oldString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldString", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "<init>"));
        }
        super(document);
        this.myOffset = offset;
        this.myOldString = oldString;
        this.myOldLength = oldString.length();
        this.myNewString = newString;
        this.myNewLength = newString.length();
        this.myInitialStartOffset = initialStartOffset;
        this.myInitialOldLength = initialOldLength;
        this.myOldTimeStamp = oldTimeStamp;
        boolean bl = this.myIsWholeDocReplaced = this.getDocument().getTextLength() != 0 && wholeTextReplaced;
        assert (initialStartOffset >= 0) : initialStartOffset;
        assert (initialOldLength >= 0) : (int)initialOldLength;
        assert (initialStartOffset + initialOldLength <= document.getTextLength()) : "initialStartOffset = " + initialStartOffset + "; initialOldLength = " + (int)initialOldLength + ";document.getTextLength() = " + document.getTextLength();
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public int getOldLength() {
        return this.myOldLength;
    }

    @Override
    public int getNewLength() {
        return this.myNewLength;
    }

    @Override
    @NotNull
    public CharSequence getOldFragment() {
        CharSequence charSequence = this.myOldString;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "getOldFragment"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public CharSequence getNewFragment() {
        CharSequence charSequence = this.myNewString;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "getNewFragment"));
        }
        return charSequence;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = (Document)this.getSource();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/event/DocumentEventImpl", "getDocument"));
        }
        return document;
    }

    public int getInitialStartOffset() {
        return this.myInitialStartOffset;
    }

    public int getInitialOldLength() {
        return this.myInitialOldLength;
    }

    @Override
    public long getOldTimeStamp() {
        return this.myOldTimeStamp;
    }

    @Override
    public String toString() {
        return "DocumentEventImpl[myOffset=" + this.myOffset + ", myOldLength=" + this.myOldLength + ", myNewLength=" + this.myNewLength + ", myOldString='" + this.myOldString + "', myNewString='" + this.myNewString + "']" + (this.isWholeTextReplaced() ? " Whole." : ".");
    }

    @Override
    public boolean isWholeTextReplaced() {
        return this.myIsWholeDocReplaced;
    }

    public int translateLineViaDiff(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        int startLine = this.getDocument().getLineNumber(this.getOffset());
        int newLine = line -= startLine;
        while (change != null && line >= change.line0) {
            if (line >= change.line0 + change.deleted) {
                newLine += change.inserted - change.deleted;
            } else {
                int delta = Math.min(change.inserted, line - change.line0);
                newLine = change.line1 + delta;
                break;
            }
            change = change.link;
        }
        return newLine + startLine;
    }

    public int translateLineViaDiffStrict(int line) throws FilesTooBigForDiffException {
        Diff.Change change = this.reBuildDiffIfNeeded();
        if (change == null) {
            return line;
        }
        int startLine = this.getDocument().getLineNumber(this.getOffset());
        if (line < startLine) {
            return line;
        }
        int translatedRelative = Diff.translateLine(change, line - startLine);
        return translatedRelative < 0 ? -1 : translatedRelative + startLine;
    }

    private Diff.Change reBuildDiffIfNeeded() throws FilesTooBigForDiffException {
        if (this.myChange == TOO_BIG_FILE) {
            throw new FilesTooBigForDiffException(0);
        }
        if (this.myChange == null) {
            try {
                this.myChange = Diff.buildChanges(this.myOldString, this.myNewString);
            }
            catch (FilesTooBigForDiffException e) {
                this.myChange = TOO_BIG_FILE;
                throw e;
            }
        }
        return this.myChange;
    }
}

