/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.markup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.EffectType;
import java.awt.Color;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextAttributes
implements Cloneable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.markup.TextAttributes");
    public static final TextAttributes ERASE_MARKER = new TextAttributes();
    public static final TextAttributes USE_INHERITED_MARKER = new TextAttributes();
    @NotNull
    private AttributesFlyweight myAttrs;

    @Contract(value="!null, !null -> !null")
    public static TextAttributes merge(TextAttributes under, TextAttributes above) {
        if (under == null) {
            return above;
        }
        if (above == null) {
            return under;
        }
        TextAttributes attrs = under.clone();
        if (above.getBackgroundColor() != null) {
            attrs.setBackgroundColor(above.getBackgroundColor());
        }
        if (above.getForegroundColor() != null) {
            attrs.setForegroundColor(above.getForegroundColor());
        }
        attrs.setFontType(above.getFontType() | under.getFontType());
        if (above.getEffectColor() != null) {
            attrs.setEffectColor(above.getEffectColor());
            attrs.setEffectType(above.getEffectType());
        }
        return attrs;
    }

    public TextAttributes() {
        this(null, null, null, EffectType.BOXED, 0);
    }

    private TextAttributes(@NotNull AttributesFlyweight attributesFlyweight) {
        if (attributesFlyweight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributesFlyweight", "com/intellij/openapi/editor/markup/TextAttributes", "<init>"));
        }
        this.myAttrs = attributesFlyweight;
    }

    public TextAttributes(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/markup/TextAttributes", "<init>"));
        }
        this.readExternal(element);
    }

    public TextAttributes(@Nullable Color foregroundColor, @Nullable Color backgroundColor, @Nullable Color effectColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.setAttributes(foregroundColor, backgroundColor, effectColor, null, effectType, fontType);
    }

    public void setAttributes(Color foregroundColor, Color backgroundColor, Color effectColor, Color errorStripeColor, EffectType effectType, @JdkConstants.FontStyle int fontType) {
        this.myAttrs = AttributesFlyweight.create(foregroundColor, backgroundColor, fontType, effectColor, effectType, errorStripeColor);
    }

    public boolean isEmpty() {
        return this.getForegroundColor() == null && this.getBackgroundColor() == null && this.getEffectColor() == null && this.getFontType() == 0;
    }

    public void reset() {
        this.setForegroundColor(null);
        this.setBackgroundColor(null);
        this.setEffectColor(null);
        this.setFontType(0);
    }

    @NotNull
    public AttributesFlyweight getFlyweight() {
        AttributesFlyweight attributesFlyweight = this.myAttrs;
        if (attributesFlyweight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/TextAttributes", "getFlyweight"));
        }
        return attributesFlyweight;
    }

    @NotNull
    public static TextAttributes fromFlyweight(@NotNull AttributesFlyweight flyweight) {
        if (flyweight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flyweight", "com/intellij/openapi/editor/markup/TextAttributes", "fromFlyweight"));
        }
        TextAttributes f = new TextAttributes();
        f.myAttrs = flyweight;
        TextAttributes textAttributes = f;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/markup/TextAttributes", "fromFlyweight"));
        }
        return textAttributes;
    }

    public Color getForegroundColor() {
        return this.myAttrs.getForeground();
    }

    public void setForegroundColor(Color color) {
        this.myAttrs = this.myAttrs.withForeground(color);
    }

    public Color getBackgroundColor() {
        return this.myAttrs.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.myAttrs = this.myAttrs.withBackground(color);
    }

    public Color getEffectColor() {
        return this.myAttrs.getEffectColor();
    }

    public void setEffectColor(Color color) {
        this.myAttrs = this.myAttrs.withEffectColor(color);
    }

    public Color getErrorStripeColor() {
        return this.myAttrs.getErrorStripeColor();
    }

    public void setErrorStripeColor(Color color) {
        this.myAttrs = this.myAttrs.withErrorStripeColor(color);
    }

    public EffectType getEffectType() {
        return this.myAttrs.getEffectType();
    }

    public void setEffectType(EffectType effectType) {
        this.myAttrs = this.myAttrs.withEffectType(effectType);
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myAttrs.getFontType();
    }

    public void setFontType(@JdkConstants.FontStyle int type2) {
        if (type2 < 0 || type2 > 3) {
            LOG.error("Wrong font type: " + type2);
            type2 = 0;
        }
        this.myAttrs = this.myAttrs.withFontType(type2);
    }

    public TextAttributes clone() {
        return new TextAttributes(this.myAttrs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        return this.myAttrs == ((TextAttributes)obj).myAttrs;
    }

    public int hashCode() {
        return this.myAttrs.hashCode();
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/markup/TextAttributes", "readExternal"));
        }
        this.myAttrs = AttributesFlyweight.create(element);
    }

    public void writeExternal(Element element) {
        this.myAttrs.writeExternal(element);
    }

    public String toString() {
        return "[" + this.getForegroundColor() + "," + this.getBackgroundColor() + "," + this.getFontType() + "," + (Object)((Object)this.getEffectType()) + "," + this.getEffectColor() + "," + this.getErrorStripeColor() + "]";
    }
}

