/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.BitUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.DefaultJDOMExternalizer");

    private DefaultJDOMExternalizer() {
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode) throws WriteExternalException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        DefaultJDOMExternalizer.writeExternal(data, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode, @Nullable(value="null means all elements accepted") JDOMFilter filter) throws WriteExternalException {
        Field[] fields;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        for (Field field : fields = data.getClass().getFields()) {
            Element element;
            String value2;
            block25: {
                int modifiers;
                if (field.getName().indexOf(36) >= 0 || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.getAnnotation(Transient.class) != null) continue;
                field.setAccessible(true);
                Class<?> type2 = field.getType();
                if (filter != null && !filter.isAccept(field) || field.getDeclaringClass().getAnnotation(Transient.class) != null) continue;
                value2 = null;
                try {
                    if (type2.isPrimitive()) {
                        if (type2.equals(Byte.TYPE)) {
                            value2 = Byte.toString(field.getByte(data));
                        } else if (type2.equals(Short.TYPE)) {
                            value2 = Short.toString(field.getShort(data));
                        } else if (type2.equals(Integer.TYPE)) {
                            value2 = Integer.toString(field.getInt(data));
                        } else if (type2.equals(Long.TYPE)) {
                            value2 = Long.toString(field.getLong(data));
                        } else if (type2.equals(Float.TYPE)) {
                            value2 = Float.toString(field.getFloat(data));
                        } else if (type2.equals(Double.TYPE)) {
                            value2 = Double.toString(field.getDouble(data));
                        } else if (type2.equals(Character.TYPE)) {
                            value2 = String.valueOf(field.getChar(data));
                        } else {
                            if (!type2.equals(Boolean.TYPE)) continue;
                            value2 = Boolean.toString(field.getBoolean(data));
                        }
                        break block25;
                    }
                    if (type2.equals(String.class)) {
                        value2 = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data));
                        break block25;
                    }
                    if (type2.isEnum()) {
                        value2 = field.get(data).toString();
                        break block25;
                    }
                    if (type2.equals(Color.class)) {
                        Color color = (Color)field.get(data);
                        if (color != null) {
                            value2 = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block25;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                        element = new Element("option");
                        parentNode.addContent(element);
                        element.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type2);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element = new Element("option");
            parentNode.addContent(element);
            element.setAttribute("name", field.getName());
            if (value2 == null) continue;
            element.setAttribute("value", value2);
        }
    }

    @Nullable
    static String filterXMLCharacters(String value2) {
        if (value2 != null) {
            StringBuilder builder = null;
            for (int i = 0; i < value2.length(); ++i) {
                char c = value2.charAt(i);
                if (Verifier.isXMLCharacter((int)c)) {
                    if (builder == null) continue;
                    builder.append(c);
                    continue;
                }
                if (builder != null) continue;
                builder = new StringBuilder(value2.length() + 5);
                builder.append(value2, 0, i);
            }
            if (builder != null) {
                value2 = builder.toString();
            }
        }
        return value2;
    }

    public static void readExternal(@NotNull Object data, Element parentNode) throws InvalidDataException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/util/DefaultJDOMExternalizer", "readExternal"));
        }
        if (parentNode == null) {
            return;
        }
        block15: for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                List children;
                Object value2;
                Field field = data.getClass().getField(fieldName);
                Class<?> type2 = field.getType();
                int modifiers = field.getModifiers();
                if (!BitUtil.isSet(modifiers, 1) || BitUtil.isSet(modifiers, 8)) continue;
                field.setAccessible(true);
                if (BitUtil.isSet(modifiers, 16)) {
                    value2 = field.get(data);
                    if (!JDOMExternalizable.class.isInstance(value2)) continue;
                    children = e.getChildren("value");
                    for (Object child : children) {
                        Element valueTag = (Element)child;
                        ((JDOMExternalizable)value2).readExternal(valueTag);
                    }
                    continue;
                }
                value2 = e.getAttributeValue("value");
                if (type2.isPrimitive()) {
                    if (value2 == null) continue;
                    if (type2.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data, Byte.parseByte((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Short.TYPE)) {
                        try {
                            field.setShort(data, Short.parseShort((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value2);
                        field.setInt(data, i);
                        continue;
                    }
                    if (type2.equals(Long.TYPE)) {
                        try {
                            field.setLong(data, Long.parseLong((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data, Float.parseFloat((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data, Double.parseDouble((String)value2));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Character.TYPE)) {
                        if (((String)value2).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data, ((String)value2).charAt(0));
                        continue;
                    }
                    if (type2.equals(Boolean.TYPE)) {
                        if (((String)value2).equals("true")) {
                            field.setBoolean(data, true);
                            continue;
                        }
                        if (((String)value2).equals("false")) {
                            field.setBoolean(data, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type2.isEnum()) {
                    for (Object enumValue : type2.getEnumConstants()) {
                        if (!enumValue.toString().equals(value2)) continue;
                        field.set(data, enumValue);
                        continue block15;
                    }
                    continue;
                }
                if (type2.equals(String.class)) {
                    field.set(data, value2);
                    continue;
                }
                if (type2.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value2);
                    field.set(data, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                    children = e.getChildren("value");
                    if (children.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    for (Element element : children) {
                        object = (JDOMExternalizable)type2.newInstance();
                        object.readExternal(element);
                    }
                    field.set(data, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type2);
            }
            catch (NoSuchFieldException ex) {
                LOG.debug("No field '" + fieldName + "' in " + data.getClass(), ex);
            }
            catch (SecurityException ex) {
                throw new InvalidDataException();
            }
            catch (IllegalAccessException ex) {
                throw new InvalidDataException(ex);
            }
            catch (InstantiationException ex) {
                throw new InvalidDataException();
            }
        }
    }

    public static int toInt(@NotNull String value2) throws InvalidDataException {
        int i;
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/DefaultJDOMExternalizer", "toInt"));
        }
        try {
            i = Integer.parseInt(value2);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException(value2, ex);
        }
        return i;
    }

    public static Color toColor(@Nullable String value2) throws InvalidDataException {
        Color color;
        if (value2 == null) {
            color = null;
        } else {
            try {
                int rgb = Integer.parseInt(value2, 16);
                color = new Color(rgb);
            }
            catch (NumberFormatException ex) {
                LOG.debug("Wrong color value: " + value2, ex);
                throw new InvalidDataException("Wrong color value: " + value2, ex);
            }
        }
        return color;
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }
}

