/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;

public abstract class NotNullLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("NotNullLazyValue");
    private T myValue;

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        T result = this.myValue;
        if (result == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            result = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result;
            }
        }
        T t = result;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue", "getValue"));
        }
        return t;
    }

    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createConstantValue(final @NotNull T value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/NotNullLazyValue", "createConstantValue"));
        }
        NotNullLazyValue notNullLazyValue = new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object object = value2;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue$1", "compute"));
                }
                return object;
            }
        };
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue", "createConstantValue"));
        }
        return notNullLazyValue;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createValue(final @NotNull NotNullFactory<T> value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/NotNullLazyValue", "createValue"));
        }
        NotNullLazyValue notNullLazyValue = new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t = value2.create();
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue$2", "compute"));
                }
                return t;
            }
        };
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/NotNullLazyValue", "createValue"));
        }
        return notNullLazyValue;
    }
}

