/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.text.StringFactory;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamUtil {
    private static final Logger LOG = Logger.getInstance(StreamUtil.class);

    private StreamUtil() {
    }

    public static int copyStreamContent(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        int count;
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/StreamUtil", "copyStreamContent"));
        }
        if (outputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "com/intellij/openapi/util/io/StreamUtil", "copyStreamContent"));
        }
        byte[] buffer = new byte[10240];
        int total = 0;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            total += count;
        }
        return total;
    }

    @NotNull
    public static byte[] loadFromStream(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/StreamUtil", "loadFromStream"));
        }
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        try {
            StreamUtil.copyStreamContent(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
        byte[] byArray = outputStream.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "loadFromStream"));
        }
        return byArray;
    }

    @NotNull
    public static String readText(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        byte[] data = StreamUtil.loadFromStream(inputStream);
        String string = new String(data);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        return string;
    }

    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull String encoding) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        byte[] data = StreamUtil.loadFromStream(inputStream);
        String string = new String(data, encoding);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        return string;
    }

    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull Charset encoding) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        byte[] data = StreamUtil.loadFromStream(inputStream);
        String string = new String(data, encoding);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        return string;
    }

    @NotNull
    public static String convertSeparators(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/io/StreamUtil", "convertSeparators"));
        }
        String string = StringFactory.createShared(StreamUtil.convertSeparators(s.toCharArray()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "convertSeparators"));
        }
        return string;
    }

    @NotNull
    public static char[] readTextAndConvertSeparators(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/io/StreamUtil", "readTextAndConvertSeparators"));
        }
        char[] buffer = StreamUtil.readText(reader);
        char[] cArray = StreamUtil.convertSeparators(buffer);
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "readTextAndConvertSeparators"));
        }
        return cArray;
    }

    @NotNull
    private static char[] convertSeparators(@NotNull char[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/io/StreamUtil", "convertSeparators"));
        }
        int dst = 0;
        int prev = 32;
        for (int n : buffer) {
            switch (n) {
                case 13: {
                    buffer[dst++] = 10;
                    break;
                }
                case 10: {
                    if (prev == 13) break;
                    buffer[dst++] = 10;
                    break;
                }
                default: {
                    buffer[dst++] = n;
                }
            }
            prev = n;
        }
        if (dst == buffer.length) {
            if (buffer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "convertSeparators"));
            }
            return buffer;
        }
        char[] result = new char[dst];
        System.arraycopy(buffer, 0, result, 0, result.length);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "convertSeparators"));
        }
        return result;
    }

    @NotNull
    public static String readTextFrom(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/io/StreamUtil", "readTextFrom"));
        }
        String string = StringFactory.createShared(StreamUtil.readText(reader));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "readTextFrom"));
        }
        return string;
    }

    @NotNull
    private static char[] readText(@NotNull Reader reader) throws IOException {
        int read;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[2048];
        while ((read = reader.read(buffer)) >= 0) {
            writer.write(buffer, 0, read);
        }
        char[] cArray = writer.toCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        return cArray;
    }

    public static void closeStream(@Nullable Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }
}

