/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

class Pluralizer {
    static final Pluralizer PLURALIZER;
    private final Map<String, String> irregularSingles = ContainerUtil.newTroveMap(CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final Map<String, String> irregularPlurals = ContainerUtil.newTroveMap(CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final Set<String> uncountables = ContainerUtil.newTroveSet(CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final List<Pair<Pattern, String>> pluralRules = ContainerUtil.newArrayList();
    private final List<Pair<Pattern, String>> singularRules = ContainerUtil.newArrayList();

    Pluralizer() {
    }

    static String restoreCase(String word, String result) {
        char lc;
        char uc;
        char wc;
        int i;
        if (word == null || result == null || word == result) {
            return result;
        }
        int len = Math.min(result.length(), word.length());
        if (len == 0) {
            return result;
        }
        char[] chars = result.toCharArray();
        for (i = 0; i < len; ++i) {
            wc = word.charAt(i);
            if (chars[i] == wc && i != len - 1) continue;
            uc = Character.toUpperCase(chars[i]);
            lc = Character.toLowerCase(chars[i]);
            if (wc != lc && wc != uc) break;
            chars[i] = wc;
        }
        if (i < chars.length && (uc = Character.toUpperCase(wc = word.charAt(i - 1))) != (lc = Character.toLowerCase(wc))) {
            while (i < chars.length) {
                chars[i] = wc == uc ? Character.toUpperCase(chars[i]) : Character.toLowerCase(chars[i]);
                ++i;
            }
        }
        return new String(chars);
    }

    private String sanitizeWord(String word, List<Pair<Pattern, String>> rules) {
        if (StringUtil.isEmpty(word) || this.uncountables.contains(word)) {
            return word;
        }
        int len = rules.size();
        while (--len > -1) {
            Pair<Pattern, String> rule = rules.get(len);
            Matcher matcher = ((Pattern)rule.first).matcher(word);
            if (!matcher.find()) continue;
            return matcher.replaceFirst((String)rule.second);
        }
        return null;
    }

    private String replaceWord(String word, Map<String, String> replaceMap, Map<String, String> keepMap, List<Pair<Pattern, String>> rules) {
        if (StringUtil.isEmpty(word)) {
            return word;
        }
        if (keepMap.containsKey(word)) {
            return word;
        }
        String replacement = replaceMap.get(word);
        if (replacement != null) {
            return replacement;
        }
        return this.sanitizeWord(word, rules);
    }

    public String pluralize(String word, int count, boolean inclusive) {
        String pluralized = count == 1 ? this.singular(word) : this.plural(word);
        return (inclusive ? count + " " : "") + StringUtil.notNullize(pluralized, word);
    }

    @Nullable
    public String plural(@Nullable String word) {
        return Pluralizer.restoreCase(word, this.replaceWord(word, this.irregularSingles, this.irregularPlurals, this.pluralRules));
    }

    @Nullable
    public String singular(@Nullable String word) {
        return Pluralizer.restoreCase(word, this.replaceWord(word, this.irregularPlurals, this.irregularSingles, this.singularRules));
    }

    private static Pattern sanitizeRule(String rule) {
        return Pattern.compile(rule.startsWith("/") ? rule.substring(1) : "^" + rule + "$", 2);
    }

    protected void addPluralRule(String rule, String replacement) {
        this.pluralRules.add(Pair.create(Pluralizer.sanitizeRule(rule), replacement));
    }

    protected void addSingularRule(String rule, String replacement) {
        this.singularRules.add(Pair.create(Pluralizer.sanitizeRule(rule), replacement));
    }

    protected void addUncountableRule(String word) {
        if (!word.startsWith("/")) {
            this.uncountables.add(word);
        } else {
            this.addPluralRule(word, "$0");
            this.addSingularRule(word, "$0");
        }
    }

    protected void addIrregularRule(String single, String plural) {
        this.irregularSingles.put(single, plural);
        this.irregularPlurals.put(plural, single);
    }

    static {
        final Pluralizer pluralizer = new Pluralizer();
        JBIterable.of({"this", "these"}, {"that", "those"}, {"echo", "echoes"}, {"dingo", "dingoes"}, {"volcano", "volcanoes"}, {"tornado", "tornadoes"}, {"torpedo", "torpedoes"}, {"genus", "genera"}, {"viscus", "viscera"}, {"stigma", "stigmata"}, {"stoma", "stomata"}, {"dogma", "dogmata"}, {"lemma", "lemmata"}, {"anathema", "anathemata"}, {"ox", "oxen"}, {"axe", "axes"}, {"die", "dice"}, {"yes", "yeses"}, {"foot", "feet"}, {"eave", "eaves"}, {"goose", "geese"}, {"tooth", "teeth"}, {"quiz", "quizzes"}, {"human", "humans"}, {"proof", "proofs"}, {"carve", "carves"}, {"valve", "valves"}, {"looey", "looies"}, {"thief", "thieves"}, {"groove", "grooves"}, {"pickaxe", "pickaxes"}, {"whiskey", "whiskies"}).consumeEach(new Consumer<String[]>(){

            @Override
            public void consume(String[] o) {
                pluralizer.addIrregularRule(o[0], o[1]);
            }
        });
        JBIterable.of({"/s?$", "s"}, {"/([^aeiou]ese)$", "$1"}, {"/(ax|test)is$", "$1es"}, {"/(alias|[^aou]us|tlas|gas|ris)$", "$1es"}, {"/(e[mn]u)s?$", "$1s"}, {"/([^l]ias|[aeiou]las|[emjzr]as|[iu]am)$", "$1"}, {"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1i"}, {"/(alumn|alg|vertebr)(?:a|ae)$", "$1ae"}, {"/(seraph|cherub)(?:im)?$", "$1im"}, {"/(her|at|gr)o$", "$1oes"}, {"/(agend|addend|millenni|medi|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$", "$1a"}, {"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$", "$1a"}, {"/sis$", "ses"}, {"/(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$", "$1$2ves"}, {"/([^aeiouy]|qu)y$", "$1ies"}, {"/([^ch][ieo][ln])ey$", "$1ies"}, {"/(x|ch|ss|sh|zz)$", "$1es"}, {"/(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$", "$1ices"}, {"/(m|l)(?:ice|ouse)$", "$1ice"}, {"/(pe)(?:rson|ople)$", "$1ople"}, {"/(child)(?:ren)?$", "$1ren"}, {"/eaux$", "$0"}, {"/m[ae]n$", "men"}).consumeEach(new Consumer<String[]>(){

            @Override
            public void consume(String[] o) {
                pluralizer.addPluralRule(o[0], o[1]);
            }
        });
        JBIterable.of({"/(.)s$", "$1"}, {"/([^aeiou]s)es$", "$1"}, {"/((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)(?:sis|ses)$", "$1sis"}, {"/(^analy)(?:sis|ses)$", "$1sis"}, {"/(wi|kni|(?:after|half|high|low|mid|non|night|[^\\w]|^)li)ves$", "$1fe"}, {"/(ar|(?:wo|[ae])l|[eo][ao])ves$", "$1f"}, {"/ies$", "y"}, {"/\\b([pl]|zomb|(?:neck|cross)?t|coll|faer|food|gen|goon|group|lass|talk|goal|cut)ies$", "$1ie"}, {"/\\b(mon|smil)ies$", "$1ey"}, {"/(m|l)ice$", "$1ouse"}, {"/(seraph|cherub)im$", "$1"}, {"/(x|ch|.ss|sh|zz|tto|go|cho|alias|[^aou]us|tlas|gas|(?:her|at|gr)o|ris)(?:es)?$", "$1"}, {"/(e[mn]u)s?$", "$1"}, {"/(cookie|movie|twelve)s$", "$1"}, {"/(cris|test|diagnos)(?:is|es)$", "$1is"}, {"/(alumn|syllab|octop|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1us"}, {"/(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$", "$1um"}, {"/(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$", "$1on"}, {"/(alumn|alg|vertebr)ae$", "$1a"}, {"/(cod|mur|sil|vert|ind)ices$", "$1ex"}, {"/(matr|append)ices$", "$1ix"}, {"/(pe)(rson|ople)$", "$1rson"}, {"/(child)ren$", "$1"}, {"/(eau)x?$", "$1"}, {"/men$", "man"}).consumeEach(new Consumer<String[]>(){

            @Override
            public void consume(String[] o) {
                pluralizer.addSingularRule(o[0], o[1]);
            }
        });
        JBIterable.of("advice", "adulthood", "agenda", "aid", "alcohol", "ammo", "athletics", "bison", "blood", "bream", "buffalo", "butter", "carp", "cash", "chassis", "chess", "clothing", "commerce", "cod", "cooperation", "corps", "digestion", "debris", "diabetes", "energy", "equipment", "elk", "excretion", "expertise", "flounder", "fun", "gallows", "garbage", "graffiti", "headquarters", "health", "herpes", "highjinks", "homework", "housework", "information", "jeans", "justice", "kudos", "labour", "literature", "machinery", "mackerel", "mail", "media", "mews", "moose", "music", "news", "pike", "plankton", "pliers", "pollution", "premises", "rain", "research", "rice", "salmon", "scissors", "series", "sewage", "shambles", "shrimp", "species", "staff", "swine", "trout", "traffic", "transportation", "tuna", "wealth", "welfare", "whiting", "wildebeest", "wildlife", "you", "/pox$", "/ois$", "/deer$", "/fish$", "/sheep$", "/measles$", "/[^aeiou]ese$/i").consumeEach(new Consumer<String>(){

            @Override
            public void consume(String o) {
                pluralizer.addUncountableRule(o);
            }
        });
        PLURALIZER = pluralizer;
    }
}

