/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaParserFacadeImpl
implements PsiJavaParserFacade {
    protected final PsiManager myManager;
    private static final String DUMMY_FILE_NAME = "_Dummy_." + JavaFileType.INSTANCE.getDefaultExtension();
    private static final JavaParserUtil.ParserWrapper ANNOTATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper PARAMETER = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseParameter(builder, true, false);
        }
    };
    private static final JavaParserUtil.ParserWrapper RESOURCE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseResource(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper TYPE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseType(builder, 23);
        }
    };
    public static final JavaParserUtil.ParserWrapper REFERENCE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
        }
    };
    public static final JavaParserUtil.ParserWrapper DIAMOND_REF = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseJavaCodeReference(builder, false, true, false, true);
        }
    };
    public static final JavaParserUtil.ParserWrapper STATIC_IMPORT_REF = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseImportCodeReference(builder, true);
        }
    };
    private static final JavaParserUtil.ParserWrapper TYPE_PARAMETER = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getReferenceParser().parseTypeParameter(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper DECLARATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parse(builder, DeclarationParser.Context.CLASS);
        }
    };
    private static final JavaParserUtil.ParserWrapper CODE_BLOCK = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseCodeBlockDeep(builder, true);
        }
    };
    private static final JavaParserUtil.ParserWrapper STATEMENT = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getStatementParser().parseStatement(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper EXPRESSION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getExpressionParser().parse(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper ENUM_CONSTANT = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseEnumConstant(builder);
        }
    };
    private static final JavaParserUtil.ParserWrapper MODULE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getModuleParser().parse(builder);
        }
    };
    private static final Map<String, PsiPrimitiveType> PRIMITIVE_TYPES = new HashMap<String, PsiPrimitiveType>();

    public PsiJavaParserFacadeImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createAnnotationFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, ANNOTATION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation '" + text + "'");
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)element;
        if (psiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createAnnotationFromText"));
        }
        return psiAnnotation;
    }

    @Override
    @NotNull
    public PsiDocTag createDocTagFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocTagFromText"));
        }
        PsiDocTag psiDocTag = this.createDocCommentFromText(StringUtil.join("/**\n", text, "\n */")).getTags()[0];
        if (psiDocTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocTagFromText"));
        }
        return psiDocTag;
    }

    @Override
    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String docCommentText) throws IncorrectOperationException {
        if (docCommentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docCommentText", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocCommentFromText"));
        }
        PsiDocComment psiDocComment = this.createDocCommentFromText(docCommentText, null);
        if (psiDocComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocCommentFromText"));
        }
        return psiDocComment;
    }

    @Override
    @NotNull
    public PsiDocComment createDocCommentFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocCommentFromText"));
        }
        PsiMethod method = this.createMethodFromText(text.trim() + "void m();", context);
        PsiDocComment comment = method.getDocComment();
        if (comment == null) {
            throw new IncorrectOperationException("Incorrect comment '" + text + "'");
        }
        PsiDocComment psiDocComment = comment;
        if (psiDocComment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createDocCommentFromText"));
        }
        return psiDocComment;
    }

    @Override
    @NotNull
    public PsiClass createClassFromText(@NotNull String body2, @Nullable PsiElement context) throws IncorrectOperationException {
        if (body2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createClassFromText"));
        }
        PsiJavaFile aFile = this.createDummyJavaFile(StringUtil.join("class _Dummy_ {\n", body2, "\n}"));
        PsiClass[] classes2 = aFile.getClasses();
        if (classes2.length != 1) {
            throw new IncorrectOperationException("Incorrect class '" + body2 + "'");
        }
        PsiClass psiClass = classes2[0];
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createClassFromText"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createFieldFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, DECLARATION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiField)) {
            throw new IncorrectOperationException("Incorrect field '" + text + "'");
        }
        PsiField psiField = (PsiField)element;
        if (psiField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createFieldFromText"));
        }
        return psiField;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text, @Nullable PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createMethodFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, DECLARATION, level), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiMethod)) {
            throw PsiJavaParserFacadeImpl.newException("Incorrect method '" + text + "'", holder);
        }
        PsiMethod psiMethod = (PsiMethod)element;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createMethodFromText"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public final PsiMethod createMethodFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createMethodFromText"));
        }
        LanguageLevel level = LanguageLevelProjectExtension.getInstance(this.myManager.getProject()).getLanguageLevel();
        PsiMethod psiMethod = this.createMethodFromText(text, context, level);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createMethodFromText"));
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createParameterFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, PARAMETER, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiParameter)) {
            throw new IncorrectOperationException("Incorrect parameter '" + text + "'");
        }
        PsiParameter psiParameter = (PsiParameter)element;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createParameterFromText"));
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiResourceVariable createResourceFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createResourceFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, RESOURCE, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiResourceVariable)) {
            throw new IncorrectOperationException("Incorrect resource '" + text + "'");
        }
        PsiResourceVariable psiResourceVariable = (PsiResourceVariable)element;
        if (psiResourceVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createResourceFromText"));
        }
        return psiResourceVariable;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeFromText"));
        }
        PsiType psiType = this.createTypeInner(text, context, false);
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeFromText"));
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeElement createTypeElementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeElementFromText"));
        }
        LanguageLevel level = PsiJavaParserFacadeImpl.level(context);
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, TYPE, level), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeElement)) {
            throw new IncorrectOperationException("Incorrect type '" + text + "' (" + (Object)((Object)level) + ")");
        }
        PsiTypeElement psiTypeElement = (PsiTypeElement)element;
        if (psiTypeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeElementFromText"));
        }
        return psiTypeElement;
    }

    protected PsiType createTypeInner(String text, @Nullable PsiElement context, boolean markAsCopy) throws IncorrectOperationException {
        PsiPrimitiveType primitiveType = PRIMITIVE_TYPES.get(text);
        if (primitiveType != null) {
            return primitiveType;
        }
        PsiTypeElement element = this.createTypeElementFromText(text, context);
        if (markAsCopy) {
            GeneratedMarkerVisitor.markGenerated(element);
        }
        return element.getType();
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        boolean mayHaveDiamonds;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createReferenceFromText"));
        }
        boolean isStaticImport = context instanceof PsiImportStaticStatement && !((PsiImportStaticStatement)context).isOnDemand();
        boolean bl = mayHaveDiamonds = context instanceof PsiNewExpression && PsiUtil.getLanguageLevel(context).isAtLeast(LanguageLevel.JDK_1_7);
        JavaParserUtil.ParserWrapper wrapper = isStaticImport ? STATIC_IMPORT_REF : (mayHaveDiamonds ? DIAMOND_REF : REFERENCE);
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, wrapper, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            throw new IncorrectOperationException("Incorrect reference '" + text + "'");
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)element;
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createReferenceFromText"));
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createCodeBlockFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, CODE_BLOCK, PsiJavaParserFacadeImpl.level(context), true), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCodeBlock)) {
            throw new IncorrectOperationException("Incorrect code block '" + text + "'");
        }
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)element;
        if (psiCodeBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createCodeBlockFromText"));
        }
        return psiCodeBlock;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createStatementFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, STATEMENT, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiStatement)) {
            throw new IncorrectOperationException("Incorrect statement '" + text + "'");
        }
        PsiStatement psiStatement = (PsiStatement)element;
        if (psiStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createStatementFromText"));
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createExpressionFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, EXPRESSION, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiExpression)) {
            throw new IncorrectOperationException("Incorrect expression '" + text + "'");
        }
        PsiExpression psiExpression = (PsiExpression)element;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createExpressionFromText"));
        }
        return psiExpression;
    }

    protected PsiJavaFile createDummyJavaFile(@NonNls String text) {
        JavaFileType type2 = JavaFileType.INSTANCE;
        return (PsiJavaFile)PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText(DUMMY_FILE_NAME, type2, (CharSequence)text);
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeParameterFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, TYPE_PARAMETER, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiTypeParameter)) {
            throw new IncorrectOperationException("Incorrect type parameter '" + text + "'");
        }
        PsiTypeParameter psiTypeParameter = (PsiTypeParameter)element;
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createTypeParameterFromText"));
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiComment createCommentFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createCommentFromText"));
        }
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        for (PsiElement aChildren : aFile.getChildren()) {
            if (!(aChildren instanceof PsiComment)) continue;
            if (!aChildren.getText().equals(text)) break;
            PsiComment comment = (PsiComment)aChildren;
            DummyHolderFactory.createHolder(this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree(comment), context);
            PsiComment psiComment = comment;
            if (psiComment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createCommentFromText"));
            }
            return psiComment;
        }
        throw new IncorrectOperationException("Incorrect comment '" + text + "'");
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createEnumConstantFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, ENUM_CONSTANT, PsiJavaParserFacadeImpl.level(context)), context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiEnumConstant)) {
            throw new IncorrectOperationException("Incorrect enum constant '" + text + "'");
        }
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)element;
        if (psiEnumConstant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createEnumConstantFromText"));
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiType createPrimitiveTypeFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createPrimitiveTypeFromText"));
        }
        PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType(text);
        if (primitiveType == null) {
            throw new IncorrectOperationException("Incorrect primitive type '" + text + "'");
        }
        PsiPrimitiveType psiPrimitiveType = primitiveType;
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createPrimitiveTypeFromText"));
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public PsiJavaModule createModuleFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createModuleFromText"));
        }
        DummyHolder holder = DummyHolderFactory.createHolder(this.myManager, new JavaDummyElement(text, MODULE, LanguageLevel.JDK_1_9), null);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiJavaModule)) {
            throw new IncorrectOperationException("Incorrect module declaration '" + text + "'");
        }
        PsiJavaModule psiJavaModule = (PsiJavaModule)element;
        if (psiJavaModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createModuleFromText"));
        }
        return psiJavaModule;
    }

    @Override
    @NotNull
    public PsiType createPrimitiveType(@NotNull String text, @NotNull PsiAnnotation[] annotations2) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createPrimitiveType"));
        }
        if (annotations2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createPrimitiveType"));
        }
        PsiType psiType = this.createPrimitiveTypeFromText(text).annotate(TypeAnnotationProvider.Static.create(annotations2));
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiJavaParserFacadeImpl", "createPrimitiveType"));
        }
        return psiType;
    }

    public static PsiPrimitiveType getPrimitiveType(String text) {
        return PRIMITIVE_TYPES.get(text);
    }

    protected static LanguageLevel level(@Nullable PsiElement context) {
        return context != null && context.isValid() ? PsiUtil.getLanguageLevel(context) : LanguageLevel.HIGHEST;
    }

    private static IncorrectOperationException newException(String msg, DummyHolder holder) {
        Throwable cause;
        FileElement root = holder.getTreeElement();
        if (root instanceof JavaDummyElement && (cause = ((JavaDummyElement)root).getParserError()) != null) {
            return new IncorrectOperationException(msg, cause);
        }
        return new IncorrectOperationException(msg);
    }

    static {
        PRIMITIVE_TYPES.put(PsiType.BYTE.getCanonicalText(), PsiType.BYTE);
        PRIMITIVE_TYPES.put(PsiType.CHAR.getCanonicalText(), PsiType.CHAR);
        PRIMITIVE_TYPES.put(PsiType.DOUBLE.getCanonicalText(), PsiType.DOUBLE);
        PRIMITIVE_TYPES.put(PsiType.FLOAT.getCanonicalText(), PsiType.FLOAT);
        PRIMITIVE_TYPES.put(PsiType.INT.getCanonicalText(), PsiType.INT);
        PRIMITIVE_TYPES.put(PsiType.LONG.getCanonicalText(), PsiType.LONG);
        PRIMITIVE_TYPES.put(PsiType.SHORT.getCanonicalText(), PsiType.SHORT);
        PRIMITIVE_TYPES.put(PsiType.BOOLEAN.getCanonicalText(), PsiType.BOOLEAN);
        PRIMITIVE_TYPES.put(PsiType.VOID.getCanonicalText(), PsiType.VOID);
        PRIMITIVE_TYPES.put(PsiType.NULL.getCanonicalText(), PsiType.NULL);
    }
}

