/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiLiteralStub
extends StubBase<PsiLiteralExpressionImpl> {
    @NotNull
    private final String myLiteralText;
    private volatile IElementType myLiteralType;

    public PsiLiteralStub(StubElement parent, @NotNull String literalText) {
        if (literalText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalText", "com/intellij/psi/impl/java/stubs/impl/PsiLiteralStub", "<init>"));
        }
        super(parent, JavaStubElementTypes.LITERAL_EXPRESSION);
        this.myLiteralText = literalText;
    }

    @NotNull
    public String getLiteralText() {
        String string = this.myLiteralText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiLiteralStub", "getLiteralText"));
        }
        return string;
    }

    @NotNull
    public IElementType getLiteralType() {
        IElementType type2 = this.myLiteralType;
        if (type2 == null) {
            JavaLexer lexer = new JavaLexer(LanguageLevel.HIGHEST);
            lexer.start(this.myLiteralText);
            this.myLiteralType = type2 = lexer.getTokenType();
            assert (type2 != null) : this.myLiteralText;
        }
        IElementType iElementType = type2;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/impl/PsiLiteralStub", "getLiteralType"));
        }
        return iElementType;
    }
}

