/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiCompositeModifierList
extends LightModifierList {
    private final List<PsiModifierList> mySublists;

    public PsiCompositeModifierList(PsiManager manager, List<PsiModifierList> sublists) {
        super(manager);
        this.mySublists = sublists;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        ArrayList annotations2 = new ArrayList();
        for (PsiModifierList list : this.mySublists) {
            ContainerUtil.addAll(annotations2, list.getAnnotations());
        }
        PsiAnnotation[] psiAnnotationArray = annotations2.toArray(new PsiAnnotation[annotations2.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList", "findAnnotation"));
        }
        for (PsiModifierList sublist : this.mySublists) {
            PsiAnnotation annotation = sublist.findAnnotation(qualifiedName);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList", "hasModifierProperty"));
        }
        for (PsiModifierList sublist : this.mySublists) {
            if (!sublist.hasModifierProperty(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/tree/java/PsiCompositeModifierList", "hasExplicitModifier"));
        }
        for (PsiModifierList sublist : this.mySublists) {
            if (!sublist.hasExplicitModifier(name)) continue;
            return true;
        }
        return false;
    }
}

