/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndexingStampInfo {
    final long indexingFileStamp;
    final long indexingContentLength;

    IndexingStampInfo(long indexingFileStamp, long indexingContentLength) {
        this.indexingFileStamp = indexingFileStamp;
        this.indexingContentLength = indexingContentLength;
    }

    public String toString() {
        return "indexed at " + this.indexingFileStamp + " with document size " + this.indexingContentLength;
    }

    public boolean isUpToDate(@Nullable Document document, @NotNull VirtualFile file, @NotNull PsiFile psi) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/IndexingStampInfo", "isUpToDate"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/stubs/IndexingStampInfo", "isUpToDate"));
        }
        if (document == null || FileDocumentManager.getInstance().isDocumentUnsaved(document) || !PsiDocumentManager.getInstance(psi.getProject()).isCommitted(document)) {
            return false;
        }
        return this.indexingFileStamp == file.getTimeStamp() && this.indexingContentLength == (long)document.getTextLength();
    }
}

