/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.UpToDateStubIndexMismatch;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return ServiceManager.getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree readOrBuild(Project var1, VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree readFromVFile(Project var1, VirtualFile var2);

    public boolean isStubReloadingProhibited() {
        return false;
    }

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    protected boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/stubs/StubTreeLoader", "hasPsiInManyProjects"));
        }
        return false;
    }

    @Nullable
    protected IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubTreeLoader", "getIndexingStampInfo"));
        }
        return null;
    }

    @NotNull
    public RuntimeException stubTreeAndIndexDoNotMatch(@NotNull String _message, @NotNull ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile) {
        if (_message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_message", "com/intellij/psi/stubs/StubTreeLoader", "stubTreeAndIndexDoNotMatch"));
        }
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "com/intellij/psi/stubs/StubTreeLoader", "stubTreeAndIndexDoNotMatch"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/stubs/StubTreeLoader", "stubTreeAndIndexDoNotMatch"));
        }
        VirtualFile file = psiFile.getViewProvider().getVirtualFile();
        StubTree stubTreeFromIndex = (StubTree)this.readFromVFile(psiFile.getProject(), file);
        Document document = FileDocumentManager.getInstance().getDocument(file);
        IndexingStampInfo indexingStampInfo = this.getIndexingStampInfo(file);
        boolean upToDate = indexingStampInfo != null && indexingStampInfo.isUpToDate(document, file, psiFile);
        String msg = _message + "\nPlease report the problem to JetBrains with the files attached\n";
        if (upToDate) {
            msg = msg + "INDEXED VERSION IS THE CURRENT ONE";
        }
        msg = msg + " file=" + psiFile;
        msg = msg + ", file.class=" + psiFile.getClass();
        msg = msg + ", file.lang=" + psiFile.getLanguage();
        msg = msg + ", modStamp=" + psiFile.getModificationStamp();
        if (!(psiFile instanceof PsiCompiledElement)) {
            String text = psiFile.getText();
            PsiFile fromText = PsiFileFactory.getInstance(psiFile.getProject()).createFileFromText(psiFile.getName(), psiFile.getFileType(), (CharSequence)text);
            if (fromText.getLanguage().equals(psiFile.getLanguage())) {
                boolean consistent = DebugUtil.psiToString(psiFile, true).equals(DebugUtil.psiToString(fromText, true));
                msg = consistent ? msg + "\n tree consistent" : msg + "\n AST INCONSISTENT, perhaps after incremental reparse; " + fromText;
            }
        }
        msg = msg + "\n stub debugInfo=" + stubTree.getDebugInfo();
        msg = msg + "\nlatestIndexedStub=" + stubTreeFromIndex;
        if (stubTreeFromIndex != null) {
            msg = msg + "\n   same size=" + (stubTree.getPlainList().size() == stubTreeFromIndex.getPlainList().size());
            msg = msg + "\n   debugInfo=" + stubTreeFromIndex.getDebugInfo();
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        msg = msg + "\n viewProvider=" + viewProvider;
        msg = msg + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
        msg = msg + "; file stamp: " + file.getModificationStamp();
        msg = msg + "; file modCount: " + file.getModificationCount();
        msg = msg + "; file length: " + file.getLength();
        if (document != null) {
            msg = msg + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            msg = msg + "; doc stamp: " + document.getModificationStamp();
            msg = msg + "; doc size: " + document.getTextLength();
            msg = msg + "; committed: " + PsiDocumentManager.getInstance(psiFile.getProject()).isCommitted(document);
        }
        msg = msg + "\nin many projects: " + this.hasPsiInManyProjects(file);
        msg = msg + "\nindexing info: " + indexingStampInfo;
        Attachment[] attachments = StubTreeLoader.createAttachments(stubTree, psiFile, file, stubTreeFromIndex);
        RuntimeExceptionWithAttachments runtimeExceptionWithAttachments = upToDate ? StubTreeLoader.handleUpToDateMismatch(msg, attachments) : new RuntimeExceptionWithAttachments(msg, attachments);
        if (runtimeExceptionWithAttachments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubTreeLoader", "stubTreeAndIndexDoNotMatch"));
        }
        return runtimeExceptionWithAttachments;
    }

    private static UpToDateStubIndexMismatch handleUpToDateMismatch(@NotNull String message2, Attachment[] attachments) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/psi/stubs/StubTreeLoader", "handleUpToDateMismatch"));
        }
        return new UpToDateStubIndexMismatch(message2, attachments);
    }

    @NotNull
    private static Attachment[] createAttachments(@NotNull ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile, VirtualFile file, @Nullable StubTree stubTreeFromIndex) {
        if (stubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubTree", "com/intellij/psi/stubs/StubTreeLoader", "createAttachments"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/stubs/StubTreeLoader", "createAttachments"));
        }
        ArrayList<Attachment> attachments = ContainerUtil.newArrayList();
        attachments.add(new Attachment(file.getPath() + "_file.txt", psiFile instanceof PsiCompiledElement ? "compiled" : psiFile.getText()));
        attachments.add(new Attachment("stubTree.txt", ((PsiFileStubImpl)stubTree.getRoot()).printTree()));
        if (stubTreeFromIndex != null) {
            attachments.add(new Attachment("stubTreeFromIndex.txt", ((PsiFileStubImpl)stubTreeFromIndex.getRoot()).printTree()));
        }
        Attachment[] attachmentArray = attachments.toArray(Attachment.EMPTY_ARRAY);
        if (attachmentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubTreeLoader", "createAttachments"));
        }
        return attachmentArray;
    }

    public static String getFileViewProviderMismatchDiagnostics(@NotNull FileViewProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/stubs/StubTreeLoader", "getFileViewProviderMismatchDiagnostics"));
        }
        Function<PsiFile, String> fileClassName = file -> file.getClass().getSimpleName();
        Function<Pair, String> stubRootToString = pair -> "(" + ((IStubFileElementType)pair.first).toString() + ", " + ((IStubFileElementType)pair.first).getLanguage() + " -> " + (String)fileClassName.fun((PsiFile)pair.second) + ")";
        List<Pair<IStubFileElementType, PsiFile>> roots = StubTreeBuilder.getStubbedRoots(provider);
        return "path = " + provider.getVirtualFile().getPath() + ", stubBindingRoot = " + fileClassName.fun(provider.getStubBindingRoot()) + ", languages = [" + StringUtil.join(provider.getLanguages(), Language::getID, ", ") + "], fileTypes = [" + StringUtil.join(provider.getAllFiles(), file -> file.getFileType().getName(), ", ") + "], files = [" + StringUtil.join(provider.getAllFiles(), fileClassName, ", ") + "], roots = [" + StringUtil.join(roots, stubRootToString, ", ") + "]";
    }
}

