/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.MethodSignatureHandMade;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSignatureUtil {
    public static final TObjectHashingStrategy<MethodSignatureBackedByPsiMethod> METHOD_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<MethodSignatureBackedByPsiMethod>(){

        public int computeHashCode(MethodSignatureBackedByPsiMethod signature) {
            return signature.getMethod().hashCode();
        }

        public boolean equals(MethodSignatureBackedByPsiMethod s1, MethodSignatureBackedByPsiMethod s2) {
            return s1.getMethod().equals(s2.getMethod());
        }
    };
    public static final TObjectHashingStrategy<MethodSignature> METHOD_PARAMETERS_ERASURE_EQUALITY = new TObjectHashingStrategy<MethodSignature>(){

        public int computeHashCode(MethodSignature signature) {
            return signature.hashCode();
        }

        public boolean equals(MethodSignature method1, MethodSignature method2) {
            return MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2) && MethodSignatureUtil.areErasedParametersEqual(method1, method2);
        }
    };

    private MethodSignatureUtil() {
    }

    public static boolean areOverrideEquivalent(PsiMethod method1, PsiMethod method2) {
        int typeParamsLength2;
        int typeParamsLength1 = method1.getTypeParameters().length;
        return (typeParamsLength1 == (typeParamsLength2 = method2.getTypeParameters().length) || typeParamsLength1 == 0 || typeParamsLength2 == 0) && MethodSignatureUtil.areErasedParametersEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areErasedParametersEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "com/intellij/psi/util/MethodSignatureUtil", "areErasedParametersEqual"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "com/intellij/psi/util/MethodSignatureUtil", "areErasedParametersEqual"));
        }
        Object[] erased1 = method1 instanceof MethodSignatureBase ? ((MethodSignatureBase)method1).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method1);
        Object[] erased2 = method2 instanceof MethodSignatureBase ? ((MethodSignatureBase)method2).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method2);
        return Arrays.equals(erased1, erased2);
    }

    @NotNull
    public static PsiType[] calcErasedParameterTypes(@NotNull MethodSignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/util/MethodSignatureUtil", "calcErasedParameterTypes"));
        }
        PsiType[] parameterTypes = signature.getParameterTypes();
        if (parameterTypes.length == 0) {
            if (PsiType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "calcErasedParameterTypes"));
            }
            return PsiType.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor = signature.getSubstitutor();
        PsiType[] erasedTypes = PsiType.createArray(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            erasedTypes[i] = TypeConversionUtil.erasure(parameterTypes[i], substitutor);
        }
        if (erasedTypes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "calcErasedParameterTypes"));
        }
        return erasedTypes;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor, false);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        return methodSignature;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor, boolean isConstructor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        MethodSignatureHandMade methodSignatureHandMade = new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor, isConstructor);
        if (methodSignatureHandMade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        return methodSignatureHandMade;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameterList, @NotNull PsiSubstitutor substitutor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterList", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor, false);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        return methodSignature;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameterList, @NotNull PsiSubstitutor substitutor, boolean isConstructor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterList", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        MethodSignatureHandMade methodSignatureHandMade = new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor, isConstructor);
        if (methodSignatureHandMade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "createMethodSignature"));
        }
        return methodSignatureHandMade;
    }

    public static boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "com/intellij/psi/util/MethodSignatureUtil", "areSignaturesEqual"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "com/intellij/psi/util/MethodSignatureUtil", "areSignaturesEqual"));
        }
        return MethodSignatureUtil.areSignaturesEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "com/intellij/psi/util/MethodSignatureUtil", "areSignaturesEqual"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "com/intellij/psi/util/MethodSignatureUtil", "areSignaturesEqual"));
        }
        if (method2 == method1) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2)) {
            return false;
        }
        return MethodSignatureUtil.checkSignaturesEqualInner(method1, method2, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method1, method2)) || MethodSignatureUtil.checkSignaturesEqualInner(method2, method1, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method2, method1));
    }

    private static boolean checkSignaturesEqualInner(@NotNull MethodSignature subSignature, @NotNull MethodSignature superSignature, PsiSubstitutor unifyingSubstitutor) {
        if (subSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subSignature", "com/intellij/psi/util/MethodSignatureUtil", "checkSignaturesEqualInner"));
        }
        if (superSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignature", "com/intellij/psi/util/MethodSignatureUtil", "checkSignaturesEqualInner"));
        }
        if (unifyingSubstitutor == null) {
            return false;
        }
        if (!MethodSignatureUtil.areErasedParametersEqual(subSignature, superSignature)) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type2;
            PsiType type1 = unifyingSubstitutor.substitute(subParameterTypes[i]);
            if (Comparing.equal(type1, type2 = unifyingSubstitutor.substitute(superParameterTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean areSignaturesEqualLightweight(@NotNull MethodSignature sig1, @NotNull MethodSignature sig2) {
        PsiType[] parameterTypes2;
        String name2;
        String name1;
        boolean isConstructor2;
        if (sig1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sig1", "com/intellij/psi/util/MethodSignatureUtil", "areSignaturesEqualLightweight"));
        }
        if (sig2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sig2", "com/intellij/psi/util/MethodSignatureUtil", "areSignaturesEqualLightweight"));
        }
        boolean isConstructor1 = sig1.isConstructor();
        if (isConstructor1 != (isConstructor2 = sig2.isConstructor())) {
            return false;
        }
        if (!(isConstructor1 && (sig1 instanceof HierarchicalMethodSignature || sig2 instanceof HierarchicalMethodSignature) || (name1 = sig1.getName()).equals(name2 = sig2.getName()))) {
            return false;
        }
        PsiType[] parameterTypes1 = sig1.getParameterTypes();
        if (parameterTypes1.length != (parameterTypes2 = sig2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < parameterTypes1.length; ++i) {
            PsiType type1 = parameterTypes1[i];
            PsiType type2 = parameterTypes2[i];
            if (type1 instanceof PsiPrimitiveType != type2 instanceof PsiPrimitiveType) {
                return false;
            }
            if (!(type1 instanceof PsiPrimitiveType) || type1.equals(type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperMethod(@NotNull PsiMethod superMethodCandidate, @NotNull PsiMethod derivedMethod) {
        if (superMethodCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodCandidate", "com/intellij/psi/util/MethodSignatureUtil", "isSuperMethod"));
        }
        if (derivedMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedMethod", "com/intellij/psi/util/MethodSignatureUtil", "isSuperMethod"));
        }
        PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
        PsiClass derivedClass = derivedMethod.getContainingClass();
        if (derivedClass == null || superClassCandidate == null || derivedClass == superClassCandidate) {
            return false;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(superClassCandidate, derivedClass, PsiSubstitutor.EMPTY, null);
        if (superSubstitutor == null) {
            return false;
        }
        MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
        MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.isSubsignature(superSignature, derivedSignature);
    }

    @Nullable
    public static PsiMethod findMethodInSuperClassBySignatureInDerived(@NotNull PsiClass aClass, @NotNull PsiClass superClass, @NotNull MethodSignature signature, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/MethodSignatureUtil", "findMethodInSuperClassBySignatureInDerived"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/util/MethodSignatureUtil", "findMethodInSuperClassBySignatureInDerived"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/util/MethodSignatureUtil", "findMethodInSuperClassBySignatureInDerived"));
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(superClass, superSubstitutor, signature, checkDeep);
    }

    @Nullable
    private static PsiMethod doFindMethodInSuperClassBySignatureInDerived(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull MethodSignature signature, boolean checkDeep) {
        PsiClass clazz;
        PsiMethod[] methods;
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/psi/util/MethodSignatureUtil", "doFindMethodInSuperClassBySignatureInDerived"));
        }
        if (superSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSubstitutor", "com/intellij/psi/util/MethodSignatureUtil", "doFindMethodInSuperClassBySignatureInDerived"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/util/MethodSignatureUtil", "doFindMethodInSuperClassBySignatureInDerived"));
        }
        String name = signature.getName();
        for (PsiMethod method : methods = superClass.findMethodsByName(name, false)) {
            if (!MethodSignatureUtil.isSubsignature(method.getSignature(superSubstitutor), signature)) continue;
            return method;
        }
        if (checkDeep && (clazz = superClass.getSuperClass()) != null && clazz != superClass) {
            PsiSubstitutor substitutor1 = TypeConversionUtil.getSuperClassSubstitutor(clazz, superClass, superSubstitutor);
            return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(clazz, substitutor1, signature, true);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod pattenMethod, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/MethodSignatureUtil", "findMethodBySignature"));
        }
        if (pattenMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattenMethod", "com/intellij/psi/util/MethodSignatureUtil", "findMethodBySignature"));
        }
        return MethodSignatureUtil.findMethodBySignature(aClass, pattenMethod.getSignature(PsiSubstitutor.EMPTY), checkBases);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull MethodSignature methodSignature, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/MethodSignatureUtil", "findMethodBySignature"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/psi/util/MethodSignatureUtil", "findMethodBySignature"));
        }
        String name = methodSignature.isConstructor() ? aClass.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!methodSignature.equals(foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperSignature(@NotNull PsiClass aClass, @NotNull MethodSignature methodSignature, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/MethodSignatureUtil", "findMethodBySuperSignature"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/psi/util/MethodSignatureUtil", "findMethodBySuperSignature"));
        }
        String name = methodSignature.isConstructor() ? aClass.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!MethodSignatureUtil.isSubsignature(methodSignature, foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/MethodSignatureUtil", "findMethodBySuperMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/MethodSignatureUtil", "findMethodBySuperMethod"));
        }
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(method.getName(), checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            MethodSignature superSignature;
            PsiSubstitutor superSubstitutor;
            PsiMethod candidate = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature candidateSignature = candidate.getSignature(substitutor);
            PsiClass methodClass = method.getContainingClass();
            PsiClass candidateClass = candidate.getContainingClass();
            if (methodClass == null || candidateClass == null || (superSubstitutor = TypeConversionUtil.getClassSubstitutor(methodClass, candidateClass, substitutor)) == null || !MethodSignatureUtil.isSubsignature(superSignature = method.getSignature(superSubstitutor), candidateSignature)) continue;
            return candidate;
        }
        return null;
    }

    public static boolean hasOverloads(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/MethodSignatureUtil", "hasOverloads"));
        }
        return MethodSignatureUtil.getOverloads(method).length > 1;
    }

    @NotNull
    public static PsiMethod[] getOverloads(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/util/MethodSignatureUtil", "getOverloads"));
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            PsiMethod[] psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "getOverloads"));
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = aClass.findMethodsByName(method.getName(), false);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "getOverloads"));
        }
        return psiMethodArray;
    }

    public static boolean areParametersErasureEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "com/intellij/psi/util/MethodSignatureUtil", "areParametersErasureEqual"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "com/intellij/psi/util/MethodSignatureUtil", "areParametersErasureEqual"));
        }
        if (method1.getParameterList().getParametersCount() != method2.getParameterList().getParametersCount()) {
            return false;
        }
        return MethodSignatureUtil.areSignaturesErasureEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesErasureEqual(@NotNull MethodSignature signature1, @NotNull MethodSignature signature2) {
        if (signature1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature1", "com/intellij/psi/util/MethodSignatureUtil", "areSignaturesErasureEqual"));
        }
        if (signature2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature2", "com/intellij/psi/util/MethodSignatureUtil", "areSignaturesErasureEqual"));
        }
        return METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)signature1, (Object)signature2);
    }

    @Nullable
    public static PsiSubstitutor getSuperMethodSignatureSubstitutor(@NotNull MethodSignature methodSignature, @NotNull MethodSignature superMethodSignature) {
        PsiTypeParameter[] superTypeParameters;
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/psi/util/MethodSignatureUtil", "getSuperMethodSignatureSubstitutor"));
        }
        if (superMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignature", "com/intellij/psi/util/MethodSignatureUtil", "getSuperMethodSignatureSubstitutor"));
        }
        PsiTypeParameter[] methodTypeParameters = methodSignature.getTypeParameters();
        if (methodTypeParameters.length != (superTypeParameters = superMethodSignature.getTypeParameters()).length) {
            return null;
        }
        PsiSubstitutor result = superMethodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiElementFactory factory = JavaPsiFacade.getInstance(methodTypeParameter.getProject()).getElementFactory();
            result = result.put(superTypeParameters[i], factory.createType(methodTypeParameter));
        }
        PsiSubstitutor methodSubstitutor = methodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiTypeParameter superTypeParameter = superTypeParameters[i];
            HashSet<PsiType> methodSupers = new HashSet<PsiType>();
            for (PsiClassType methodSuper : methodTypeParameter.getSuperTypes()) {
                methodSupers.add(methodSubstitutor.substitute(methodSuper));
            }
            HashSet<PsiType> superSupers = new HashSet<PsiType>();
            for (PsiClassType superSuper : superTypeParameter.getSuperTypes()) {
                superSupers.add(methodSubstitutor.substitute(result.substitute(superSuper)));
            }
            methodSupers.remove(PsiType.getJavaLangObject(methodTypeParameter.getManager(), methodTypeParameter.getResolveScope()));
            superSupers.remove(PsiType.getJavaLangObject(superTypeParameter.getManager(), superTypeParameter.getResolveScope()));
            if (methodSupers.equals(superSupers)) continue;
            return null;
        }
        return result;
    }

    @NotNull
    public static PsiSubstitutor combineSubstitutors(@NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        PsiTypeParameter[] typeParameters;
        if (substitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor1", "com/intellij/psi/util/MethodSignatureUtil", "combineSubstitutors"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor2", "com/intellij/psi/util/MethodSignatureUtil", "combineSubstitutors"));
        }
        if (substitutor1 == PsiSubstitutor.EMPTY) {
            PsiSubstitutor psiSubstitutor = substitutor2;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "combineSubstitutors"));
            }
            return psiSubstitutor;
        }
        Set<PsiTypeParameter> parameters1 = substitutor1.getSubstitutionMap().keySet();
        for (PsiTypeParameter typeParameter : typeParameters = parameters1.toArray(new PsiTypeParameter[parameters1.size()])) {
            PsiClass resolved;
            PsiType type2 = substitutor1.substitute(typeParameter);
            PsiType otherSubstituted = type2 instanceof PsiClassType ? ((resolved = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter ? substitutor2.substitute((PsiTypeParameter)resolved) : substitutor2.substitute(type2)) : substitutor2.substitute(type2);
            substitutor1 = substitutor1.put(typeParameter, otherSubstituted);
        }
        PsiSubstitutor psiSubstitutor = substitutor1;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "combineSubstitutors"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public static PsiMethod[] convertMethodSignaturesToMethods(@NotNull List<? extends MethodSignatureBackedByPsiMethod> sameNameMethodList) {
        if (sameNameMethodList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sameNameMethodList", "com/intellij/psi/util/MethodSignatureUtil", "convertMethodSignaturesToMethods"));
        }
        PsiMethod[] methods = new PsiMethod[sameNameMethodList.size()];
        for (int i = 0; i < sameNameMethodList.size(); ++i) {
            methods[i] = sameNameMethodList.get(i).getMethod();
        }
        if (methods == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/MethodSignatureUtil", "convertMethodSignaturesToMethods"));
        }
        return methods;
    }

    public static boolean isSubsignature(@NotNull MethodSignature superSignature, @NotNull MethodSignature subSignature) {
        if (superSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superSignature", "com/intellij/psi/util/MethodSignatureUtil", "isSubsignature"));
        }
        if (subSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subSignature", "com/intellij/psi/util/MethodSignatureUtil", "isSubsignature"));
        }
        if (subSignature == superSignature) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(superSignature, subSignature)) {
            return false;
        }
        PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(subSignature, superSignature);
        if (MethodSignatureUtil.checkSignaturesEqualInner(superSignature, subSignature, unifyingSubstitutor)) {
            return true;
        }
        if (subSignature.getTypeParameters().length > 0) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type1 = subParameterTypes[i];
            PsiType type2 = TypeConversionUtil.erasure(superParameterTypes[i], superSignature.getSubstitutor());
            if (Comparing.equal(type1, type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isReturnTypeSubstitutable(MethodSignature d1, MethodSignature d2, PsiType r1, PsiType r2) {
        if (PsiType.VOID.equals(r1)) {
            return PsiType.VOID.equals(r2);
        }
        if (r1 instanceof PsiPrimitiveType) {
            return r1.equals(r2);
        }
        if (r1 instanceof PsiClassType && r2 != null) {
            PsiSubstitutor adaptingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(d2, d1);
            if (adaptingSubstitutor != null && r2.isAssignableFrom(adaptingSubstitutor.substitute(r1))) {
                return true;
            }
            if (!MethodSignatureUtil.areSignaturesEqual(d1, d2)) {
                return r1.equals(TypeConversionUtil.erasure(r2));
            }
        }
        return Comparing.equal(r1, r2);
    }
}

