/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Function;

public class PsiExpressionTrimRenderer
extends JavaRecursiveElementWalkingVisitor {
    private final StringBuilder myBuf;

    public PsiExpressionTrimRenderer(StringBuilder buf) {
        this.myBuf = buf;
    }

    @Override
    public void visitExpression(PsiExpression expression2) {
        this.myBuf.append(expression2.getText());
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        expression2.getOperand().accept(this);
        this.myBuf.append(" ").append("instanceof").append(" ");
        PsiTypeElement checkType = expression2.getCheckType();
        if (checkType != null) {
            this.myBuf.append(checkType.getText());
        }
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.myBuf.append("(");
        PsiExpression expr = expression2.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        this.myBuf.append(")");
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        PsiExpression operand2;
        PsiTypeElement castType = expression2.getCastType();
        if (castType != null) {
            this.myBuf.append("(").append(castType.getText()).append(")");
        }
        if ((operand2 = expression2.getOperand()) != null) {
            operand2.accept(this);
        }
    }

    @Override
    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        expression2.getArrayExpression().accept(this);
        this.myBuf.append("[");
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
        }
        this.myBuf.append("]");
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        this.myBuf.append(expression2.getOperationSign().getText());
        PsiExpression operand2 = expression2.getOperand();
        if (operand2 != null) {
            operand2.accept(this);
        }
    }

    @Override
    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        expression2.getOperand().accept(this);
        this.myBuf.append(expression2.getOperationSign().getText());
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        PsiExpression[] operands2 = expression2.getOperands();
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression operand2 = operands2[i];
            if (i != 0) {
                PsiJavaToken token = expression2.getTokenBeforeOperand(operand2);
                this.myBuf.append(" ").append(token.getText()).append(" ");
            }
            operand2.accept(this);
        }
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        boolean addParenthesis;
        PsiParameterList parameterList = expression2.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiElement firstChild = parameterList.getFirstChild();
        boolean bl = addParenthesis = firstChild instanceof PsiJavaToken && ((PsiJavaToken)firstChild).getTokenType() == JavaTokenType.LPARENTH;
        if (addParenthesis) {
            this.myBuf.append('(');
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiTypeElement typeElement;
            PsiParameter parameter = parameters2[i];
            if (i != 0) {
                this.myBuf.append(", ");
            }
            int formatOptions = 1 | ((typeElement = parameter.getTypeElement()) == null ? 0 : 2);
            this.myBuf.append(PsiFormatUtil.formatVariable(parameter, formatOptions, PsiSubstitutor.EMPTY));
        }
        if (addParenthesis) {
            this.myBuf.append(')');
        }
        this.myBuf.append(" -> {...}");
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        expression2.getCondition().accept(this);
        this.myBuf.append(" ? ");
        PsiExpression thenExpression2 = expression2.getThenExpression();
        if (thenExpression2 != null) {
            thenExpression2.accept(this);
        }
        this.myBuf.append(" : ");
        PsiExpression elseExpression2 = expression2.getElseExpression();
        if (elseExpression2 != null) {
            elseExpression2.accept(this);
        }
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        expression2.getLExpression().accept(this);
        this.myBuf.append(expression2.getOperationSign().getText());
        PsiExpression rExpression = expression2.getRExpression();
        if (rExpression != null) {
            rExpression.accept(this);
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expr) {
        PsiExpression qualifierExpression2 = expr.getQualifierExpression();
        if (qualifierExpression2 != null) {
            qualifierExpression2.accept(this);
            this.myBuf.append(".");
        }
        this.myBuf.append(expr.getReferenceName());
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expr) {
        expr.getMethodExpression().accept(this);
        expr.getArgumentList().accept(this);
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        PsiElement qualifier = expression2.getQualifier();
        if (qualifier != null) {
            qualifier.accept(this);
        }
        this.myBuf.append("::");
        this.myBuf.append(expression2.getReferenceName());
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        this.myBuf.append("{");
        boolean first = true;
        for (PsiExpression expr : expression2.getInitializers()) {
            if (!first) {
                this.myBuf.append(", ");
            }
            first = false;
            expr.accept(this);
        }
        this.myBuf.append("}");
    }

    @Override
    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] args = list.getExpressions();
        if (args.length > 0) {
            this.myBuf.append("(...)");
        } else {
            this.myBuf.append("()");
        }
    }

    @Override
    public void visitNewExpression(PsiNewExpression expr) {
        PsiAnonymousClass anonymousClass = expr.getAnonymousClass();
        PsiExpressionList argumentList = expr.getArgumentList();
        if (anonymousClass != null) {
            this.myBuf.append("new").append(" ").append(anonymousClass.getBaseClassType().getPresentableText());
            if (argumentList != null) {
                argumentList.accept(this);
            }
            this.myBuf.append(" {...}");
        } else {
            PsiJavaCodeReferenceElement reference = expr.getClassReference();
            if (reference != null) {
                PsiArrayInitializerExpression arrayInitializer;
                int dimensions;
                this.myBuf.append("new").append(" ").append(reference.getText());
                PsiExpression[] arrayDimensions = expr.getArrayDimensions();
                PsiType type2 = expr.getType();
                int n = dimensions = type2 != null ? type2.getArrayDimensions() : arrayDimensions.length;
                if (arrayDimensions.length > 0) {
                    this.myBuf.append("[");
                }
                int arrayDimensionsLength = arrayDimensions.length;
                for (int i = 0; i < dimensions; ++i) {
                    PsiExpression dimension;
                    PsiExpression psiExpression = dimension = i < arrayDimensionsLength ? arrayDimensions[i] : null;
                    if (i > 0) {
                        this.myBuf.append("][");
                    }
                    if (dimension == null) continue;
                    dimension.accept(this);
                }
                if (arrayDimensions.length > 0) {
                    this.myBuf.append("]");
                }
                if (argumentList != null) {
                    argumentList.accept(this);
                }
                if ((arrayInitializer = expr.getArrayInitializer()) != null) {
                    arrayInitializer.accept(this);
                }
            } else {
                this.myBuf.append(expr.getText());
            }
        }
    }

    public static String render(PsiExpression expression2) {
        return PsiExpressionTrimRenderer.render(expression2, 100);
    }

    public static String render(PsiExpression expression2, int maxLength) {
        StringBuilder buf = new StringBuilder();
        expression2.accept(new PsiExpressionTrimRenderer(buf));
        String text = buf.toString();
        int firstNewLinePos = text.indexOf(10);
        String trimmedText = text.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(maxLength, text.length()));
        if (trimmedText.length() != text.length()) {
            trimmedText = trimmedText + " ...";
        }
        return trimmedText;
    }

    public static class RenderFunction
    implements Function<PsiExpression, String> {
        @Override
        public String fun(PsiExpression psiExpression) {
            return PsiExpressionTrimRenderer.render(psiExpression);
        }
    }
}

