/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightVirtualFile
extends LightVirtualFileBase {
    private CharSequence myContent;
    private Language myLanguage;

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        this(name, "");
    }

    public LightVirtualFile(@NonNls @NotNull String name, @NotNull CharSequence content) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        this(name, fileType, text, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(VirtualFile original, @NotNull CharSequence text, long modificationStamp) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        this(original.getName(), original.getFileType(), text, modificationStamp);
        this.setCharset(original.getCharset());
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text, long modificationStamp) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        this(name, fileType, text, CharsetUtil.extractCharsetFromFileContent(null, null, fileType, text), modificationStamp);
    }

    public LightVirtualFile(@NotNull String name, FileType fileType, @NotNull CharSequence text, Charset charset, long modificationStamp) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        super(name, fileType, modificationStamp);
        this.myContent = "";
        this.myContent = text;
        this.setCharset(charset);
    }

    public LightVirtualFile(@NotNull String name, Language language, @NotNull CharSequence text) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/LightVirtualFile", "<init>"));
        }
        super(name, null, LocalTimeCounter.currentTime());
        this.myContent = "";
        this.myContent = text;
        this.setLanguage(language);
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public void setLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/testFramework/LightVirtualFile", "setLanguage"));
        }
        this.myLanguage = language;
        FileType type2 = language.getAssociatedFileType();
        if (type2 == null) {
            type2 = FileTypeRegistry.getInstance().getFileTypeByFileName(this.getName());
        }
        this.setFileType(type2);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.contentsToByteArray(), this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        this.assertWritable();
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                assert (LightVirtualFile.this.isWritable());
                LightVirtualFile.this.setModificationStamp(newModificationStamp);
                try {
                    LightVirtualFile.this.myContent = this.toString(LightVirtualFile.this.getCharset().name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }, this);
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "getOutputStream"));
        }
        return outputStream;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = this.getContent().toString();
        byte[] byArray = s.getBytes(charset.name());
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    public void setContent(Object requestor, @NotNull CharSequence content, boolean fireEvent) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/LightVirtualFile", "setContent"));
        }
        this.assertWritable();
        this.myContent = content;
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    @NotNull
    public CharSequence getContent() {
        CharSequence charSequence = this.myContent;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightVirtualFile", "getContent"));
        }
        return charSequence;
    }

    @Override
    public String toString() {
        return "LightVirtualFile: " + this.getPresentableUrl();
    }
}

