/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBAutoscroller
implements ActionListener {
    private static final int SCROLL_UPDATE_INTERVAL = 15;
    private static final Key<ScrollDeltaProvider> SCROLL_HANDLER_KEY = Key.create("JBAutoScroller.AutoScrollHandler");
    private static final JBAutoscroller INSTANCE = new JBAutoscroller();
    private final Timer myTimer = UIUtil.createNamedTimer("JBAutoScroller", 15, this);
    private final DefaultScrollDeltaProvider myDefaultAutoScrollHandler = new DefaultScrollDeltaProvider();
    private SyntheticDragEvent myLatestDragEvent;
    private int myHorizontalScrollDelta;
    private int myVerticalScrollDelta;

    private JBAutoscroller() {
    }

    public static void installOn(@NotNull JComponent component, @Nullable AutoscrollLocker locker) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/JBAutoscroller", "installOn"));
        }
        JBAutoscroller.installOn(component, null, locker);
    }

    public static void installOn(@NotNull JComponent component, @Nullable ScrollDeltaProvider handler) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/JBAutoscroller", "installOn"));
        }
        JBAutoscroller.installOn(component, handler, null);
    }

    public static void installOn(@NotNull JComponent component, @Nullable ScrollDeltaProvider handler, @Nullable AutoscrollLocker locker) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/JBAutoscroller", "installOn"));
        }
        JBAutoscroller.getInstance().doInstallOn(component, handler, locker);
    }

    private static JBAutoscroller getInstance() {
        return INSTANCE;
    }

    private void doInstallOn(@NotNull JComponent component, @Nullable ScrollDeltaProvider handler, @Nullable AutoscrollLocker locker) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/JBAutoscroller", "doInstallOn"));
        }
        component.setAutoscrolls(false);
        if (handler != null) {
            component.putClientProperty(SCROLL_HANDLER_KEY, handler);
        }
        if (component instanceof JTable) {
            JTable t = (JTable)component;
            new MoveTableCellEditorOnAutoscrollFix(t);
            new ScrollOnTableSelectionChangeFix(t, locker);
        }
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JBAutoscroller.this.start();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JBAutoscroller.this.stop();
            }
        });
        component.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e instanceof SyntheticDragEvent) {
                    return;
                }
                JComponent c = (JComponent)e.getComponent();
                ScrollDeltaProvider handler = (ScrollDeltaProvider)c.getClientProperty(SCROLL_HANDLER_KEY);
                handler = ObjectUtils.notNull(handler, JBAutoscroller.this.myDefaultAutoScrollHandler);
                JBAutoscroller.this.myVerticalScrollDelta = handler.getVerticalScrollDelta(e);
                JBAutoscroller.this.myHorizontalScrollDelta = handler.getHorizontalScrollDelta(e);
                JBAutoscroller.this.myLatestDragEvent = new SyntheticDragEvent(c, e.getID(), e.getWhen(), e.getModifiers(), c.getX(), c.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            }
        });
    }

    private void start() {
        this.myVerticalScrollDelta = 0;
        this.myHorizontalScrollDelta = 0;
        this.myTimer.start();
    }

    private void stop() {
        this.myTimer.stop();
        this.myLatestDragEvent = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.myLatestDragEvent == null) {
            return;
        }
        JComponent component = (JComponent)this.myLatestDragEvent.getComponent();
        if (!component.isShowing()) {
            this.stop();
            return;
        }
        if (this.autoscroll()) {
            this.fireSyntheticDragEvent(e);
        }
    }

    private void fireSyntheticDragEvent(ActionEvent e) {
        Component component = this.myLatestDragEvent.getComponent();
        Point componentOnScreen = component.getLocationOnScreen();
        int xScreen = this.myLatestDragEvent.getXOnScreen();
        int yScreen = this.myLatestDragEvent.getYOnScreen();
        int x = xScreen - componentOnScreen.x;
        int y = yScreen - componentOnScreen.y;
        SyntheticDragEvent dragEvent = new SyntheticDragEvent(component, this.myLatestDragEvent.getID(), e.getWhen(), this.myLatestDragEvent.getModifiers(), x, y, xScreen, yScreen, this.myLatestDragEvent.getClickCount(), this.myLatestDragEvent.isPopupTrigger(), this.myLatestDragEvent.getButton());
        for (MouseMotionListener l : component.getMouseMotionListeners()) {
            l.mouseDragged(dragEvent);
        }
    }

    private boolean autoscroll() {
        JScrollPane scrollPane = UIUtil.getParentOfType(JScrollPane.class, this.myLatestDragEvent.getComponent());
        if (scrollPane == null) {
            return false;
        }
        boolean scrolled = JBAutoscroller.scroll(scrollPane.getVerticalScrollBar(), this.myVerticalScrollDelta);
        return scrolled |= JBAutoscroller.scroll(scrollPane.getHorizontalScrollBar(), this.myHorizontalScrollDelta);
    }

    private boolean isRunningOn(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/JBAutoscroller", "isRunningOn"));
        }
        return this.myLatestDragEvent != null && this.myLatestDragEvent.getComponent() == component;
    }

    private static boolean scroll(@Nullable JScrollBar scrollBar, int delta) {
        if (scrollBar == null || delta == 0) {
            return false;
        }
        int oldValue = scrollBar.getValue();
        scrollBar.setValue(scrollBar.getValue() + delta);
        return oldValue != scrollBar.getValue();
    }

    private static class ScrollOnTableSelectionChangeFix
    implements ListSelectionListener,
    PropertyChangeListener {
        private final JTable myTable;
        private final AutoscrollLocker myLocker;

        public ScrollOnTableSelectionChangeFix(JTable table, AutoscrollLocker locker) {
            this.myTable = table;
            this.myLocker = locker;
            this.myTable.addPropertyChangeListener("selectionModel", this);
            this.myTable.addPropertyChangeListener("columnModel", this);
            this.addSelectionListener(this.getRowSelectionModel());
            this.addSelectionListener(this.getColumnSelectionModel());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean validCol;
            if (e.getValueIsAdjusting() || JBAutoscroller.getInstance().isRunningOn(this.myTable) || this.locked()) {
                return;
            }
            int row = ScrollOnTableSelectionChangeFix.getLeadSelectionIndexIfSelectionIsNotEmpty(this.getRowSelectionModel());
            int col = ScrollOnTableSelectionChangeFix.getLeadSelectionIndexIfSelectionIsNotEmpty(this.getColumnSelectionModel());
            boolean validRow = (row >= 0 || this.myTable.getRowCount() == 0) && row < this.myTable.getRowCount();
            boolean bl = validCol = (col >= 0 || this.myTable.getColumnCount() == 0) && col < this.myTable.getColumnCount();
            if (validRow && validCol) {
                this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, col, false));
            }
        }

        private boolean locked() {
            return this.myLocker != null && this.myLocker.locked();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ListSelectionModel oldSelectionModel = null;
            ListSelectionModel newSelectionModel = null;
            if ("selectionModel".equals(evt.getPropertyName())) {
                oldSelectionModel = (ListSelectionModel)evt.getOldValue();
                newSelectionModel = (ListSelectionModel)evt.getNewValue();
            } else if ("columnModel".equals(evt.getPropertyName())) {
                TableColumnModel oldColumnModel = (TableColumnModel)evt.getOldValue();
                oldSelectionModel = oldColumnModel != null ? oldColumnModel.getSelectionModel() : null;
                TableColumnModel newColumnModel = (TableColumnModel)evt.getNewValue();
                newSelectionModel = newColumnModel != null ? newColumnModel.getSelectionModel() : null;
            }
            this.removeSelectionListener(oldSelectionModel);
            this.addSelectionListener(newSelectionModel);
        }

        @Nullable
        private ListSelectionModel getRowSelectionModel() {
            return this.myTable.getSelectionModel();
        }

        @Nullable
        private ListSelectionModel getColumnSelectionModel() {
            return this.myTable.getColumnModel().getSelectionModel();
        }

        private void removeSelectionListener(@Nullable ListSelectionModel from) {
            if (from != null) {
                from.removeListSelectionListener(this);
            }
        }

        private void addSelectionListener(@Nullable ListSelectionModel to) {
            if (to != null) {
                to.addListSelectionListener(this);
            }
        }

        private static int getLeadSelectionIndexIfSelectionIsNotEmpty(ListSelectionModel lsm) {
            return lsm != null && !lsm.isSelectionEmpty() ? lsm.getLeadSelectionIndex() : -1;
        }
    }

    private static class MoveTableCellEditorOnAutoscrollFix
    implements AdjustmentListener,
    PropertyChangeListener {
        private final JTable myTable;

        public MoveTableCellEditorOnAutoscrollFix(JTable table) {
            this.myTable = table;
            JScrollPane scrollPane = UIUtil.getParentOfType(JScrollPane.class, this.myTable);
            assert (scrollPane != null) : "MoveTableCellEditorOnAutoscrollFix can only be applied to tables having a scrollpane as it's parent!";
            scrollPane.addPropertyChangeListener(this);
            this.addScrollBarListener(scrollPane.getHorizontalScrollBar());
            this.addScrollBarListener(scrollPane.getVerticalScrollBar());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("horizontalScrollBar".equals(propertyName) || "verticalScrollBar".equals(propertyName)) {
                this.removeScrollBarListener(ObjectUtils.tryCast(evt.getOldValue(), JScrollBar.class));
                this.addScrollBarListener(ObjectUtils.tryCast(evt.getNewValue(), JScrollBar.class));
            }
        }

        private void addScrollBarListener(@Nullable JScrollBar to) {
            if (to != null) {
                to.addAdjustmentListener(this);
            }
        }

        private void removeScrollBarListener(@Nullable JScrollBar from) {
            if (from != null) {
                from.removeAdjustmentListener(this);
            }
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            this.moveCellEditor();
        }

        private void moveCellEditor() {
            int column = this.myTable.getEditingColumn();
            int row = this.myTable.getEditingRow();
            Component editor = this.myTable.getEditorComponent();
            if (column == -1 || row == -1 || editor == null) {
                return;
            }
            Rectangle cellRect = this.myTable.getCellRect(row, column, false);
            Rectangle visibleRect = this.myTable.getVisibleRect();
            if (visibleRect.intersects(cellRect)) {
                return;
            }
            Rectangle editorBounds = editor.getBounds();
            if (!visibleRect.intersects(editorBounds)) {
                return;
            }
            editorBounds.x = cellRect.x;
            editorBounds.y = cellRect.y;
            editor.setBounds(editorBounds);
        }
    }

    private static class SyntheticDragEvent
    extends MouseEvent {
        public SyntheticDragEvent(Component source, int id, long when, int modifiers, int x, int y, int xAbs, int yAbs, int clickCount, boolean popupTrigger, int button) {
            super(source, id, when, modifiers, x, y, xAbs, yAbs, clickCount, popupTrigger, button);
        }
    }

    public static class AutoscrollLocker {
        private boolean locked;

        public boolean locked() {
            return this.locked;
        }

        public void runWithLock(Runnable runnable) {
            try {
                this.locked = true;
                runnable.run();
            }
            finally {
                this.locked = false;
            }
        }
    }

    public static class DefaultScrollDeltaProvider
    implements ScrollDeltaProvider {
        @Override
        public int getVerticalScrollDelta(MouseEvent e) {
            Rectangle visibleRect = ((JComponent)e.getComponent()).getVisibleRect();
            return this.getScrollDelta(visibleRect.y, visibleRect.y + visibleRect.height - 1, e.getY());
        }

        @Override
        public int getHorizontalScrollDelta(MouseEvent e) {
            Rectangle visibleRect = ((JComponent)e.getComponent()).getVisibleRect();
            return this.getScrollDelta(visibleRect.x, visibleRect.x + visibleRect.width - 1, e.getX());
        }

        protected int getScrollDelta(int low, int high, int value2) {
            return value2 - (value2 > high ? high : (value2 < low ? low : value2));
        }
    }

    public static interface ScrollDeltaProvider {
        public int getHorizontalScrollDelta(MouseEvent var1);

        public int getVerticalScrollDelta(MouseEvent var1);
    }
}

