/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.LinkedHashSet;
import java.util.Set;

public class Chunk<Node> {
    private final Set<Node> myNodes;

    public Chunk(Node node) {
        this(new LinkedHashSet());
        this.myNodes.add(node);
    }

    public Chunk(Set<Node> nodes) {
        this.myNodes = nodes;
    }

    public Set<Node> getNodes() {
        return this.myNodes;
    }

    public boolean containsNode(Node node) {
        return this.myNodes.contains(node);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Chunk)) {
            return false;
        }
        Chunk chunk = (Chunk)o;
        return this.myNodes.equals(chunk.myNodes);
    }

    public int hashCode() {
        return this.myNodes.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (Node node : this.myNodes) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append(node.toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

